const express = require("express");
const fs = require("fs");
const multer = require("multer");
const mysql = require("mysql2");
const bcrypt = require("bcryptjs");
const xlsx = require("xlsx");
const path = require("path");

const router = express.Router();
const app = express();
app.use(express.json());

const { promisePool } = require("./db");
const { getPoolByUserId } = require('./databaseSelector');

router.post("/register", async (req, res) => {
  try {
    const { username, email, password } = req.body;
    console.log(username, email, password);

    const passwordHash =  bcrypt.hashSync(password, 10);

    const sql = `
          INSERT INTO Users (Username, PasswordHash, Email, Status, isAdmin)
          VALUES (?, ?, ?, 0, 0)
        `;

    const [result] = await promisePool.execute(sql, [
      username,
      passwordHash,
      email,
    ]);

    const authSql = `
        INSERT INTO ButtonAuth (UserId, Username)
        VALUES (?,?)
      `;
    const [authResult] = await promisePool.execute(authSql, [
      result.insertId,
      username,
    ]);
    console.log("User registered successfully:", result.insertId);
    res
      .status(201)
      .send({
        message: "User registered successfully",
        userId: result.insertId,
      });
  } catch (error) {
    console.error(error);

    if (error.code === "ER_DUP_ENTRY") {
      res.status(400).send({ error: "Username already exists" });
    } else {
      res
        .status(500)
        .send({ error: "An error occurred while registering the user" });
    }
  }
});


router.post("/login", async (req, res) => {
  try {
    const { username, password } = req.body;
    console.log(username, password);

    const sql = `
       SELECT 
        u.UserID, u.Username, u.PasswordHash, u.Status, u.Email,
        u.isAdmin, b.DesignConverter, b.DesignAdmin, b.TradeMark, b.UserEffort, b.ShopEffort, b.Reports, b.ReportAdmin, b.UbertySecondDatabase
        ,b.DesignResponsible
      FROM Users u
      INNER JOIN ButtonAuth b ON u.UserID = b.UserID
      WHERE u.Username = ?
    `;
    const [rows] = await promisePool.execute(sql, [username]);

    if (rows.length === 0) {
      return res.status(400).send({ error: "Invalid username or password" });
    }

    const user = rows[0];

    if (user.Status === 0) {
      return res.status(403).send({
        error: "Your account has not been activated yet. Please contact support.",
      });
    }

    const isPasswordValid =  bcrypt.compareSync(password, user.PasswordHash);

    if (!isPasswordValid) {
      return res.status(400).send({ error: "Invalid username or password" });
    }

    res.status(200).send({
      UserID: user.UserID,
      Username: user.Username,
      Email: user.Email,
      isAdmin: user.isAdmin,
      DesignConverter: user.DesignConverter,
      DesignAdmin: user.DesignAdmin,
      TradeMark: user.TradeMark,
      UserEffort: user.UserEffort,
      ShopEffort: user.ShopEffort,
      Reports: user.Reports,
      ReportAdmin: user.ReportAdmin,
      UbertySecondDatabase: user.UbertySecondDatabase,
      DesignResponsible: user.DesignResponsible
    });
  } catch (error) {
    console.error(error);
    res.status(500).send({ error: "An error occurred while logging in" });
  }
});

router.post("/usersAuthInfos", async (req, res) => {

  const { UserID } = req.body;
  const pool = await getPoolByUserId(UserID);

  const sql = `
  select * from Users inner join ButtonAuth on Users.UserID = ButtonAuth.UserID;
`;
  const [result] = await pool.execute(sql);
  res.json(result);
});

router.post("/updateAuthType", async (req, res) => {

const { UserID, Status, authType } = req.body;
console.log('updateAuthType', UserID, Status, authType);
  try {
    let message = ""; // Kullanıcıya gönderilecek mesaj

    switch (authType) {
      case "0":
        const sql = `
          UPDATE Users
          SET Status = ?
          WHERE UserID = ?
        `;
        const [result] = await promisePool.execute(sql, [Status, UserID]);
        if (result.affectedRows > 0) {
          message = "Status successfully updated!";
        } else {
          throw new Error("Failed to update Status.");
        }
        break;
      case "1":
        const sql1 = `
          UPDATE Users
          SET isAdmin = ?
          WHERE UserID = ?
        `;
        const [result1] = await promisePool.execute(sql1, [Status, UserID]);
        if (result1.affectedRows > 0) {
          message = "isAdmin successfully updated!";
        } else {
          throw new Error("Failed to update isAdmin.");
        }
        break;
      case "2":
        const sql2 = `
          UPDATE ButtonAuth
          SET DesignConverter = ?
          WHERE UserID = ?
        `;
        const [result2] = await promisePool.execute(sql2, [Status, UserID]);
        if (result2.affectedRows > 0) {
          message = "DesignConverter successfully updated!";
        } else {
          throw new Error("Failed to update DesignConverter.");
        }
        break;
      case "3":
        const sql3 = `
          UPDATE ButtonAuth
          SET DesignAdmin = ?
          WHERE UserID = ?
        `;
        const [result3] = await promisePool.execute(sql3, [Status, UserID]);
        if (result3.affectedRows > 0) {
          message = "DesignAdmin successfully updated!";
        } else {
          throw new Error("Failed to update DesignAdmin.");
        }
        break;
      case "4":
        const sql4 = `
          UPDATE ButtonAuth
          SET TradeMark = ?
          WHERE UserID = ?
        `;
        const [result4] = await promisePool.execute(sql4, [Status, UserID]);
        if (result4.affectedRows > 0) {
          message = "TradeMark successfully updated!";
        } else {
          throw new Error("Failed to update TradeMark.");
        }
        break;
      case "5":
        const sql5 = `
          UPDATE ButtonAuth
          SET UserEffort = ?
          WHERE UserID = ?
        `;
        const [result5] = await promisePool.execute(sql5, [Status, UserID]);
        if (result5.affectedRows > 0) {
          message = "UserEffort successfully updated!";
        } else {
          throw new Error("Failed to update UserEffort.");
        }
        break;
      case "6":
        const sql6 = `
          UPDATE ButtonAuth
          SET ShopEffort = ?
          WHERE UserID = ?
        `;
        const [result6] = await promisePool.execute(sql6, [Status, UserID]);
        if (result6.affectedRows > 0) {
          message = "ShopEffort successfully updated!";
        } else {
          throw new Error("Failed to update ShopEffort.");
        }
        break;
      case "7":
        const sql7 = `
          UPDATE ButtonAuth
          SET Reports = ?
          WHERE UserID = ?
        `;
        const [result7] = await promisePool.execute(sql7, [Status, UserID]);
        if (result7.affectedRows > 0) {
          message = "Reports successfully updated!";
        } else {
          throw new Error("Failed to update Reports.");
        }
        break;
        case "8":
          const sql8 = `
            UPDATE ButtonAuth
            SET ReportAdmin = ?
            WHERE UserID = ?
          `;
          console.log('sql8', sql8, Status, UserID);
          const [result8] = await promisePool.execute(sql8, [Status, UserID]);
          if (result8.affectedRows > 0) {
            message = "Report Admin successfully updated!";
          } else {
            throw new Error("Failed to update Reports.");
          }
          break;
          case "9":
            console.log('sql9', Status, UserID);
          const sql9 = `
            UPDATE ButtonAuth
            SET UbertySecondDatabase = ?
            WHERE UserID = ?
          `;
          const [result9] = await promisePool.execute(sql9, [Status, UserID]);
          if (result9.affectedRows > 0) {
            message = "Dış Kullanıcı Yetkisi successfully updated!";
          } else {
            throw new Error("Failed to update Reports.");
          }
          break;
          case "10":
          const sql10 = `
            UPDATE ButtonAuth
            SET DesignResponsible = ?
            WHERE UserID = ?
          `;
          const [result10] = await promisePool.execute(sql10, [Status, UserID]);
          if (result10.affectedRows > 0) {
            message = "Dış Kullanıcı Yetkisi successfully updated!";
          } else {
            throw new Error("Failed to update Reports.");
          }
          break;
      default:
        return res.status(400).send({ error: "Invalid authType provided." });
    }

    // Güncelleme başarılıysa mesaj gönder
    res.status(200).send({ message });
  } catch (error) {
    // Hata durumunda mesaj gönder
    console.error(error);
    res.status(500).send({ error: error.message });
  }
});

module.exports = router;
