const express = require('express');
const fs = require('fs');
const multer = require('multer');
const mysql = require('mysql2');
const xlsx = require('xlsx');
const path = require('path');
const router = express.Router();
const app = express();
app.use(express.json());


const { promisePool } = require("./db");


const getData = () => {
  const data = fs.readFileSync(pathChange, 'utf8');
  return JSON.parse(data);
};

// JSON verilerini kaydedin
function saveData(data) {
  fs.writeFileSync(pathChange, JSON.stringify(data, null, 2), 'utf-8');
}

// GET - Veriyi getirme
router.get('/trademarks', (req, res) => {
  const data = getData();
  res.json(data.rows); // JSON'daki "rows" kısmını döndürüyoruz
});

// POST - Yeni veri ekleme
router.post('/trademarks', (req, res) => {
  const data = getData();
  const newItem = req.body;

  // Mevcut öğelerin en büyük `id` değerini buluyoruz
  const maxId = data.rows.reduce((max, item) => (item.id > max ? item.id : max), 0);
  newItem.id = maxId + 1; // En büyük `id` değerinin 1 fazlasını atıyoruz

  data.rows.push(newItem); // Yeni öğeyi `rows` dizisine ekliyoruz
  saveData(data); // JSON dosyasını kaydediyoruz

  res.status(201).json(newItem); // 201 (Created) ve yeni öğeyi döndürüyoruz
});

// DELETE - Belirli bir öğeyi silme
router.delete('/trademarks/:id', (req, res) => {
  const data = getData();
  const { id } = req.params;
  data.rows = data.rows.filter(item => item.id !== parseInt(id)); // ID'yi eşleştiriyoruz
  saveData(data); // JSON dosyasını güncelliyoruz
  res.status(204).end(); // 204 (No Content) döndürüyoruz
});

// PUT - Belirli bir öğeyi güncelleme
router.put('/trademarks/:id', (req, res) => {
  const data = getData();
  const { id } = req.params;
  const updatedItem = req.body; // Güncellenmiş öğeyi body'den alıyoruz
  const index = data.rows.findIndex(item => item.id === parseInt(id)); // ID'yi buluyoruz
  if (index !== -1) {
    data.rows[index] = updatedItem;
    saveData(data); // JSON dosyasını güncelliyoruz
    res.status(200).json(updatedItem); // 200 (OK) ve güncellenmiş öğeyi döndürüyoruz
  } else {
    res.status(404).send('Item not found'); // 404 (Not Found) hata mesajı
  }
});

 const upload = multer({ dest: 'uploads/' }); 
// let pathChange = "C:/Users/bagde/Project/leather-image-server/trademarkTableData.json";
 let pathChange = "/home/outlettee/public_html/leather-image-server/trademarkTableData.json";

// Önbellek mekanizması
let jsonDataCache = null;
let jsonRowsCache = null;

// JSON verilerini önbellekte tutan yardımcı fonksiyon
function getJsonData() {
  if (!jsonDataCache) {
    jsonDataCache = JSON.parse(fs.readFileSync(pathChange, 'utf8'));
    jsonRowsCache = jsonDataCache.rows;
  }
  return { jsonData: jsonDataCache, jsonRows: jsonRowsCache };
}

router.post('/upload-excel', upload.single('file'), async (req, res) => {
  try {
    const file = req.file;
    if (!file) {
      return res.status(400).json({ error: 'Lütfen bir Excel dosyası yükleyiniz!' });
    }

    // JSON verilerini önbellekten al
    const { jsonRows } = getJsonData();

    const wb = xlsx.readFile(file.path);
    const ws = wb.Sheets[wb.SheetNames[0]];
    const uploadedExcel = xlsx.utils.sheet_to_json(ws);

    if (!uploadedExcel || uploadedExcel.length === 0) {
      return res.status(400).json({ error: 'Boş Excel dosyası yüklendi.' });
    }

    let txtClass = req.body.txtClass;
    let classArray = txtClass.split(',').map(item => item.trim());

    const query = `SELECT wordmark, serialNo FROM wordmarksdistinct WHERE ${
      classArray.map(() => 'class LIKE ?').join(' OR ')
    }`;
    const queryValues = classArray.map(item => `%${item}%`);

    const [rows] = await promisePool.query(query, queryValues);

    const activeItems = new Map();
    for (const jsonRow of jsonRows) {
      if (jsonRow.active) {
        activeItems.set(jsonRow.Wordmark, true);
        activeItems.set(jsonRow.SerialNumber, true);
      }
    }

    const excelDataMap = new Map();
    for (const excelRow of uploadedExcel) {
      const excelValue = excelRow['TITLE'] || '';
      const excelValueTags = excelRow['TAGS'] || '';
      const preparedTags = prepareTagsForSearch(excelValueTags);
      
      excelDataMap.set(excelRow['SKU'], {
        excelRow,
        title: excelValue.toLowerCase().trim(),
        tags: preparedTags.join(' ').toLowerCase().trim()
      });
    }

    const resultMap = new Map();

    const processRows = rows.map(row => {
      const tableValue = row['wordmark'];
      const serialNumber = row['serialNo'];
      
      if (tableValue.length === 1 || activeItems.has(tableValue) || activeItems.has(serialNumber)) {
        return null;
      }

      const lowerCaseTableValue = tableValue.toLowerCase().trim();
      const pattern = new RegExp(`\\b${escapeRegex(lowerCaseTableValue)}\\b`, 'i');

      for (const [sku, { excelRow, title, tags }] of excelDataMap) {
        let matchLocation = '';
        
        if (pattern.test(title)) {
          matchLocation = 'TITLE';
        } else if (pattern.test(tags)) {
          matchLocation = 'TAGS';
        }

        if (matchLocation) {
          const entryKey = `${sku}_${tableValue}`;
          if (!resultMap.has(entryKey)) {
            resultMap.set(entryKey, {
              id: resultMap.size + 1,
              TITLE: excelRow['TITLE'],
              TAGS: excelRow['TAGS'] || '',
              SKU: sku,
              EşleşenKelime: tableValue,
              TrademarkSerialNumber: serialNumber,
              EşleşmeYeri: matchLocation
            });
          }
        }
      }
    });

    await Promise.all(processRows);

    const displayTable = Array.from(resultMap.values());

    res.status(200).json({
      message: `${displayTable.length} tane trademark ile eşleşen değer bulundu.`,
      data: displayTable,
    });
  } catch (error) {
    console.error('Hata:', error);
    res.status(500).json({ error: 'Sunucu hatası oluştu' });
  }
});

// Yardımcı fonksiyonlar aynı kalıyor
function prepareTagsForSearch(tags) {
  if (!tags) return [];
  const tagsWithSpaces = tags.replace(/_/g, ' ');
  return tagsWithSpaces.split(',').map(tag => tag.trim());
}

function escapeRegex(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}


module.exports = router;
