const express = require("express");
const fs = require("fs");
const multer = require("multer");
const mysql = require("mysql2");
const xlsx = require("xlsx");
const path = require("path");
const router = express.Router();
const app = express();
app.use(express.json());

const { promisePool } = require("./db");
const { getPoolByUserId } = require("./databaseSelector");

router.get("/GetAllEfforts", async (req, res) => {
  try {
    const [UserEfforts] = await promisePool.query(`select * from UserEfforts`);
    res.status(200).json(UserEfforts);
  } catch (error) {
    console.error("GetDailyEffort Hatası:", error);
    res
      .status(500)
      .json({ error: "Mağaza verileri alınırken bir hata oluştu." });
  }
});

router.post("/GetAllShopDatas", async (req, res) => {
  const { UserID, isAdmin } = req.body;
  const pool = await getPoolByUserId(UserID);
  try {
    if (isAdmin == 1) {
      const [ShopData] = await pool.query(`WITH RankedData AS (
    SELECT 
        sf.*,
        ROUND(ABS(sf.listingFees), 2) AS listingFeesABS,
        ROUND(ABS(sf.marketingFees), 2) AS marketingFeesABS,
        ROUND(ABS(sf.ShippingFees), 2) AS ShippingFeesABS,
        ROUND(ABS(sf.salesSummary), 2) AS salesSummaryABS,
        ROUND(ABS(sf.totalRefundsAmounts), 2) AS totoalRefundsAmountsABS,
        ROUND(SUM(ABS(etsy.PaymentFee)), 2) AS PaymentFee, 
        YEAR(sf.StartDate) AS YearNum,
        MONTH(sf.StartDate) AS MonthNum,
        WEEK(sf.StartDate, 1) AS WeekNum,
        ROW_NUMBER() OVER (
           PARTITION BY sf.SelectedShop ORDER BY sf.StartDate
        ) AS RowNum
    FROM ShopFees sf
    LEFT JOIN ShopFeesEtsyTable etsy ON sf.ID = etsy.ParentFormID
    GROUP BY 
        sf.ID, sf.SelectedShop, sf.StartDate, sf.EndDate, 
        sf.listingFees, sf.marketingFees, sf.ShippingFees
),
PreviousWeekData AS (
    SELECT 
        curr.*,
        -- Haftalık fark (AY da aynı olmalı)
        ROUND(curr.listingFeesABS - COALESCE(prev.listingFeesABS, 0), 2) AS listingFeesDiff,
        ROUND(curr.marketingFeesABS - COALESCE(prev.marketingFeesABS, 0), 2) AS marketingFeesDiff,
        ROUND(curr.ShippingFeesABS - COALESCE(prev.ShippingFeesABS, 0), 2) AS ShippingFeesDiff,
        ROUND(curr.salesSummaryABS - COALESCE(prev.salesSummaryABS, 0), 2) AS salesSummaryDiff,
        ROUND(curr.totoalRefundsAmountsABS - COALESCE(prev.totoalRefundsAmountsABS, 0), 2) AS totalRefundsAmountsDiff
    FROM RankedData curr
    LEFT JOIN RankedData prev
        ON  curr.SelectedShop = prev.SelectedShop
        AND curr.YearNum    = prev.YearNum
        AND curr.MonthNum   = prev.MonthNum   -- AY kontrolü eklendi
        AND curr.WeekNum    = prev.WeekNum + 1
)
SELECT 
    pwd.*,
    sa.UserID as 'ResponsibleID',
    sa.Username as 'Responsible'
FROM PreviousWeekData pwd
LEFT JOIN ShopsAuth sa ON pwd.SelectedShop = sa.ShopName
ORDER BY pwd.StartDate;`);
      res.status(200).json(ShopData);
    } else {
      const [ShopData] = await pool.query(
        `WITH RankedData AS (
    SELECT 
        sf.*,
        ROUND(ABS(sf.listingFees), 2) AS listingFeesABS,
        ROUND(ABS(sf.marketingFees), 2) AS marketingFeesABS,
        ROUND(ABS(sf.ShippingFees), 2) AS ShippingFeesABS,
        ROUND(ABS(sf.salesSummary), 2) AS salesSummaryABS,
        ROUND(ABS(sf.totalRefundsAmounts), 2) AS totoalRefundsAmountsABS,
        ROUND(SUM(ABS(etsy.PaymentFee)), 2) AS PaymentFee, 
        YEAR(sf.StartDate) AS YearNum,
        MONTH(sf.StartDate) AS MonthNum,
        WEEK(sf.StartDate, 1) AS WeekNum,
        ROW_NUMBER() OVER (
           PARTITION BY sf.SelectedShop ORDER BY sf.StartDate
        ) AS RowNum
    FROM ShopFees sf
    LEFT JOIN ShopFeesEtsyTable etsy ON sf.ID = etsy.ParentFormID
    GROUP BY 
        sf.ID, sf.SelectedShop, sf.StartDate, sf.EndDate, 
        sf.listingFees, sf.marketingFees, sf.ShippingFees
),
PreviousWeekData AS (
    SELECT 
        curr.*,
        -- Haftalık fark (AY da aynı olmalı)
        ROUND(curr.listingFeesABS - COALESCE(prev.listingFeesABS, 0), 2) AS listingFeesDiff,
        ROUND(curr.marketingFeesABS - COALESCE(prev.marketingFeesABS, 0), 2) AS marketingFeesDiff,
        ROUND(curr.ShippingFeesABS - COALESCE(prev.ShippingFeesABS, 0), 2) AS ShippingFeesDiff,
        ROUND(curr.salesSummaryABS - COALESCE(prev.salesSummaryABS, 0), 2) AS salesSummaryDiff,
        ROUND(curr.totoalRefundsAmountsABS - COALESCE(prev.totoalRefundsAmountsABS, 0), 2) AS totalRefundsAmountsDiff
    FROM RankedData curr
    LEFT JOIN RankedData prev
        ON  curr.SelectedShop = prev.SelectedShop
        AND curr.YearNum    = prev.YearNum
        AND curr.MonthNum   = prev.MonthNum   -- AY kontrolü eklendi
        AND curr.WeekNum    = prev.WeekNum + 1
)
SELECT 
    pwd.*,
    sa.UserID as 'ResponsibleID',
    sa.Username as 'Responsible'
FROM PreviousWeekData pwd
LEFT JOIN ShopsAuth sa ON pwd.SelectedShop = sa.ShopName
where sa.UserID in (select StaffUserID from UserAuth where CaptainUserID = ?) or sa.UserID = ?
ORDER BY pwd.StartDate;`,
        [UserID, UserID]
      );
      res.status(200).json(ShopData);
    }
  } catch (error) {
    console.error("GetDailyEffort Hatası:", error);
    res
      .status(500)
      .json({ error: "Mağaza verileri alınırken bir hata oluştu." });
  }
});

router.post("/GetUserEffortViaParamaters", async (req, res) => {
  const { UserID, isAdmin, startDate, endDate } = req.body;
  const pool = await getPoolByUserId(UserID);
  console.log(
    "GetUserEffortViaParamaters",
    UserID,
    isAdmin,
    startDate,
    endDate
  );

  if (isAdmin) {
    try {
      const [UserEfforts] = await pool.query(
        `SELECT Id, UserID, UserName, StartHour, EndHour, TimeSummary, Explanation,
                EffortDate,ShopLinks, PurchLinks, Image1, Image2, Image3, FormID, Shop, SelectedEfforts, Piace 
         FROM UserEfforts
         WHERE EffortDate BETWEEN ? AND ?;`,
        [startDate, endDate]
      );
      res.status(200).json(UserEfforts);
    } catch (error) {
      console.error("GetUserEffortViaParamaters Hatası:", error);
      res
        .status(500)
        .json({ error: "Mağaza verileri alınırken bir hata oluştu." });
    }
  } else {
    try {
      const [UserEfforts] = await pool.query(
        `SELECT * FROM UserEfforts
         WHERE (UserID IN (SELECT StaffUserID FROM UserAuth WHERE CaptainUserID = ?) OR UserID = ?)
         AND EffortDate BETWEEN ? AND ?;`,
        [UserID, UserID, startDate, endDate]
      );
      res.status(200).json(UserEfforts);
    } catch (error) {
      console.error("GetUserEffortViaParamaters Hatası:", error);
      res
        .status(500)
        .json({ error: "Mağaza verileri alınırken bir hata oluştu." });
    }
  }
});

router.post("/GetAllShopExpenses", async (req, res) => {

  const { UserID } = req.body;
  const pool = await getPoolByUserId(UserID);

  try {
    const [ShopData] = await pool.query(` select * from ShopExpenses`);
    res.status(200).json(ShopData);
  } catch (error) {
    console.error("GetDailyEffort Hatası:", error);
    res
      .status(500)
      .json({ error: "Mağaza gider verileri alınırken bir hata oluştu." });
  }
});

router.post("/GetShopFees", async (req, res) => {
   const { UserID } = req.body;
  const pool = await getPoolByUserId(UserID);
  try {
    const [shopFees] = await pool.query(`
      SELECT 
        SelectedShop,
        StartDate,
        EndDate,
        PaymentDate,
        PaymentFee  
      FROM ShopFees sf
      LEFT JOIN ShopFeesEtsyTable sft ON sf.ID = sft.ParentFormID
      WHERE PaymentFee IS NOT NULL
    `);
    res.status(200).json(shopFees);
  } catch (error) {
    console.error("GetShopFees Error:", error);
    res.status(500).json({ error: "Error fetching shop fees data." });
  }
});

module.exports = router;
