const { promisePool , ubertySecPool } = require('./db');

async function getPoolByUserId(userId) {
  const [result] = await promisePool.query(
    'SELECT UbertySecondDatabase FROM ButtonAuth WHERE UserID = ?',
    [userId]
  );

  if (!result.length) throw new Error('User not found');

  return result[0].UbertySecondDatabase === 1 ? ubertySecPool : promisePool ;
}

module.exports = { getPoolByUserId };
