/*!
 * Paper.js v0.12.18 - The Swiss Army Knife of Vector Graphics Scripting.
 * http://paperjs.org/
 *
 * Copyright (c) 2011 - 2020, Jürg Lehni & Jonathan Puckey
 * http://juerglehni.com/ & https://puckey.studio/
 *
 * Distributed under the MIT license. See LICENSE file for details.
 *
 * All rights reserved.
 *
 * Date: Wed Jul 17 14:57:24 2024 +0200
 *
 ***
 *
 * Straps.js - Class inheritance library with support for bean-style accessors
 *
 * Copyright (c) 2006 - 2020 Jürg Lehni
 * http://juerglehni.com/
 *
 * Distributed under the MIT license.
 *
 ***
 *
 * Acorn.js
 * https://marijnhaverbeke.nl/acorn/
 *
 * Acorn is a tiny, fast JavaScript parser written in JavaScript,
 * created by Marijn Haverbeke and released under an MIT license.
 *
 */
var paper=function(u,j){var T=(u=u||require("./node/self.js")).window,_=u.document,D=new function(){function n(t,e,n){var i;return t&&((i=d(t,"length"))&&"number"==typeof i.value?s:function(t,e){for(var n in this)this.hasOwnProperty(n)&&t.call(e,this[n],n,this)}).call(t,e,n=n||t),n}var r=/^(statics|enumerable|beans|preserve)$/,t=[],i=t.slice,a=Object.create,d=Object.getOwnPropertyDescriptor,_=Object.defineProperty,s=t.forEach||function(t,e){for(var n=0,i=this.length;n<i;n++)t.call(e,this[n],n,this)},o=Object.assign||function(t){for(var e=1,n=arguments.length;e<n;e++){var i,r=arguments[e];for(i in r)r.hasOwnProperty(i)&&(t[i]=r[i])}return t};function h(a,o,h,u,l){var c={};function t(t,e){var n,i="function"==typeof(e="string"==typeof(e=e||(e=d(o,t))&&(e.get?e:e.value))&&"#"===e[0]?a[e.substring(1)]||e:e),r=e,s=l||i&&!e.base?e&&e.get?t in a:a[t]:null;l&&s||(i&&s&&(e.base=s),i&&!1!==u&&(n=t.match(/^([gs]et|is)(([A-Z])(.*))$/))&&(c[n[3].toLowerCase()+n[4]]=n[2]),r&&!i&&r.get&&"function"==typeof r.get&&f.isPlainObject(r)||(r={value:r,writable:!0}),(d(a,t)||{configurable:!0}).configurable&&(r.configurable=!0,r.enumerable=null!=h?h:!n),_(a,t,r))}if(o){for(var e in o)o.hasOwnProperty(e)&&!r.test(e)&&t(e);for(var e in c){var n=c[e],i=a["set"+n],n=a["get"+n]||i&&a["is"+n];!n||!0!==u&&0!==n.length||t(e,{get:n,set:i})}}return a}function f(){for(var t=0,e=arguments.length;t<e;t++){var n=arguments[t];n&&o(this,n)}return this}return h(f,{inject:function(t){var e,n,i;t&&(e=!0===t.statics?t:t.statics,n=t.beans,i=t.preserve,e!==t&&h(this.prototype,t,t.enumerable,n,i),h(this,e,null,n,i));for(var r=1,s=arguments.length;r<s;r++)this.inject(arguments[r]);return this},extend:function(){for(var t,e,n,i=this,r=0,s=arguments.length;r<s&&(!t||!e);r++)n=arguments[r],t=t||n.initialize,e=e||n.prototype;return e=(t=t||function(){i.apply(this,arguments)}).prototype=e||a(this.prototype),_(e,"constructor",{value:t,writable:!0,configurable:!0}),h(t,this),arguments.length&&this.inject.apply(t,arguments),t.base=i,t}}).inject({enumerable:!1,initialize:f,set:f,inject:function(){for(var t=0,e=arguments.length;t<e;t++){var n=arguments[t];n&&h(this,n,n.enumerable,n.beans,n.preserve)}return this},extend:function(){var t=a(this);return t.inject.apply(t,arguments)},each:function(t,e){return n(this,t,e)},clone:function(){return new this.constructor(this)},statics:{set:o,each:n,create:a,define:_,describe:d,clone:function(t){return o(new t.constructor,t)},isPlainObject:function(t){t=null!=t&&t.constructor;return t&&(t===Object||t===f||"Object"===t.name)},pick:function(t,e){return t!==j?t:e},slice:function(t,e,n){return i.call(t,e,n)}}})};"undefined"!=typeof module&&(module.exports=D),D.inject({enumerable:!1,toString:function(){return null!=this._id?(this._class||"Object")+(this._name?" '"+this._name+"'":" @"+this._id):"{ "+D.each(this,function(t,e){/^_/.test(e)||this.push(e+": "+("number"==(e=typeof t)?x.instance.number(t):"string"==e?"'"+t+"'":t))},[]).join(", ")+" }"},getClassName:function(){return this._class||""},importJSON:function(t){return D.importJSON(t,this)},exportJSON:function(t){return D.exportJSON(this,t)},toJSON:function(){return D.serialize(this)},set:function(t,e){return t&&D.filter(this,t,e,this._prioritize),this}},{beans:!1,statics:{exports:{},extend:function t(){var e=t.base.apply(this,arguments),n=e.prototype._class;return n&&!D.exports[n]&&(D.exports[n]=e),e},equals:function(t,e){if(t===e)return!0;if(t&&t.equals)return t.equals(e);if(e&&e.equals)return e.equals(t);if(t&&e&&"object"==typeof t&&"object"==typeof e){if(Array.isArray(t)&&Array.isArray(e)){if((n=t.length)!==e.length)return!1;for(;n--;)if(!D.equals(t[n],e[n]))return!1}else{var n,i=Object.keys(t);if((n=i.length)!==Object.keys(e).length)return!1;for(;n--;){var r=i[n];if(!e.hasOwnProperty(r)||!D.equals(t[r],e[r]))return!1}}return!0}return!1},read:function(t,e,n,i){if(this===D){var r=this.peek(t,e);return t.__index++,r}var s=this.prototype,a=s._readIndex,o=e||a&&t.__index||0,r=t.length,e=t[o];return i=i||r-o,e instanceof this||n&&n.readNull&&null==e&&i<=1?(a&&(t.__index=o+1),e&&n&&n.clone?e.clone():e):(e=D.create(s),a&&(e.__read=!0),e=e.initialize.apply(e,0<o||o+i<r?D.slice(t,o,o+i):t)||e,a&&(t.__index=o+e.__read,(o=e.__filtered)&&(t.__filtered=o,e.__filtered=j),e.__read=j),e)},peek:function(t,e){return t[t.__index=e||t.__index||0]},remain:function(t){return t.length-(t.__index||0)},readList:function(t,e,n,i){for(var r,s=[],e=e||0,a=i?e+i:t.length,o=e;o<a;o++)s.push(Array.isArray(r=t[o])?this.read(r,0,n):this.read(t,o,n,1));return s},readNamed:function(t,e,n,i,r){var s,a,o=this.getNamed(t,e),h=o!==j;return h&&((a=t.__filtered)||(s=this.getSource(t),(a=t.__filtered=D.create(s)).__unfiltered=s),a[e]=j),this.read(h?[o]:t,n,i,r)},readSupported:function(n,i){var t=this.getSource(n),r=this,s=!1;return t&&Object.keys(t).forEach(function(t){var e;t in i&&((e=r.readNamed(n,t))!==j&&(i[t]=e),s=!0)}),s},getSource:function(t){var e,n=t.__source;return n===j&&(e=1===t.length&&t[0],n=t.__source=e&&D.isPlainObject(e)?e:null),n},getNamed:function(t,e){var n=this.getSource(t);if(n)return e?n[e]:t.__filtered||n},hasNamed:function(t,e){return!!this.getNamed(t,e)},filter:function(n,i,r,t){var s;function e(t){var e;r&&t in r||s&&t in s||(e=i[t])!==j&&(n[t]=e)}if(t){for(var a,o={},h=0,u=t.length;h<u;h++)(a=t[h])in i&&(e(a),o[a]=!0);s=o}return Object.keys(i.__unfiltered||i).forEach(e),n},isPlainValue:function(t,e){return D.isPlainObject(t)||Array.isArray(t)||e&&"string"==typeof t},serialize:function(t,e,n,i){e=e||{};var r=!i;if(r&&(e.formatter=new x(e.precision),i={length:0,definitions:{},references:{},add:function(t,e){var n="#"+t._id,i=this.references[n];return i||(this.length++,e=e.call(t),(t=t._class)&&e[0]!==t&&e.unshift(t),this.definitions[n]=e,i=this.references[n]=[n]),i}}),t&&t._serialize){var s=t._serialize(e,i),a=t._class;!a||t._compactSerialize||!r&&n||s[0]===a||s.unshift(a)}else if(Array.isArray(t)){s=[];for(var o=0,h=t.length;o<h;o++)s[o]=D.serialize(t[o],e,n,i)}else if(D.isPlainObject(t)){s={};for(var u=Object.keys(t),o=0,h=u.length;o<h;o++){var l=u[o];s[l]=D.serialize(t[l],e,n,i)}}else s="number"==typeof t?e.formatter.number(t,e.precision):t;return r&&0<i.length?[["dictionary",i.definitions],s]:s},deserialize:function(t,e,n,i,r){var s=t,a=!n,o=a&&t&&t.length&&"dictionary"===t[0][0];if(n=n||{},Array.isArray(t)){var h=t[0],u="dictionary"===h;if(1==t.length&&/^#/.test(h))return n.dictionary[h];s=[];for(var l,c=(h=D.exports[h])?1:0,d=t.length;c<d;c++)s.push(D.deserialize(t[c],e,n,u,o));h&&(l=s,s=e?e(h,l,a||r):new h(l))}else if(D.isPlainObject(t))for(var _ in s={},i&&(n.dictionary=s),t)s[_]=D.deserialize(t[_],e,n);return o?s[1]:s},exportJSON:function(t,e){t=D.serialize(t,e);return e&&0==e.asString?t:JSON.stringify(t)},importJSON:function(t,s){return D.deserialize("string"==typeof t?JSON.parse(t):t,function(t,e,n){var i=n&&s&&s.constructor===t,r=i?s:D.create(t.prototype);return!(1===e.length&&r instanceof V)||!i&&r instanceof a||(n=e[0],D.isPlainObject(n)&&(n.insert=!1,i&&(e=e.concat([V.INSERT])))),(i?r.set:t).apply(r,e),i&&(s=null),r})},push:function(t,e){var n=e.length;if(n<4096)t.push.apply(t,e);else{var i=t.length;t.length+=n;for(var r=0;r<n;r++)t[i+r]=e[r]}return t},splice:function(t,e,n,i){var r=e&&e.length,s=n===j;(n=s?t.length:n)>t.length&&(n=t.length);for(var a=0;a<r;a++)e[a]._index=n+a;if(s)return D.push(t,e),[];i=[n,i];e&&D.push(i,e);for(var o=t.splice.apply(t,i),a=0,h=o.length;a<h;a++)o[a]._index=j;for(a=n+r,h=t.length;a<h;a++)t[a]._index=a;return o},capitalize:function(t){return t.replace(/\b[a-z]/g,function(t){return t.toUpperCase()})},camelize:function(t){return t.replace(/-(.)/g,function(t,e){return e.toUpperCase()})},hyphenate:function(t){return t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}}});var t={on:function(t,e){var n,i;return"string"!=typeof t?D.each(t,function(t,e){this.on(e,t)},this):(n=(i=this._eventTypes)&&i[t],-1===(i=(i=this._callbacks=this._callbacks||{})[t]=i[t]||[]).indexOf(e)&&(i.push(e),n&&n.install&&1===i.length&&n.install.call(this,t))),this},off:function(t,e){if("string"==typeof t){var n,i=this._eventTypes,r=i&&i[t],i=this._callbacks&&this._callbacks[t];return i&&(!e||-1!==(n=i.indexOf(e))&&1===i.length?(r&&r.uninstall&&r.uninstall.call(this,t),delete this._callbacks[t]):-1!==n&&i.splice(n,1)),this}D.each(t,function(t,e){this.off(e,t)},this)},once:function(e,n){return this.on(e,function t(){n.apply(this,arguments),this.off(e,t)})},emit:function(t,e){if(!(r=this._callbacks&&this._callbacks[t]))return!1;var n=D.slice(arguments,1),i=e&&e.target&&!e.currentTarget,r=r.slice();i&&(e.currentTarget=this);for(var s=0,a=r.length;s<a;s++)if(0==r[s].apply(this,n)){e&&e.stop&&e.stop();break}return i&&delete e.currentTarget,!0},responds:function(t){return!(!this._callbacks||!this._callbacks[t])},attach:"#on",detach:"#off",fire:"#emit",_installEvents:function(t){var e,n=this._eventTypes,i=this._callbacks,r=t?"install":"uninstall";if(n)for(var s in i)0<i[s].length&&((e=(e=n[s])&&e[r])&&e.call(this,s))},statics:{inject:function t(s){var a,e=s._events;return e&&(a={},D.each(e,function(t,e){var n="string"==typeof t,i=n?t:e,e=D.capitalize(i),r=i.substring(2).toLowerCase();a[r]=n?{}:t,i="_"+i,s["get"+e]=function(){return this[i]},s["set"+e]=function(t){var e=this[i];e&&this.off(r,e),t&&this.on(r,t),this[i]=t}}),s._eventTypes=a),t.base.apply(this,arguments)}}},l=D.extend({_class:"PaperScope",initialize:function t(){(Bt=this).settings=new D({applyMatrix:!0,insertItems:!0,handleSize:4,hitTolerance:0}),this.project=null,this.projects=[],this.tools=[],this._id=t._id++,t._scopes[this._id]=this;var e,n,s,i=t.prototype;this.support||(n=ht.getContext(1,1)||{},i.support={nativeDash:"setLineDash"in n||"mozDash"in n,nativeBlendModes:ut.nativeModes},ht.release(n)),this.agent||(e=u.navigator.userAgent.toLowerCase(),n=(/(darwin|win|mac|linux|freebsd|sunos)/.exec(e)||[])[0],s=i.agent=i.browser={platform:n="darwin"===n?"mac":n},n&&(s[n]=!0),e.replace(/(opera|chrome|safari|webkit|firefox|msie|trident|atom|node|jsdom)\/?\s*([.\d]+)(?:.*version\/([.\d]+))?(?:.*rv\:v?([.\d]+))?/g,function(t,e,n,i,r){s.chrome||(n="opera"===e?i:/^(node|trident)$/.test(e)?r:n,s.version=n,s.versionNumber=parseFloat(n),s.name=e={trident:"msie",jsdom:"node"}[e]||e,s[e]=!0)}),s.chrome&&delete s.webkit,s.atom&&delete s.chrome)},version:"0.12.18",getView:function(){var t=this.project;return t&&t._view},getPaper:function(){return this},execute:function(t,e){},install:function(e){var t,n=this;for(t in D.each(["project","view","tool"],function(t){D.define(e,t,{configurable:!0,get:function(){return n[t]}})}),this)!/^_/.test(t)&&this[t]&&(e[t]=this[t])},setup:function(t){return(Bt=this).project=new i(t),this},createCanvas:function(t,e){return ht.getCanvas(t,e)},activate:function(){Bt=this},clear:function(){for(var t=this.projects,e=this.tools,n=t.length-1;0<=n;n--)t[n].remove();for(n=e.length-1;0<=n;n--)e[n].remove()},remove:function(){this.clear(),delete l._scopes[this._id]},statics:new function(){function t(n){return n+="Attribute",function(t,e){return t[n](e)||t[n]("data-paper-"+e)}}return{_scopes:{},_id:0,get:function(t){return this._scopes[t]||null},getAttribute:t("get"),hasAttribute:t("has")}}}),e=D.extend(t,{initialize:function(t){this._scope=Bt,this._index=this._scope[this._list].push(this)-1,!t&&this._scope[this._reference]||this.activate()},activate:function(){if(!this._scope)return!1;var t=this._scope[this._reference];return t&&t!==this&&t.emit("deactivate"),(this._scope[this._reference]=this).emit("activate",t),!0},isActive:function(){return this._scope[this._reference]===this},remove:function(){return null!=this._index&&(D.splice(this._scope[this._list],null,this._index,1),this._scope[this._reference]==this&&(this._scope[this._reference]=null),!(this._scope=null))},getView:function(){return this._scope.getView()}}),R={findItemBoundsCollisions:function(t,e,n){function i(t){for(var e=new Array(t.length),n=0;n<t.length;n++){var i=t[n].getBounds();e[n]=[i.left,i.top,i.right,i.bottom]}return e}var r=i(t),e=e&&e!==t?i(e):r;return this.findBoundsCollisions(r,e,n||0)},findCurveBoundsCollisions:function(t,e,n,i){function r(t){for(var e=Math.min,n=Math.max,i=new Array(t.length),r=0;r<t.length;r++){var s=t[r];i[r]=[e(s[0],s[2],s[4],s[6]),e(s[1],s[3],s[5],s[7]),n(s[0],s[2],s[4],s[6]),n(s[1],s[3],s[5],s[7])]}return i}var s=r(t),e=e&&e!==t?r(e):s;if(i){for(var a=this.findBoundsCollisions(s,e,n||0,!1,!0),o=this.findBoundsCollisions(s,e,n||0,!0,!0),h=[],u=0,l=a.length;u<l;u++)h[u]={hor:a[u],ver:o[u]};return h}return this.findBoundsCollisions(s,e,n||0)},findBoundsCollisions:function(t,e,n,i,r){var s=!e||t===e,a=s?t:t.concat(e),o=t.length,h=a.length;function u(t,e,n){for(var i=0,r=t.length;i<r;){var s=r+i>>>1;a[t[s]][e]<n?i=1+s:r=s}return i-1}for(var l=i?1:0,c=2+l,d=i?0:1,_=2+d,f=new Array(h),g=0;g<h;g++)f[g]=g;f.sort(function(t,e){return a[t][l]-a[e][l]});for(var v=[],p=new Array(o),g=0;g<h;g++){var m=f[g],y=a[m],w=s?m:m-o,x=m<o,b=s||!x,S=x?[]:null;if(v.length){var C=u(v,c,y[l]-n)+1;if(v.splice(0,C),s&&r)for(var S=S.concat(v),P=0;P<v.length;P++)p[T=v[P]].push(w);else for(var I=y[_],M=y[d],P=0;P<v.length;P++){var T=v[P],O=a[T],z=T<o,k=s||o<=T;(r||(x&&k||b&&z)&&I>=O[d]-n&&M<=O[_]+n)&&(x&&k&&S.push(s?T:T-o),b&&z&&p[T].push(w))}}x&&(t===e&&S.push(m),p[m]=S),v.length?(y=u(v,c,y[c]),v.splice(y+1,0,m)):v.push(m)}for(g=0;g<p.length;g++){var A=p[g];A&&A.sort(function(t,e){return t-e})}return p}},x=D.extend({initialize:function(t){this.precision=D.pick(t,5),this.multiplier=Math.pow(10,this.precision)},number:function(t){return this.precision<16?Math.round(t*this.multiplier)/this.multiplier:t},pair:function(t,e,n){return this.number(t)+(n||",")+this.number(e)},point:function(t,e){return this.number(t.x)+(e||",")+this.number(t.y)},size:function(t,e){return this.number(t.width)+(e||",")+this.number(t.height)},rectangle:function(t,e){return this.point(t,e)+(e||",")+this.size(t,e)}});x.instance=new x;var q=new function(){var d=[[.5773502691896257],[0,.7745966692414834],[.33998104358485626,.8611363115940526],[0,.5384693101056831,.906179845938664],[.2386191860831969,.6612093864662645,.932469514203152],[0,.4058451513773972,.7415311855993945,.9491079123427585],[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499]],_=[[1],[.8888888888888888,.5555555555555556],[.6521451548625461,.34785484513745385],[.5688888888888889,.47862867049936647,.23692688505618908],[.46791393457269104,.3607615730481386,.17132449237917036],[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096]],m=Math.abs,y=Math.sqrt,w=Math.pow,e=Math.log2||function(t){return Math.log(t)*Math.LOG2E},x=1e-12,b=112e-18;function S(t,e,n){return t<e?e:n<t?n:t}function f(t,e,n){function i(t){var e=134217729*t,e=t-e+e;return[e,t-e]}var r,s,a=e*e-t*n,o=e*e+t*n;return 3*m(a)<o&&(r=i(t),s=i(e),o=i(n),a=(e=e*e)-(n=t*n)+(s[0]*s[0]-e+2*s[0]*s[1]+s[1]*s[1]-(r[0]*o[0]-n+r[0]*o[1]+r[1]*o[0]+r[1]*o[1]))),a}function C(){var t=Math.max.apply(Math,arguments);return t&&(t<1e-8||1e8<t)?w(2,-Math.round(e(t))):0}return{EPSILON:x,MACHINE_EPSILON:b,CURVETIME_EPSILON:1e-8,GEOMETRIC_EPSILON:1e-7,TRIGONOMETRIC_EPSILON:1e-8,ANGULAR_EPSILON:1e-5,KAPPA:4*(y(2)-1)/3,isZero:function(t){return-x<=t&&t<=x},isMachineZero:function(t){return-b<=t&&t<=b},clamp:S,integrate:function(t,e,n,i){for(var r=d[i-2],s=_[i-2],a=.5*(n-e),o=a+e,h=0,u=i+1>>1,l=1&i?s[h++]*t(o):0;h<u;){var c=a*r[h];l+=s[h++]*(t(o+c)+t(o-c))}return a*l},findRoot:function(t,e,n,i,r,s,a){for(var o=0;o<s;o++){var h=t(n),u=h/e(n),l=n-u;if(m(u)<a){n=l;break}n=0<h?(r=n,l<=i?.5*(i+r):l):(i=n,r<=l?.5*(i+r):l)}return S(n,i,r)},solveQuadratic:function(t,e,n,i,r,s){var a,o=1/0;if(m(t)<x){if(m(e)<x)return m(n)<x?-1:0;a=-n/e}else{var h,u=f(t,e*=-.5,n);u&&m(u)<b&&((h=C(m(t),m(e),m(n)))&&(u=f(t*=h,e*=h,n*=h))),-b<=u&&(l=u<0?0:y(u),o=0===(c=e+(e<0?-l:l))?-(a=n/t):(a=c/t,n/c))}var l=0,t=null==r,n=r-x,c=s+x;return isFinite(a)&&(t||n<a&&a<c)&&(i[l++]=t?a:S(a,r,s)),o!==a&&isFinite(o)&&(t||n<o&&o<c)&&(i[l++]=t?o:S(o,r,s)),l},solveCubic:function(e,n,i,r,t,s,a){var o,h,u,l,c,d=C(m(e),m(n),m(i),m(r));function _(t){t=e*(o=t);l=(t+(h=t+n))*o+(u=h*o+i),c=u*o+r}if(d&&(e*=d,n*=d,i*=d,r*=d),m(e)<x)e=n,h=i,u=r,o=1/0;else if(m(r)<x)h=n,u=i,o=0;else{_(-n/e/3);var f=c/e,g=w(m(f),1/3),v=f<0?-1:1,f=-l/e,f=0<f?1.324717957244746*Math.max(g,y(f)):g,p=o-v*f;if(p!==o){for(;_(p),p=0===l?o:o-c/l/(1+b),v*o<v*p;);m(e)*o*o>m(r/o)&&(h=((u=-r/o)-i)/o)}}g=q.solveQuadratic(e,h,u,t,s,a),f=null==s;return isFinite(o)&&(0===g||0<g&&o!==t[0]&&o!==t[1])&&(f||s-x<o&&o<a+x)&&(t[g++]=f?o:S(o,s,a)),g}}},o={_id:1,_pools:{},get:function(t){if(t){var e=this._pools[t];return(e=e||(this._pools[t]={_id:1}))._id++}return this._id++}},L=D.extend({_class:"Point",_readIndex:!0,initialize:function(t,e){var n,i=typeof t,r=this.__read,s=0;return"number"==i?(this._set(t,(n="number"==typeof e)?e:t),r&&(s=n?2:1)):"undefined"==i||null===t?(this._set(0,0),r&&(s=null===t?1:0)):(t="string"==i?t.split(/[\s,]+/)||[]:t,s=1,Array.isArray(t)?this._set(+t[0],+(1<t.length?t[1]:t[0])):"x"in t?this._set(t.x||0,t.y||0):"width"in t?this._set(t.width||0,t.height||0):"angle"in t?(this._set(t.length||0,0),this.setAngle(t.angle||0)):(this._set(0,0),s=0)),r&&(this.__read=s),this},set:"#initialize",_set:function(t,e){return this.x=t,this.y=e,this},equals:function(t){return this===t||t&&(this.x===t.x&&this.y===t.y||Array.isArray(t)&&this.x===t[0]&&this.y===t[1])||!1},clone:function(){return new L(this.x,this.y)},toString:function(){var t=x.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+" }"},_serialize:function(t){t=t.formatter;return[t.number(this.x),t.number(this.y)]},getLength:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},setLength:function(t){var e;this.isZero()?(e=this._angle||0,this._set(Math.cos(e)*t,Math.sin(e)*t)):(t=t/this.getLength(),q.isZero(t)&&this.getAngle(),this._set(this.x*t,this.y*t))},getAngle:function(){return 180*this.getAngleInRadians.apply(this,arguments)/Math.PI},setAngle:function(t){this.setAngleInRadians.call(this,t*Math.PI/180)},getAngleInDegrees:"#getAngle",setAngleInDegrees:"#setAngle",getAngleInRadians:function(){if(arguments.length){var t=L.read(arguments),e=this.getLength()*t.getLength();if(q.isZero(e))return NaN;e=this.dot(t)/e;return Math.acos(e<-1?-1:1<e?1:e)}return this.isZero()?this._angle||0:this._angle=Math.atan2(this.y,this.x)},setAngleInRadians:function(t){var e;this._angle=t,this.isZero()||(e=this.getLength(),this._set(Math.cos(t)*e,Math.sin(t)*e))},getQuadrant:function(){return 0<=this.x?0<=this.y?1:4:0<=this.y?2:3}},{beans:!1,getDirectedAngle:function(){var t=L.read(arguments);return 180*Math.atan2(this.cross(t),this.dot(t))/Math.PI},getDistance:function(){var t=arguments,e=L.read(t),n=e.x-this.x,e=e.y-this.y,e=n*n+e*e;return D.read(t)?e:Math.sqrt(e)},normalize:function(t){t===j&&(t=1);var e=this.getLength(),t=0!==e?t/e:0,e=new L(this.x*t,this.y*t);return 0<=t&&(e._angle=this._angle),e},rotate:function(t,e){if(0===t)return this.clone();t=t*Math.PI/180;var n=e?this.subtract(e):this,i=Math.sin(t),t=Math.cos(t),n=new L(n.x*t-n.y*i,n.x*i+n.y*t);return e?n.add(e):n},transform:function(t){return t?t._transformPoint(this):this},add:function(){var t=L.read(arguments);return new L(this.x+t.x,this.y+t.y)},subtract:function(){var t=L.read(arguments);return new L(this.x-t.x,this.y-t.y)},multiply:function(){var t=L.read(arguments);return new L(this.x*t.x,this.y*t.y)},divide:function(){var t=L.read(arguments);return new L(this.x/t.x,this.y/t.y)},modulo:function(){var t=L.read(arguments);return new L(this.x%t.x,this.y%t.y)},negate:function(){return new L(-this.x,-this.y)},isInside:function(){return b.read(arguments).contains(this)},isClose:function(){var t=arguments,e=L.read(t),t=D.read(t);return this.getDistance(e)<=t},isCollinear:function(){var t=L.read(arguments);return L.isCollinear(this.x,this.y,t.x,t.y)},isColinear:"#isCollinear",isOrthogonal:function(){var t=L.read(arguments);return L.isOrthogonal(this.x,this.y,t.x,t.y)},isZero:function(){var t=q.isZero;return t(this.x)&&t(this.y)},isNaN:function(){return isNaN(this.x)||isNaN(this.y)},isInQuadrant:function(t){return 0<=this.x*(1<t&&t<4?-1:1)&&0<=this.y*(2<t?-1:1)},dot:function(){var t=L.read(arguments);return this.x*t.x+this.y*t.y},cross:function(){var t=L.read(arguments);return this.x*t.y-this.y*t.x},project:function(){var t=L.read(arguments),e=t.isZero()?0:this.dot(t)/t.dot(t);return new L(t.x*e,t.y*e)},statics:{min:function(){var t=arguments,e=L.read(t),t=L.read(t);return new L(Math.min(e.x,t.x),Math.min(e.y,t.y))},max:function(){var t=arguments,e=L.read(t),t=L.read(t);return new L(Math.max(e.x,t.x),Math.max(e.y,t.y))},random:function(){return new L(Math.random(),Math.random())},isCollinear:function(t,e,n,i){return Math.abs(t*i-e*n)<=1e-8*Math.sqrt((t*t+e*e)*(n*n+i*i))},isOrthogonal:function(t,e,n,i){return Math.abs(t*n+e*i)<=1e-8*Math.sqrt((t*t+e*e)*(n*n+i*i))}}},D.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new L(e(this.x),e(this.y))}},{})),c=L.extend({initialize:function(t,e,n,i){this._x=t,this._y=e,this._owner=n,this._setter=i},_set:function(t,e,n){return this._x=t,this._y=e,n||this._owner[this._setter](this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner[this._setter](this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner[this._setter](this)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner._changeSelection(this._getSelection(),t)},_getSelection:function(){return"setPosition"===this._setter?4:0}}),k=D.extend({_class:"Size",_readIndex:!0,initialize:function(t,e){var n,i=typeof t,r=this.__read,s=0;return"number"==i?(this._set(t,(n="number"==typeof e)?e:t),r&&(s=n?2:1)):"undefined"==i||null===t?(this._set(0,0),r&&(s=null===t?1:0)):(t="string"==i?t.split(/[\s,]+/)||[]:t,s=1,Array.isArray(t)?this._set(+t[0],+(1<t.length?t[1]:t[0])):"width"in t?this._set(t.width||0,t.height||0):"x"in t?this._set(t.x||0,t.y||0):(this._set(0,0),s=0)),r&&(this.__read=s),this},set:"#initialize",_set:function(t,e){return this.width=t,this.height=e,this},equals:function(t){return t===this||t&&(this.width===t.width&&this.height===t.height||Array.isArray(t)&&this.width===t[0]&&this.height===t[1])||!1},clone:function(){return new k(this.width,this.height)},toString:function(){var t=x.instance;return"{ width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){t=t.formatter;return[t.number(this.width),t.number(this.height)]},add:function(){var t=k.read(arguments);return new k(this.width+t.width,this.height+t.height)},subtract:function(){var t=k.read(arguments);return new k(this.width-t.width,this.height-t.height)},multiply:function(){var t=k.read(arguments);return new k(this.width*t.width,this.height*t.height)},divide:function(){var t=k.read(arguments);return new k(this.width/t.width,this.height/t.height)},modulo:function(){var t=k.read(arguments);return new k(this.width%t.width,this.height%t.height)},negate:function(){return new k(-this.width,-this.height)},isZero:function(){var t=q.isZero;return t(this.width)&&t(this.height)},isNaN:function(){return isNaN(this.width)||isNaN(this.height)},statics:{min:function(t,e){return new k(Math.min(t.width,e.width),Math.min(t.height,e.height))},max:function(t,e){return new k(Math.max(t.width,e.width),Math.max(t.height,e.height))},random:function(){return new k(Math.random(),Math.random())}}},D.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new k(e(this.width),e(this.height))}},{})),n=k.extend({initialize:function(t,e,n,i){this._width=t,this._height=e,this._owner=n,this._setter=i},_set:function(t,e,n){return this._width=t,this._height=e,n||this._owner[this._setter](this),this},getWidth:function(){return this._width},setWidth:function(t){this._width=t,this._owner[this._setter](this)},getHeight:function(){return this._height},setHeight:function(t){this._height=t,this._owner[this._setter](this)}}),b=D.extend({_class:"Rectangle",_readIndex:!0,beans:!0,initialize:function(t,e,n,i){var r,s,a,o,h,u,l=arguments,c=typeof t;"number"==c?(this._set(t,e,n,i),r=4):"undefined"==c||null===t?(this._set(0,0,0,0),r=null===t?1:0):1===l.length&&(Array.isArray(t)?(this._set.apply(this,t),r=1):t.x!==j||t.width!==j?(this._set(t.x||0,t.y||0,t.width||0,t.height||0),r=1):t.from===j&&t.to===j&&(this._set(0,0,0,0),D.readSupported(l,this)&&(r=1))),r===j&&(a=L.readNamed(l,"from"),s=D.peek(l),c=a.x,a=a.y,s&&s.x!==j||D.hasNamed(l,"to")?(o=(u=L.readNamed(l,"to")).x-c,h=u.y-a,o<0&&(c=u.x,o=-o),h<0&&(a=u.y,h=-h)):(o=(u=k.read(l)).width,h=u.height),this._set(c,a,o,h),r=l.__index);l=l.__filtered;return l&&(this.__filtered=l),this.__read&&(this.__read=r),this},set:"#initialize",_set:function(t,e,n,i){return this.x=t,this.y=e,this.width=n,this.height=i,this},clone:function(){return new b(this.x,this.y,this.width,this.height)},equals:function(t){var e=D.isPlainValue(t)?b.read(arguments):t;return e===this||e&&this.x===e.x&&this.y===e.y&&this.width===e.width&&this.height===e.height||!1},toString:function(){var t=x.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+", width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){t=t.formatter;return[t.number(this.x),t.number(this.y),t.number(this.width),t.number(this.height)]},getPoint:function(t){return new(t?L:c)(this.x,this.y,this,"setPoint")},setPoint:function(){var t=L.read(arguments);this.x=t.x,this.y=t.y},getSize:function(t){return new(t?k:n)(this.width,this.height,this,"setSize")},_fw:1,_fh:1,setSize:function(){var t=k.read(arguments),e=this._sx,n=this._sy,i=t.width,t=t.height;e&&(this.x+=(this.width-i)*e),n&&(this.y+=(this.height-t)*n),this.width=i,this.height=t,this._fw=this._fh=1},getLeft:function(){return this.x},setLeft:function(t){var e;this._fw||(e=t-this.x,this.width-=.5===this._sx?2*e:e),this.x=t,this._sx=this._fw=0},getTop:function(){return this.y},setTop:function(t){var e;this._fh||(e=t-this.y,this.height-=.5===this._sy?2*e:e),this.y=t,this._sy=this._fh=0},getRight:function(){return this.x+this.width},setRight:function(t){var e;this._fw||(e=t-this.x,this.width=.5===this._sx?2*e:e),this.x=t-this.width,this._sx=1,this._fw=0},getBottom:function(){return this.y+this.height},setBottom:function(t){var e;this._fh||(e=t-this.y,this.height=.5===this._sy?2*e:e),this.y=t-this.height,this._sy=1,this._fh=0},getCenterX:function(){return this.x+this.width/2},setCenterX:function(t){this._fw||.5===this._sx?this.x=t-this.width/2:(this._sx&&(this.x+=2*(t-this.x)*this._sx),this.width=2*(t-this.x)),this._sx=.5,this._fw=0},getCenterY:function(){return this.y+this.height/2},setCenterY:function(t){this._fh||.5===this._sy?this.y=t-this.height/2:(this._sy&&(this.y+=2*(t-this.y)*this._sy),this.height=2*(t-this.y)),this._sy=.5,this._fh=0},getCenter:function(t){return new(t?L:c)(this.getCenterX(),this.getCenterY(),this,"setCenter")},setCenter:function(){var t=L.read(arguments);return this.setCenterX(t.x),this.setCenterY(t.y),this},getArea:function(){return this.width*this.height},isEmpty:function(){return 0===this.width||0===this.height},contains:function(t){return t&&t.width!==j||4===(Array.isArray(t)?t:arguments).length?this._containsRectangle(b.read(arguments)):this._containsPoint(L.read(arguments))},_containsPoint:function(t){var e=t.x,t=t.y;return e>=this.x&&t>=this.y&&e<=this.x+this.width&&t<=this.y+this.height},_containsRectangle:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e+t.width<=this.x+this.width&&n+t.height<=this.y+this.height},intersects:function(){var t=b.read(arguments),e=D.read(arguments)||0;return t.x+t.width>this.x-e&&t.y+t.height>this.y-e&&t.x<this.x+this.width+e&&t.y<this.y+this.height+e},intersect:function(){var t=b.read(arguments),e=Math.max(this.x,t.x),n=Math.max(this.y,t.y),i=Math.min(this.x+this.width,t.x+t.width),t=Math.min(this.y+this.height,t.y+t.height);return new b(e,n,i-e,t-n)},unite:function(){var t=b.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x+t.width),t=Math.max(this.y+this.height,t.y+t.height);return new b(e,n,i-e,t-n)},include:function(){var t=L.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x),t=Math.max(this.y+this.height,t.y);return new b(e,n,i-e,t-n)},expand:function(){var t=k.read(arguments),e=t.width,t=t.height;return new b(this.x-e/2,this.y-t/2,this.width+e,this.height+t)},scale:function(t,e){return this.expand(this.width*t-this.width,this.height*(e===j?t:e)-this.height)}},D.each([["Top","Left"],["Top","Right"],["Bottom","Left"],["Bottom","Right"],["Left","Center"],["Top","Center"],["Right","Center"],["Bottom","Center"]],function(t,e){var n=t.join(""),i=/^[RL]/.test(n);4<=e&&(t[1]+=i?"Y":"X");var e=t[i?0:1],i=t[i?1:0],r="get"+e,s="get"+i,a="set"+e,o="set"+i,h="set"+n;this["get"+n]=function(t){return new(t?L:c)(this[r](),this[s](),this,h)},this[h]=function(){var t=L.read(arguments);this[a](t.x),this[o](t.y)}},{beans:!0})),r=b.extend({initialize:function(t,e,n,i,r,s){this._set(t,e,n,i,!0),this._owner=r,this._setter=s},_set:function(t,e,n,i,r){return this._x=t,this._y=e,this._width=n,this._height=i,r||this._owner[this._setter](this),this}},new function(){var n=b.prototype;return D.each(["x","y","width","height"],function(t){var e=D.capitalize(t),n="_"+t;this["get"+e]=function(){return this[n]},this["set"+e]=function(t){this[n]=t,this._dontNotify||this._owner[this._setter](this)}},D.each(["Point","Size","Center","Left","Top","Right","Bottom","CenterX","CenterY","TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],function(t){var e="set"+t;this[e]=function(){this._dontNotify=!0,n[e].apply(this,arguments),this._dontNotify=!1,this._owner[this._setter](this)}},{isSelected:function(){return!!(2&this._owner._selection)},setSelected:function(t){var e=this._owner;e._changeSelection&&e._changeSelection(2,t)}}))}),A=D.extend({_class:"Matrix",initialize:function t(e,n){var i=arguments,r=i.length,s=!0;if(6<=r?this._set.apply(this,i):1===r||2===r?e instanceof t?this._set(e._a,e._b,e._c,e._d,e._tx,e._ty,n):Array.isArray(e)?this._set.apply(this,n?e.concat([n]):e):s=!1:r?s=!1:this.reset(),!s)throw new Error("Unsupported matrix parameters");return this},set:"#initialize",_set:function(t,e,n,i,r,s,a){return this._a=t,this._b=e,this._c=n,this._d=i,this._tx=r,this._ty=s,a||this._changed(),this},_serialize:function(t,e){return D.serialize(this.getValues(),t,!0,e)},_changed:function(){var t=this._owner;t&&(t._applyMatrix?t.transform(null,!0):t._changed(25))},clone:function(){return new A(this._a,this._b,this._c,this._d,this._tx,this._ty)},equals:function(t){return t===this||t&&this._a===t._a&&this._b===t._b&&this._c===t._c&&this._d===t._d&&this._tx===t._tx&&this._ty===t._ty},toString:function(){var t=x.instance;return"[["+[t.number(this._a),t.number(this._c),t.number(this._tx)].join(", ")+"], ["+[t.number(this._b),t.number(this._d),t.number(this._ty)].join(", ")+"]]"},reset:function(t){return this._a=this._d=1,this._b=this._c=this._tx=this._ty=0,t||this._changed(),this},apply:function(t,e){var n=this._owner;return!!n&&(n.transform(null,D.pick(t,!0),e),this.isIdentity())},translate:function(){var t=L.read(arguments),e=t.x,t=t.y;return this._tx+=e*this._a+t*this._c,this._ty+=e*this._b+t*this._d,this._changed(),this},scale:function(){var t=arguments,e=L.read(t),t=L.read(t,0,{readNull:!0});return t&&this.translate(t),this._a*=e.x,this._b*=e.x,this._c*=e.y,this._d*=e.y,t&&this.translate(t.negate()),this._changed(),this},rotate:function(t){t*=Math.PI/180;var e=L.read(arguments,1),n=e.x,i=e.y,r=Math.cos(t),s=Math.sin(t),a=n-n*r+i*s,o=i-n*s-i*r,h=this._a,e=this._b,n=this._c,i=this._d;return this._a=r*h+s*n,this._b=r*e+s*i,this._c=-s*h+r*n,this._d=-s*e+r*i,this._tx+=a*h+o*n,this._ty+=a*e+o*i,this._changed(),this},shear:function(){var t=arguments,e=L.read(t),n=L.read(t,0,{readNull:!0});n&&this.translate(n);var i=this._a,t=this._b;return this._a+=e.y*this._c,this._b+=e.y*this._d,this._c+=e.x*i,this._d+=e.x*t,n&&this.translate(n.negate()),this._changed(),this},skew:function(){var t=arguments,e=L.read(t),n=L.read(t,0,{readNull:!0}),t=Math.PI/180,t=new L(Math.tan(e.x*t),Math.tan(e.y*t));return this.shear(t,n)},append:function(t,e){var n,i,r,s,a,o,h,u,l;return t&&(n=this._a,i=this._b,r=this._c,s=this._d,a=t._a,o=t._c,h=t._b,u=t._d,l=t._tx,t=t._ty,this._a=a*n+h*r,this._c=o*n+u*r,this._b=a*i+h*s,this._d=o*i+u*s,this._tx+=l*n+t*r,this._ty+=l*i+t*s,e||this._changed()),this},prepend:function(t,e){var n,i,r,s,a,o,h,u,l,c,d;return t&&(n=this._a,i=this._b,r=this._c,s=this._d,a=this._tx,o=this._ty,h=t._a,u=t._c,l=t._b,c=t._d,d=t._tx,t=t._ty,this._a=h*n+u*i,this._c=h*r+u*s,this._b=l*n+c*i,this._d=l*r+c*s,this._tx=h*a+u*o+d,this._ty=l*a+c*o+t,e||this._changed()),this},appended:function(t){return this.clone().append(t)},prepended:function(t){return this.clone().prepend(t)},invert:function(){var t=this._a,e=this._b,n=this._c,i=this._d,r=this._tx,s=this._ty,a=t*i-e*n,o=null;return a&&!isNaN(a)&&isFinite(r)&&isFinite(s)&&(this._a=i/a,this._b=-e/a,this._c=-n/a,this._d=t/a,this._tx=(n*s-i*r)/a,this._ty=(e*r-t*s)/a,o=this),o},inverted:function(){return this.clone().invert()},concatenate:"#append",preConcatenate:"#prepend",chain:"#appended",_shiftless:function(){return new A(this._a,this._b,this._c,this._d,0,0)},_orNullIfIdentity:function(){return this.isIdentity()?null:this},isIdentity:function(){return 1===this._a&&0===this._b&&0===this._c&&1===this._d&&0===this._tx&&0===this._ty},isInvertible:function(){var t=this._a*this._d-this._c*this._b;return t&&!isNaN(t)&&isFinite(this._tx)&&isFinite(this._ty)},isSingular:function(){return!this.isInvertible()},transform:function(t,e,n){return arguments.length<3?this._transformPoint(L.read(arguments)):this._transformCoordinates(t,e,n)},_transformPoint:function(t,e,n){var i=t.x,t=t.y;return(e=e||new L)._set(i*this._a+t*this._c+this._tx,i*this._b+t*this._d+this._ty,n)},_transformCoordinates:function(t,e,n){for(var i=0,r=2*n;i<r;i+=2){var s=t[i],a=t[i+1];e[i]=s*this._a+a*this._c+this._tx,e[i+1]=s*this._b+a*this._d+this._ty}return e},_transformCorners:function(t){var e=t.x,n=t.y,i=e+t.width,t=n+t.height,t=[e,n,i,n,i,t,e,t];return this._transformCoordinates(t,t,4)},_transformBounds:function(t,e,n){for(var i=this._transformCorners(t),r=i.slice(0,2),s=r.slice(),a=2;a<8;a++){var o=i[a],h=1&a;o<r[h]?r[h]=o:o>s[h]&&(s[h]=o)}return(e=e||new b)._set(r[0],r[1],s[0]-r[0],s[1]-r[1],n)},inverseTransform:function(){return this._inverseTransform(L.read(arguments))},_inverseTransform:function(t,e,n){var i=this._a,r=this._b,s=this._c,a=this._d,o=this._tx,h=this._ty,u=i*a-r*s,l=null;return u&&!isNaN(u)&&isFinite(o)&&isFinite(h)&&(h=t.x-this._tx,t=t.y-this._ty,l=(e=e||new L)._set((h*a-t*s)/u,(t*i-h*r)/u,n)),l},decompose:function(){var t,e,n,i,r=this._a,s=this._b,a=this._c,o=this._d,h=r*o-s*a,u=Math.sqrt,l=Math.atan2,c=180/Math.PI;return i=0!==r||0!==s?(t=u(r*r+s*s),e=Math.acos(r/t)*(0<s?1:-1),n=[t,h/t],[l(r*a+s*o,t*t),0]):0!==a||0!==o?(i=u(a*a+o*o),e=Math.asin(a/i)*(0<o?1:-1),n=[h/i,i],[0,l(r*a+s*o,i*i)]):n=[e=0,0],{translation:this.getTranslation(),rotation:e*c,scaling:new L(n),skewing:new L(i[0]*c,i[1]*c)}},getValues:function(){return[this._a,this._b,this._c,this._d,this._tx,this._ty]},getTranslation:function(){return new L(this._tx,this._ty)},getScaling:function(){return this.decompose().scaling},getRotation:function(){return this.decompose().rotation},applyToContext:function(t){this.isIdentity()||t.transform(this._a,this._b,this._c,this._d,this._tx,this._ty)}},D.each(["a","b","c","d","tx","ty"],function(t){var e=D.capitalize(t),n="_"+t;this["get"+e]=function(){return this[n]},this["set"+e]=function(t){this[n]=t,this._changed()}},{})),N=D.extend({_class:"Line",initialize:function(t,e,n,i,r){(4<=arguments.length?(this._px=t,this._py=e,this._vx=n,this._vy=i,r):(this._px=t.x,this._py=t.y,this._vx=e.x,this._vy=e.y,n))||(this._vx-=this._px,this._vy-=this._py)},getPoint:function(){return new L(this._px,this._py)},getVector:function(){return new L(this._vx,this._vy)},getLength:function(){return this.getVector().getLength()},intersect:function(t,e){return N.intersect(this._px,this._py,this._vx,this._vy,t._px,t._py,t._vx,t._vy,!0,e)},getSide:function(t,e){return N.getSide(this._px,this._py,this._vx,this._vy,t.x,t.y,!0,e)},getDistance:function(t){return Math.abs(this.getSignedDistance(t))},getSignedDistance:function(t){return N.getSignedDistance(this._px,this._py,this._vx,this._vy,t.x,t.y,!0)},isCollinear:function(t){return L.isCollinear(this._vx,this._vy,t._vx,t._vy)},isOrthogonal:function(t){return L.isOrthogonal(this._vx,this._vy,t._vx,t._vy)},statics:{intersect:function(t,e,n,i,r,s,a,o,h,u){h||(n-=t,i-=e,a-=r,o-=s);h=n*o-i*a;if(!q.isMachineZero(h)){r=t-r,s=e-s,o=(a*s-o*r)/h,h=(n*s-i*r)/h;if(u||-1e-12<o&&o<1+1e-12&&-1e-12<h&&h<1+1e-12)return new L(t+(o=!u?o<=0?0:1<=o?1:o:o)*n,e+o*i)}},getSide:function(t,e,n,i,r,s,a,o){a||(n-=t,i-=e);t=r-t,e=t*i-(s-e)*n;return(e=!o&&q.isMachineZero(e)&&0<=(e=(t*n+t*n)/(n*n+i*i))&&e<=1?0:e)<0?-1:0<e?1:0},getSignedDistance:function(t,e,n,i,r,s,a){return a||(n-=t,i-=e),0===n?0<i?r-t:t-r:0===i?n<0?s-e:e-s:((r-t)*i-(s-e)*n)/(n<i?i*Math.sqrt(1+n*n/(i*i)):n*Math.sqrt(1+i*i/(n*n)))},getDistance:function(t,e,n,i,r,s,a){return Math.abs(N.getSignedDistance(t,e,n,i,r,s,a))}}}),i=e.extend({_class:"Project",_list:"projects",_reference:"project",_compactSerialize:!0,initialize:function(t){e.call(this,!0),this._children=[],this._namedChildren={},this._activeLayer=null,this._currentStyle=new M(null,null,this),this._view=Y.create(this,t||ht.getCanvas(1,1)),this._selectionItems={},this._selectionCount=0,this._updateVersion=0},_serialize:function(t,e){return D.serialize(this._children,t,!0,e)},_changed:function(t,e){1&t&&((r=this._view)&&(r._needsUpdate=!0,!r._requested&&r._autoUpdate&&r.requestUpdate()));var n,i,r,s=this._changes;s&&e&&((r=(n=this._changesById)[i=e._id])?r.flags|=t:s.push(n[i]={item:e,flags:t}))},clear:function(){for(var t=this._children,e=t.length-1;0<=e;e--)t[e].remove()},isEmpty:function(){return!this._children.length},remove:function t(){return!!t.base.call(this)&&(this._view&&this._view.remove(),!0)},getView:function(){return this._view},getCurrentStyle:function(){return this._currentStyle},setCurrentStyle:function(t){this._currentStyle.set(t)},getIndex:function(){return this._index},getOptions:function(){return this._scope.settings},getLayers:function(){return this._children},getActiveLayer:function(){return this._activeLayer||new a({project:this,insert:!0})},getSymbolDefinitions:function(){var n=[],i={};return this.getItems({class:s,match:function(t){var e=t._definition,t=e._id;return i[t]||(i[t]=!0,n.push(e)),!1}}),n},getSymbols:"getSymbolDefinitions",getSelectedItems:function(){var t,e=this._selectionItems,n=[];for(t in e){var i=e[t],r=i._selection;1&r&&i.isInserted()?n.push(i):r||this._updateSelection(i)}return n},_updateSelection:function(t){var e=t._id,n=this._selectionItems;t._selection?n[e]!==t&&(this._selectionCount++,n[e]=t):n[e]===t&&(this._selectionCount--,delete n[e])},selectAll:function(){for(var t=this._children,e=0,n=t.length;e<n;e++)t[e].setFullySelected(!0)},deselectAll:function(){var t,e=this._selectionItems;for(t in e)e[t].setFullySelected(!1)},addLayer:function(t){return this.insertLayer(j,t)},insertLayer:function(t,e){return e instanceof a?(e._remove(!1,!0),D.splice(this._children,[e],t,0),e._setProject(this,!0),(t=e._name)&&e.setName(t),this._changes&&e._changed(5),this._activeLayer||(this._activeLayer=e)):e=null,e},_insertItem:function(t,e,n){return e=this.insertLayer(t,e)||(this._activeLayer||this._insertItem(j,new a(V.NO_INSERT),!0)).insertChild(t,e),n&&e.activate&&e.activate(),e},getItems:function(t){return V._getItems(this,t)},getItem:function(t){return V._getItems(this,t,null,null,!0)[0]||null},importJSON:function(t){this.activate();var e=this._activeLayer;return D.importJSON(t,e&&e.isEmpty()&&e)},removeOn:function(t){var e=this._removeSets;if(e){"mouseup"===t&&(e.mousedrag=null);var n=e[t];if(n){for(var i in n){var r,s=n[i];for(r in e){var a=e[r];a&&a!=n&&delete a[s._id]}s.remove()}e[t]=null}}},draw:function(t,e,n){this._updateVersion++,t.save(),e.applyToContext(t);for(var i=this._children,r=new D({offset:new L(0,0),pixelRatio:n,viewMatrix:e.isIdentity()?null:e,matrices:[new A],updateMatrix:!0}),s=0,a=i.length;s<a;s++)i[s].draw(t,r);if(t.restore(),0<this._selectionCount){t.save(),t.strokeWidth=1;var o,h=this._selectionItems,u=this._scope.settings.handleSize,l=this._updateVersion;for(o in h)h[o]._drawSelection(t,e,u,h,l);t.restore()}}}),V=D.extend(t,{statics:{extend:function t(e){return e._serializeFields&&(e._serializeFields=D.set({},this.prototype._serializeFields,e._serializeFields)),t.base.apply(this,arguments)},INSERT:{insert:!0},NO_INSERT:{insert:!1}},_class:"Item",_name:null,_applyMatrix:!0,_canApplyMatrix:!0,_canScaleStroke:!1,_pivot:null,_visible:!0,_blendMode:"normal",_opacity:1,_locked:!1,_guide:!1,_clipMask:!1,_selection:0,_selectBounds:!0,_selectChildren:!1,_serializeFields:{name:null,applyMatrix:null,matrix:new A,pivot:null,visible:!0,blendMode:"normal",opacity:1,locked:!1,guide:!1,clipMask:!1,selected:!1,data:{}},_prioritize:["applyMatrix"]},new function(){var t=["onMouseDown","onMouseUp","onMouseDrag","onClick","onDoubleClick","onMouseMove","onMouseEnter","onMouseLeave"];return D.each(t,function(t){this._events[t]={install:function(t){this.getView()._countItemEvent(t,1)},uninstall:function(t){this.getView()._countItemEvent(t,-1)}}},{_events:{onFrame:{install:function(){this.getView()._animateItem(this,!0)},uninstall:function(){this.getView()._animateItem(this,!1)}},onLoad:{},onError:{}},statics:{_itemHandlers:t}})},{initialize:function(){},_initialize:function(t,e){var n=t&&D.isPlainObject(t),i=n&&!0===t.internal,r=this._matrix=new A,s=n&&t.project||Bt.project,a=Bt.settings;return this._id=i?null:o.get(),this._parent=this._index=null,this._applyMatrix=this._canApplyMatrix&&a.applyMatrix,e&&r.translate(e),(r._owner=this)._style=new M(s._currentStyle,this,s),i||n&&0==t.insert||!a.insertItems&&(!n||1!=t.insert)?this._setProject(s):(n&&t.parent||s)._insertItem(j,this,!0),n&&t!==V.NO_INSERT&&t!==V.INSERT&&this.set(t,{internal:!0,insert:!0,project:!0,parent:!0}),n},_serialize:function(i,r){var s={},a=this;function t(t){for(var e in t){var n=a[e];D.equals(n,"leading"===e?1.2*t.fontSize:t[e])||(s[e]=D.serialize(n,i,"data"!==e,r))}}return t(this._serializeFields),this instanceof g||t(this._style._defaults),[this._class,s]},_changed:function(t){var e=this._symbol,n=this._parent||e,i=this._project;8&t&&(this._bounds=this._position=this._decomposed=j),16&t&&(this._globalMatrix=j),n&&72&t&&V._clearBoundsCache(n),2&t&&V._clearBoundsCache(this),i&&i._changed(t,this),e&&e._changed(t)},getId:function(){return this._id},getName:function(){return this._name},setName:function(t){if(this._name&&this._removeNamed(),t===+t+"")throw new Error("Names consisting only of numbers are not supported.");var e,n=this._getOwner();t&&n&&(e=n._children,((n=n._namedChildren)[t]=n[t]||[]).push(this),t in e||(e[t]=this)),this._name=t||j,this._changed(256)},getStyle:function(){return this._style},setStyle:function(t){this.getStyle().set(t)}},D.each(["locked","visible","blendMode","opacity","guide"],function(e){var t=D.capitalize(e),n="_"+e,i={locked:256,visible:265};this["get"+t]=function(){return this[n]},this["set"+t]=function(t){t!=this[n]&&(this[n]=t,this._changed(i[e]||257))}},{}),{beans:!0,getSelection:function(){return this._selection},setSelection:function(t){t!==this._selection&&(this._selection=t,(t=this._project)&&(t._updateSelection(this),this._changed(257)))},_changeSelection:function(t,e){var n=this._selection;this.setSelection(e?n|t:n&~t)},isSelected:function(){if(this._selectChildren)for(var t=this._children,e=0,n=t.length;e<n;e++)if(t[e].isSelected())return!0;return!!(1&this._selection)},setSelected:function(t){if(this._selectChildren)for(var e=this._children,n=0,i=e.length;n<i;n++)e[n].setSelected(t);this._changeSelection(1,t)},isFullySelected:function(){var t=this._children,e=!!(1&this._selection);if(t&&e){for(var n=0,i=t.length;n<i;n++)if(!t[n].isFullySelected())return!1;return!0}return e},setFullySelected:function(t){var e=this._children;if(e)for(var n=0,i=e.length;n<i;n++)e[n].setFullySelected(t);this._changeSelection(1,t)},isClipMask:function(){return this._clipMask},setClipMask:function(t){this._clipMask!=(t=!!t)&&((this._clipMask=t)&&(this.setFillColor(null),this.setStrokeColor(null)),this._changed(257),this._parent&&this._parent._changed(2048))},getData:function(){return this._data||(this._data={}),this._data},setData:function(t){this._data=t},getPosition:function(t){var e=t?L:c,t=this._position||(this._position=this._getPositionFromBounds());return new e(t.x,t.y,this,"setPosition")},setPosition:function(){this.translate(L.read(arguments).subtract(this.getPosition(!0)))},_getPositionFromBounds:function(t){return this._pivot?this._matrix._transformPoint(this._pivot):(t||this.getBounds()).getCenter(!0)},getPivot:function(){var t=this._pivot;return t?new c(t.x,t.y,this,"setPivot"):null},setPivot:function(){this._pivot=L.read(arguments,0,{clone:!0,readNull:!0}),this._position=j}},D.each({getStrokeBounds:{stroke:!0},getHandleBounds:{handle:!0},getInternalBounds:{internal:!0}},function(e,t){this[t]=function(t){return this.getBounds(t,e)}},{beans:!0,getBounds:function(t,e){var n=e||t instanceof A,i=D.set({},n?e:t,this._boundsOptions);i.stroke&&!this.getStrokeScaling()||(i.cacheItem=this);i=this._getCachedBounds(n&&t,i).rect;return arguments.length?i:new r(i.x,i.y,i.width,i.height,this,"setBounds")},setBounds:function(){var t=b.read(arguments),e=this.getBounds(),n=this._matrix,i=new A,r=t.getCenter();i.translate(r),t.width==e.width&&t.height==e.height||(n.isInvertible()||(n.set(n._backup||(new A).translate(n.getTranslation())),e=this.getBounds()),i.scale(0!==e.width?t.width/e.width:0,0!==e.height?t.height/e.height:0)),r=e.getCenter(),i.translate(-r.x,-r.y),this.transform(i)},_getBounds:function(t,e){var n=this._children;return n&&n.length?(V._updateBoundsCache(this,e.cacheItem),V._getBounds(n,t,e)):new b},_getBoundsCacheKey:function(t,e){return[t.stroke?1:0,t.handle?1:0,e?1:0].join("")},_getCachedBounds:function(t,e,n){t=t&&t._orNullIfIdentity();var i=e.internal&&!n,r=e.cacheItem,s=i?null:this._matrix._orNullIfIdentity(),a=r&&(!t||t.equals(s))&&this._getBoundsCacheKey(e,i),n=this._bounds;if(V._updateBoundsCache(this._parent||this._symbol,r),a&&n&&a in n)return{rect:(o=n[a]).rect.clone(),nonscaling:o.nonscaling};var o,t=this._getBounds(t||s,e),s=t.rect||t,e=this._style,e=t.nonscaling||e.hasStroke()&&!e.getStrokeScaling();return a&&(n||(this._bounds=n={}),o=n[a]={rect:s.clone(),nonscaling:e,internal:i}),{rect:s,nonscaling:e}},_getStrokeMatrix:function(t,e){e=this.getStrokeScaling()?null:e&&e.internal?this:this._parent||this._symbol&&this._symbol._item,t=e?e.getViewMatrix().invert():t;return t&&t._shiftless()},statics:{_updateBoundsCache:function(t,e){var n;t&&e&&(n=e._id,(t=t._boundsCache=t._boundsCache||{ids:{},list:[]}).ids[n]||(t.list.push(e),t.ids[n]=e))},_clearBoundsCache:function(t){var e=t._boundsCache;if(e){t._bounds=t._position=t._boundsCache=j;for(var n=0,i=e.list,r=i.length;n<r;n++){var s=i[n];s!==t&&(s._bounds=s._position=j,s._boundsCache&&V._clearBoundsCache(s))}}},_getBounds:function(t,e,n){var i=u=1/0,r=l=-u,s=!1;n=n||{};for(var a=0,o=t.length;a<o;a++){var h,u,l,c=t[a];c._visible&&!c.isEmpty(!0)&&(c=(h=c._getCachedBounds(e&&e.appended(c._matrix),n,!0)).rect,u=Math.min(c.x,u),i=Math.min(c.y,i),l=Math.max(c.x+c.width,l),r=Math.max(c.y+c.height,r),h.nonscaling&&(s=!0))}return{rect:isFinite(u)?new b(u,i,l-u,r-i):new b,nonscaling:s}}}}),{beans:!0,_decompose:function(){return this._applyMatrix?null:this._decomposed||(this._decomposed=this._matrix.decompose())},getRotation:function(){var t=this._decompose();return t?t.rotation:0},setRotation:function(t){var e,n=this.getRotation();null!=n&&null!=t&&(e=this._decomposed,this.rotate(t-n),e&&(e.rotation=t,this._decomposed=e))},getScaling:function(){var t=this._decompose(),t=t&&t.scaling;return new c(t?t.x:1,t?t.y:1,this,"setScaling")},setScaling:function(){var t,e,n,i,r=this.getScaling(),s=L.read(arguments,0,{clone:!0,readNull:!0});r&&s&&!r.equals(s)&&(t=this.getRotation(),e=this._decomposed,n=new A,(i=q.isZero)(r.x)||i(r.y)?(n.translate(e.translation),t&&n.rotate(t),n.scale(s.x,s.y),this._matrix.set(n)):(i=this.getPosition(!0),n.translate(i),t&&n.rotate(t),n.scale(s.x/r.x,s.y/r.y),t&&n.rotate(-t),n.translate(i.negate()),this.transform(n)),e&&(e.scaling=s,this._decomposed=e))},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.set.apply(t,arguments)},getGlobalMatrix:function(t){if(i=this._globalMatrix)for(var e=this._parent,n=[];e;){if(!e._globalMatrix){for(var i=null,r=0,s=n.length;r<s;r++)n[r]._globalMatrix=null;break}n.push(e),e=e._parent}return i||(i=this._globalMatrix=this._matrix.clone(),(e=this._parent)&&i.prepend(e.getGlobalMatrix(!0))),t?i:i.clone()},getViewMatrix:function(){return this.getGlobalMatrix().prepend(this.getView()._matrix)},getApplyMatrix:function(){return this._applyMatrix},setApplyMatrix:function(t){(this._applyMatrix=this._canApplyMatrix&&!!t)&&this.transform(null,!0)},getTransformContent:"#getApplyMatrix",setTransformContent:"#setApplyMatrix"},{getProject:function(){return this._project},_setProject:function(t,e){if(this._project!==t){this._project&&this._installEvents(!1),this._project=t;for(var n=this._children,i=0,r=n&&n.length;i<r;i++)n[i]._setProject(t);e=!0}e&&this._installEvents(!0)},getView:function(){return this._project._view},_installEvents:function t(e){t.base.call(this,e);for(var n=this._children,i=0,r=n&&n.length;i<r;i++)n[i]._installEvents(e)},getLayer:function(){for(var t=this;t=t._parent;)if(t instanceof a)return t;return null},getParent:function(){return this._parent},setParent:function(t){return t.addChild(this)},_getOwner:"#getParent",getChildren:function(){return this._children},setChildren:function(t){this.removeChildren(),this.addChildren(t)},getFirstChild:function(){return this._children&&this._children[0]||null},getLastChild:function(){return this._children&&this._children[this._children.length-1]||null},getNextSibling:function(){var t=this._getOwner();return t&&t._children[this._index+1]||null},getPreviousSibling:function(){var t=this._getOwner();return t&&t._children[this._index-1]||null},getIndex:function(){return this._index},setIndex:function(t){var e=this._parent,n=e&&e._children;n&&e.insertChildren(t in n?t:j,[this])},equals:function(t){return t===this||t&&this._class===t._class&&this._style.equals(t._style)&&this._matrix.equals(t._matrix)&&this._locked===t._locked&&this._visible===t._visible&&this._blendMode===t._blendMode&&this._opacity===t._opacity&&this._clipMask===t._clipMask&&this._guide===t._guide&&this._equals(t)||!1},_equals:function(t){return D.equals(this._children,t._children)},clone:function(t){var e=new this.constructor(V.NO_INSERT),n=this._children,i=D.pick(t?t.insert:j,t===j||!0===t),t=D.pick(t?t.deep:j,!0);n&&e.copyAttributes(this),n&&!t||e.copyContent(this),n||e.copyAttributes(this),i&&e.insertAbove(this);var r=this._name,i=this._parent;if(r&&i){for(var n=i._children,s=r,a=1;n[r];)r=s+" "+a++;r!==s&&e.setName(r)}return e},copyContent:function(t){for(var e=t._children,n=0,i=e&&e.length;n<i;n++)this.addChild(e[n].clone(!1),!0)},copyAttributes:function(t,e){this.setStyle(t._style);for(var n=["_locked","_visible","_blendMode","_opacity","_clipMask","_guide"],i=0,r=n.length;i<r;i++){var s=n[i];t.hasOwnProperty(s)&&(this[s]=t[s])}e||this._matrix.set(t._matrix,!0),this.setApplyMatrix(t._applyMatrix),this.setPivot(t._pivot),this.setSelection(t._selection);var a=t._data,e=t._name;this._data=a?D.clone(a):null,e&&this.setName(e)},rasterize:function(t,e){var n;D.isPlainObject(t)?(a=t.resolution,n=t.insert,i=t.raster):(a=t,n=e);var i=i||new d(V.NO_INSERT),r=this.getStrokeBounds(),s=(a||this.getView().getResolution())/72,t=r.getTopLeft().floor(),e=r.getBottomRight().ceil(),a=new k(e.subtract(t)),r=a.multiply(s);return i.setSize(r,!0),r.isZero()||(e=i.getContext(!0),r=(new A).scale(s).translate(t.negate()),e.save(),r.applyToContext(e),this.draw(e,new D({matrices:[r]})),e.restore()),i._matrix.set((new A).translate(t.add(a.divide(2))).scale(1/s)),n!==j&&!n||i.insertAbove(this),i},contains:function(){var t=this._matrix;return t.isInvertible()&&!!this._contains(t._inverseTransform(L.read(arguments)))},_contains:function(t){var e=this._children;if(e){for(var n=e.length-1;0<=n;n--)if(e[n].contains(t))return!0;return!1}return t.isInside(this.getInternalBounds())},isInside:function(){return b.read(arguments).contains(this.getBounds())},_asPathItem:function(){return new W.Rectangle({rectangle:this.getInternalBounds(),matrix:this._matrix,insert:!1})},intersects:function(t,e){return t instanceof V&&0<this._asPathItem().getIntersections(t._asPathItem(),null,e,!0).length}},new function(){function t(){var t=arguments;return this._hitTest(L.read(t),O.getOptions(t))}function e(){var t=arguments,e=L.read(t),n=O.getOptions(t),t=[];return this._hitTest(e,new D({all:t},n)),t}function n(t,e,n,i){var r=this._children;if(r)for(var s=r.length-1;0<=s;s--){var a=r[s],a=a!==i&&a._hitTest(t,e,n);if(a&&!e.all)return a}return null}return i.inject({hitTest:t,hitTestAll:e,_hitTest:n}),{hitTest:t,hitTestAll:e,_hitTestChildren:n}},{_hitTest:function(i,e,t){if(this._locked||!this._visible||this._guide&&!e.guides||this.isEmpty())return null;var n=this._matrix,r=t?t.appended(n):this.getGlobalMatrix().prepend(this.getView()._matrix),s=Math.max(e.tolerance,1e-12),a=e._tolerancePadding=new k(W._getStrokePadding(s,n._shiftless().invert()));if(!(i=n._inverseTransform(i))||!this._children&&!this.getBounds({internal:!0,stroke:!0,handle:!0}).expand(a.multiply(2))._containsPoint(i))return null;var o,h,u=!(e.guides&&!this._guide||e.selected&&!this.isSelected()||e.type&&e.type!==D.hyphenate(this._class)||e.class&&!(this instanceof e.class)),l=e.match,c=this;function d(t){return(t=t&&l&&!l(t)?null:t)&&e.all&&e.all.push(t),t}function _(t,e){var n=e?o["get"+e]():c.getPosition();if(i.subtract(n).divide(a).length<=1)return new O(t,c,{name:e?D.hyphenate(e):t,point:n})}var f=e.position,t=e.center,s=e.bounds;if(u&&this._parent&&(f||t||s)){if((t||s)&&(o=this.getInternalBounds()),!(h=f&&_("position")||t&&_("center","Center"))&&s)for(var g=["TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],v=0;v<8&&!h;v++)h=_("bounds",g[v]);h=d(h)}return(h=h||(this._hitTestChildren(i,e,r)||u&&d(this._hitTestSelf(i,e,r,this.getStrokeScaling()?null:r._shiftless().invert()))||null))&&h.point&&(h.point=n.transform(h.point)),h},_hitTestSelf:function(t,e){if(e.fill&&this.hasFill()&&this._contains(t))return new O("fill",this)},matches:function(t,e){var n=typeof t;if("object"==n){for(var i in t)if(t.hasOwnProperty(i)&&!this.matches(i,t[i]))return!1;return!0}if("function"==n)return t(this);if("match"===t)return e(this);n=/^(empty|editable)$/.test(t)?this["is"+D.capitalize(t)]():"type"===t?D.hyphenate(this._class):this[t];if("class"===t){if("function"==typeof e)return this instanceof e;n=this._class}if("function"==typeof e)return!!e(n);if(e){if(e.test)return e.test(n);if(D.isPlainObject(e))return function t(e,n){for(var i in e)if(e.hasOwnProperty(i)){var r=e[i],i=n[i];if(D.isPlainObject(r)&&D.isPlainObject(i)){if(!t(r,i))return!1}else if(!D.equals(r,i))return!1}return!0}(e,n)}return D.equals(n,e)},getItems:function(t){return V._getItems(this,t,this._matrix)},getItem:function(t){return V._getItems(this,t,this._matrix,null,!0)[0]||null},statics:{_getItems:function t(e,n,i,r,s){var a,o,h;r||(o=(a="object"==typeof n&&n)&&a.overlapping,h=a&&a.inside,u=(p=o||h)&&b.read([p]),r={items:[],recursive:a&&!1!==a.recursive,inside:!!h,overlapping:!!o,rect:u,path:o&&new W.Rectangle({rectangle:u,insert:!1})},a&&(n=D.filter({},n,{recursive:!0,inside:!0,overlapping:!0})));var u,l=e._children,c=r.items;i=(u=r.rect)&&(i||new A);for(var d=0,_=l&&l.length;d<_;d++){var f=l[d],g=i&&i.appended(f._matrix),v=!0;if(u){var p=f.getBounds(g);if(!u.intersects(p))continue;u.contains(p)||r.overlapping&&(p.contains(u)||r.path.intersects(f,g))||(v=!1)}if(v&&f.matches(n)&&(c.push(f),s))break;if(!1!==r.recursive&&t(f,n,g,r,s),s&&0<c.length)break}return c}}},{importJSON:function(t){t=D.importJSON(t,this);return t!==this?this.addChild(t):t},addChild:function(t){return this.insertChild(j,t)},insertChild:function(t,e){e=e?this.insertChildren(t,[e]):null;return e&&e[0]},addChildren:function(t){return this.insertChildren(this._children.length,t)},insertChildren:function(t,e){var n=this._children;if(n&&e&&0<e.length){for(var i={},r=(e=D.slice(e)).length-1;0<=r;r--){var s=(u=e[r])&&u._id;!u||i[s]?e.splice(r,1):(u._remove(!1,!0),i[s]=!0)}D.splice(n,e,t,0);for(var a=this._project,o=a._changes,r=0,h=e.length;r<h;r++){var u,l=(u=e[r])._name;u._parent=this,u._setProject(a,!0),l&&u.setName(l),o&&u._changed(5)}this._changed(11)}else e=null;return e},_insertItem:"#insertChild",_insertAt:function(t,e){var n=t&&t._getOwner(),i=t!==this&&n?this:null;return i&&(i._remove(!1,!0),n._insertItem(t._index+e,i)),i},insertAbove:function(t){return this._insertAt(t,1)},insertBelow:function(t){return this._insertAt(t,0)},sendToBack:function(){var t=this._getOwner();return t?t._insertItem(0,this):null},bringToFront:function(){var t=this._getOwner();return t?t._insertItem(j,this):null},appendTop:"#addChild",appendBottom:function(t){return this.insertChild(0,t)},moveAbove:"#insertAbove",moveBelow:"#insertBelow",addTo:function(t){return t._insertItem(j,this)},copyTo:function(t){return this.clone(!1).addTo(t)},reduce:function(t){var e=this._children;if(e&&1===e.length){t=e[0].reduce(t);return this._parent?(t.insertAbove(this),this.remove()):t.remove(),t}return this},_removeNamed:function(){var t,e,n,i,r=this._getOwner();r&&(t=r._children,-1!==(r=(i=(e=r._namedChildren)[n=this._name])?i.indexOf(this):-1)&&(t[n]==this&&delete t[n],i.splice(r,1),i.length?t[n]=i[0]:delete e[n]))},_remove:function(t,e){var n=this._getOwner(),i=this._project,r=this._index;return this._style&&this._style._dispose(),!!n&&(this._name&&this._removeNamed(),null!=r&&(i._activeLayer===this&&(i._activeLayer=this.getNextSibling()||this.getPreviousSibling()),D.splice(n._children,null,r,1)),this._installEvents(!1),t&&i._changes&&this._changed(5),e&&n._changed(11,this),!(this._parent=null))},remove:function(){return this._remove(!0,!0)},replaceWith:function(t){t=t&&t.insertBelow(this);return t&&this.remove(),t},removeChildren:function(t,e){if(!this._children)return null;t=t||0,e=D.pick(e,this._children.length);for(var n=D.splice(this._children,null,t,e-t),i=n.length-1;0<=i;i--)n[i]._remove(!0,!1);return 0<n.length&&this._changed(11),n},clear:"#removeChildren",reverseChildren:function(){if(this._children){this._children.reverse();for(var t=0,e=this._children.length;t<e;t++)this._children[t]._index=t;this._changed(11)}},isEmpty:function(t){var e=this._children,n=e?e.length:0;if(t){for(var i=0;i<n;i++)if(!e[i].isEmpty(t))return!1;return!0}return!n},isEditable:function(){for(var t=this;t;){if(!t._visible||t._locked)return!1;t=t._parent}return!0},hasFill:function(){return this.getStyle().hasFill()},hasStroke:function(){return this.getStyle().hasStroke()},hasShadow:function(){return this.getStyle().hasShadow()},_getOrder:function(t){function e(t){for(var e=[];e.unshift(t),t=t._parent;);return e}for(var n=e(this),i=e(t),r=0,s=Math.min(n.length,i.length);r<s;r++)if(n[r]!=i[r])return n[r]._index<i[r]._index?1:-1;return 0},hasChildren:function(){return this._children&&0<this._children.length},isInserted:function(){return!!this._parent&&this._parent.isInserted()},isAbove:function(t){return-1===this._getOrder(t)},isBelow:function(t){return 1===this._getOrder(t)},isParent:function(t){return this._parent===t},isChild:function(t){return t&&t._parent===this},isDescendant:function(t){for(var e=this;e=e._parent;)if(e===t)return!0;return!1},isAncestor:function(t){return!!t&&t.isDescendant(this)},isSibling:function(t){return this._parent===t._parent},isGroupedWith:function(t){for(var e=this._parent;e;){if(e._parent&&/^(Group|Layer|CompoundPath)$/.test(e._class)&&t.isDescendant(e))return!0;e=e._parent}return!1}},D.each(["rotate","scale","shear","skew"],function(n){var i="rotate"===n;this[n]=function(){var t=arguments,e=(i?D:L).read(t),t=L.read(t,0,{readNull:!0});return this.transform((new A)[n](e,t||this.getPosition(!0)))}},{translate:function(){var t=new A;return this.transform(t.translate.apply(t,arguments))},transform:function(t,e,n){var i,r,s=this._matrix,a=t&&!t.isIdentity(),o=n&&this._canApplyMatrix||this._applyMatrix&&(a||!s.isIdentity()||e&&this._children);if(!a&&!o)return this;a&&(!t.isInvertible()&&s.isInvertible()&&(s._backup=s.getValues()),s.prepend(t,!0),i=(r=this._style).getFillColor(!0),r=r.getStrokeColor(!0),i&&i.transform(t),r&&r.transform(t)),(o=o&&this._transformContent(s,e,n))&&((e=this._pivot)&&s._transformPoint(e,e,!0),s.reset(!0),n&&this._canApplyMatrix&&(this._applyMatrix=!0));var h=this._bounds,s=this._position;(a||o)&&this._changed(25);n=a&&h&&t.decompose();if(n&&n.skewing.isZero()&&n.rotation%90==0){for(var u in h){var l=h[u];l.nonscaling?delete h[u]:!o&&l.internal||(l=l.rect,t._transformBounds(l,l))}n=(this._bounds=h)[this._getBoundsCacheKey(this._boundsOptions||{})];n&&(this._position=this._getPositionFromBounds(n.rect))}else a&&s&&this._pivot&&(this._position=t._transformPoint(s,s));return this},_transformContent:function(t,e,n){var i=this._children;if(i){for(var r=0,s=i.length;r<s;r++)i[r].transform(t,e,n);return!0}},globalToLocal:function(){return this.getGlobalMatrix(!0)._inverseTransform(L.read(arguments))},localToGlobal:function(){return this.getGlobalMatrix(!0)._transformPoint(L.read(arguments))},parentToLocal:function(){return this._matrix._inverseTransform(L.read(arguments))},localToParent:function(){return this._matrix._transformPoint(L.read(arguments))},fitBounds:function(t,e){t=b.read(arguments);var n=this.getBounds(),i=n.height/n.width,r=t.height/t.width,r=(e?r<i:i<r)?t.width/n.width:t.height/n.height,r=new b(new L,new k(n.width*r,n.height*r));r.setCenter(t.getCenter()),this.setBounds(r)}}),{_setStyles:function(t,e,n){var i,r,s=this._style,a=this._matrix;s.hasFill()&&(t.fillStyle=s.getFillColor().toCanvasStyle(t,a)),s.hasStroke()&&(t.strokeStyle=s.getStrokeColor().toCanvasStyle(t,a),t.lineWidth=s.getStrokeWidth(),i=s.getStrokeJoin(),r=s.getStrokeCap(),a=s.getMiterLimit(),i&&(t.lineJoin=i),r&&(t.lineCap=r),a&&(t.miterLimit=a),Bt.support.nativeDash&&(r=s.getDashArray(),a=s.getDashOffset(),r&&r.length&&("setLineDash"in t?(t.setLineDash(r),t.lineDashOffset=a):(t.mozDash=r,t.mozDashOffset=a)))),s.hasShadow()&&(e=e.pixelRatio||1,e=(n=n._shiftless().prepend((new A).scale(e,e))).transform(new L(s.getShadowBlur(),0)),n=n.transform(this.getShadowOffset()),t.shadowColor=s.getShadowColor().toCanvasStyle(t),t.shadowBlur=e.getLength(),t.shadowOffsetX=n.x,t.shadowOffsetY=n.y)},draw:function(t,e,n){this._updateVersion=this._project._updateVersion;if(this._visible&&0!==this._opacity){var i=e.matrices,r=e.viewMatrix,s=this._matrix,a=i[i.length-1].appended(s);if(a.isInvertible()){r=r?r.appended(a):a,i.push(a),e.updateMatrix&&(this._globalMatrix=a);var o,h,u,l=this._blendMode,c=q.clamp(this._opacity,0,1),d="normal"===l,_=ut.nativeModes[l],f=d&&1===c||e.dontStart||e.clip||(_||d&&c<1)&&this._canComposite(),a=e.pixelRatio||1;if(!f){var g=this.getStrokeBounds(r);if(!g.width||!g.height)return void i.pop();u=e.offset,h=e.offset=g.getTopLeft().floor(),o=t,t=ht.getContext(g.getSize().ceil().add(1).multiply(a)),1!==a&&t.scale(a,a)}t.save();d=n?n.appended(s):this._canScaleStroke&&!this.getStrokeScaling(!0)&&r,g=!f&&e.clipItem,n=!d||g;f?(t.globalAlpha=c,_&&(t.globalCompositeOperation=l)):n&&t.translate(-h.x,-h.y),n&&(f?s:r).applyToContext(t),g&&e.clipItem.draw(t,e.extend({clip:!0})),d&&(t.setTransform(a,0,0,a,0,0),(g=e.offset)&&t.translate(-g.x,-g.y)),this._draw(t,e,r,d),t.restore(),i.pop(),e.clip&&!e.dontFinish&&t.clip(this.getFillRule()),f||(ut.process(l,t,o,c,h.subtract(u).multiply(a)),ht.release(t),e.offset=u)}}},_isUpdated:function(t){var e=this._parent;if(e instanceof G)return e._isUpdated(t);var n=this._updateVersion===t;return!n&&e&&e._visible&&e._isUpdated(t)&&(this._updateVersion=t,n=!0),n},_drawSelection:function(t,e,n,i,r){var s=this._selection,a=1&s,o=2&s||a&&this._selectBounds,s=4&s;if(((a=!this._drawSelected?!1:a)||o||s)&&this._isUpdated(r)){var h=this.getSelectedColor(!0)||(h=this.getLayer())&&h.getSelectedColor(!0),e=e.appended(this.getGlobalMatrix(!0)),u=n/2;if(t.strokeStyle=t.fillStyle=h?h.toCanvasStyle(t):"#009dec",a&&this._drawSelected(t,e,i),s){var i=this.getPosition(!0),s=this._parent,i=s?s.localToGlobal(i):i,l=i.x,c=i.y;t.beginPath(),t.arc(l,c,u,0,2*Math.PI,!0),t.stroke();for(var d=[[0,-1],[1,0],[0,1],[-1,0]],_=u,f=n+1,g=0;g<4;g++){var v=d[g],p=v[0],v=v[1];t.moveTo(l+p*_,c+v*_),t.lineTo(l+p*f,c+v*f),t.stroke()}}if(o){var m=e._transformCorners(this.getInternalBounds());t.beginPath();for(g=0;g<8;g++)t[g?"lineTo":"moveTo"](m[g],m[++g]);t.closePath(),t.stroke();for(g=0;g<8;g++)t.fillRect(m[g]-u,m[++g]-u,n,n)}}},_canComposite:function(){return!1}},D.each(["down","drag","up","move"],function(e){this["removeOn"+D.capitalize(e)]=function(){var t={};return t[e]=!0,this.removeOn(t)}},{removeOn:function(t){for(var e in t){var n;t[e]&&(n="mouse"+e,(e=(e=this._project)._removeSets=e._removeSets||{})[n]=e[n]||{},e[n][this._id]=this)}return this}}),{tween:function(t,e,n){n||(n=e,e=t,t=null,n||(n=e,e=null));var i=n&&n.easing,r=n&&n.start,n=null!=n&&("number"==typeof n?n:n.duration),s=new at(this,t,e,n,i,r);return n&&this.on("frame",function t(e){s._handleFrame(1e3*e.time),s.running||this.off("frame",t)}),s},tweenTo:function(t,e){return this.tween(null,t,e)},tweenFrom:function(t,e){return this.tween(t,null,e)}}),g=V.extend({_class:"Group",_selectBounds:!1,_selectChildren:!0,_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||this.addChildren(Array.isArray(t)?t:arguments)},_changed:function t(e){t.base.call(this,e),2050&e&&(this._clipItem=j)},_getClipItem:function(){if((t=this._clipItem)===j){for(var t=null,e=this._children,n=0,i=e.length;n<i;n++)if(e[n]._clipMask){t=e[n];break}this._clipItem=t}return t},isClipped:function(){return!!this._getClipItem()},setClipped:function(t){var e=this.getFirstChild();e&&e.setClipMask(t)},_getBounds:function t(e,n){var i=this._getClipItem();return i?i._getCachedBounds(i._matrix.prepended(e),D.set({},n,{stroke:!1})):t.base.call(this,e,n)},_hitTestChildren:function t(e,n,i){var r=this._getClipItem();return(!r||r.contains(e))&&t.base.call(this,e,n,i,r)},_draw:function(t,e){var n=e.clip,i=!n&&this._getClipItem();e=e.extend({clipItem:i,clip:!1}),n?(t.beginPath(),e.dontStart=e.dontFinish=!0):i&&i.draw(t,e.extend({clip:!0}));for(var r=this._children,s=0,a=r.length;s<a;s++){var o=r[s];o!==i&&o.draw(t,e)}}}),a=g.extend({_class:"Layer",initialize:function(){g.apply(this,arguments)},_getOwner:function(){return this._parent||null!=this._index&&this._project},isInserted:function t(){return this._parent?t.base.call(this):null!=this._index},activate:function(){this._project._activeLayer=this},_hitTestSelf:function(){}}),f=V.extend({_class:"Shape",_applyMatrix:!1,_canApplyMatrix:!1,_canScaleStroke:!0,_serializeFields:{type:null,size:null,radius:null},initialize:function(t,e){this._initialize(t,e)},_equals:function(t){return this._type===t._type&&this._size.equals(t._size)&&D.equals(this._radius,t._radius)},copyContent:function(t){this.setType(t._type),this.setSize(t._size),this.setRadius(t._radius)},getType:function(){return this._type},setType:function(t){this._type=t},getShape:"#getType",setShape:"#setType",getSize:function(){var t=this._size;return new n(t.width,t.height,this,"setSize")},setSize:function(){var t,e,n,i=k.read(arguments);this._size?this._size.equals(i)||(t=this._type,e=i.width,n=i.height,"rectangle"===t?this._radius.set(k.min(this._radius,i.divide(2).abs())):"circle"===t?(e=n=(e+n)/2,this._radius=e/2):"ellipse"===t&&this._radius._set(e/2,n/2),this._size._set(e,n),this._changed(9)):this._size=i.clone()},getRadius:function(){var t=this._radius;return"circle"===this._type?t:new n(t.width,t.height,this,"setRadius")},setRadius:function(t){var e=this._type;if("circle"===e){if(t===this._radius)return;var n=2*t;this._radius=t,this._size._set(n,n)}else if(t=k.read(arguments),this._radius){if(this._radius.equals(t))return;this._radius.set(t),"rectangle"===e?(n=k.max(this._size,t.multiply(2)),this._size.set(n)):"ellipse"===e&&this._size._set(2*t.width,2*t.height)}else this._radius=t.clone();this._changed(9)},isEmpty:function(){return!1},toPath:function(t){var e=new W[D.capitalize(this._type)]({center:new L,size:this._size,radius:this._radius,insert:!1});return e.copyAttributes(this),Bt.settings.applyMatrix&&e.setApplyMatrix(!0),t!==j&&!t||e.insertAbove(this),e},toShape:"#clone",_asPathItem:function(){return this.toPath(!1)},_draw:function(t,e,n,i){var r,s,a,o,h,u=this._style,l=u.hasFill(),c=u.hasStroke(),d=e.dontFinish||e.clip,_=!i;(l||c||d)&&(a=this._type,o=this._radius,h="circle"===a,e.dontStart||t.beginPath(),_&&h?t.arc(0,0,o,0,2*Math.PI,!0):(r=h?o:o.width,s=h?o:o.height,o=(h=this._size).width,h=h.height,_&&"rectangle"===a&&0===r&&0===s?t.rect(-o/2,-h/2,o,h):(h=[-(_=o/2),-(a=h/2)+s,-_,(h=s*(o=.44771525016920644))-a,(o=r*o)-_,-a,-_+r,-a,_-r,-a,_-o,-a,_,h-a,_,-a+s,_,a-s,_,a-h,_-o,a,_-r,a,-_+r,a,o-_,a,-_,a-h,-_,a-s],i&&i.transform(h,h,32),t.moveTo(h[0],h[1]),t.bezierCurveTo(h[2],h[3],h[4],h[5],h[6],h[7]),_!==r&&t.lineTo(h[8],h[9]),t.bezierCurveTo(h[10],h[11],h[12],h[13],h[14],h[15]),a!==s&&t.lineTo(h[16],h[17]),t.bezierCurveTo(h[18],h[19],h[20],h[21],h[22],h[23]),_!==r&&t.lineTo(h[24],h[25]),t.bezierCurveTo(h[26],h[27],h[28],h[29],h[30],h[31]))),t.closePath()),d||!l&&!c||(this._setStyles(t,e,n),l&&(t.fill(u.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),c&&t.stroke())},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_getBounds:function(t,e){var n=new b(this._size).setCenter(0,0),i=this._style,i=e.stroke&&i.hasStroke()&&i.getStrokeWidth();return t&&(n=t._transformBounds(n)),i?n.expand(W._getStrokePadding(i,this._getStrokeMatrix(t,e))):n}},new function(){function d(t,e,n){var i=t._radius;if(!i.isZero())for(var r=t._size.divide(2),s=1;s<=4;s++){var a=new L(1<s&&s<4?-1:1,2<s?-1:1),o=a.multiply(r),h=o.subtract(a.multiply(i));if(new b(n?o.add(a.multiply(n)):o,h).contains(e))return{point:h,quadrant:s}}}function _(t,e,n,i){t=t.divide(e);return(!i||t.isInQuadrant(i))&&t.subtract(t.normalize()).multiply(e).divide(n).length<=1}return{_contains:function t(e){if("rectangle"!==this._type)return e.divide(this.size).getLength()<=.5;var n=d(this,e);return n?e.subtract(n.point).divide(this._radius).getLength()<=1:t.base.call(this,e)},_hitTestSelf:function t(e,n,i,r){var s,a,o,h=!1,u=this._style,l=n.stroke&&u.hasStroke(),c=n.fill&&u.hasFill();return(l||c)&&(a=this._type,s=this._radius,o=l?u.getStrokeWidth()/2:0,c=n._tolerancePadding.add(W._getStrokePadding(o,!u.getStrokeScaling()&&r)),h="rectangle"===a?(u=d(this,e,o=c.multiply(2)))?_(e.subtract(u.point),s,c,u.quadrant):(u=(a=new b(this._size).setCenter(0,0)).expand(o),o=a.expand(o.negate()),u._containsPoint(e)&&!o._containsPoint(e)):_(e,s,c)),h?new O(l?"stroke":"fill",this):t.base.apply(this,arguments)}}},{statics:new function(){function i(t,e,n,i,r){var s=D.create(f.prototype);return s._type=t,s._size=n,s._radius=i,s._initialize(D.getNamed(r),e),s}return{Circle:function(){var t=arguments,e=L.readNamed(t,"center"),n=D.readNamed(t,"radius");return i("circle",e,new k(2*n),n,t)},Rectangle:function(){var t=arguments,e=b.readNamed(t,"rectangle"),n=k.min(k.readNamed(t,"radius"),e.getSize(!0).divide(2));return i("rectangle",e.getCenter(!0),e.getSize(!0),n,t)},Ellipse:function(){var t=arguments,e=f._readEllipse(t),n=e.radius;return i("ellipse",e.center,n.multiply(2),n,t)},_readEllipse:function(t){var e,n;return n=D.hasNamed(t,"radius")?(e=L.readNamed(t,"center"),k.readNamed(t,"radius")):(e=(n=b.readNamed(t,"rectangle")).getCenter(!0),n.getSize(!0).divide(2)),{center:e,radius:n}}}}}),d=V.extend({_class:"Raster",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!1,handle:!1},_serializeFields:{crossOrigin:null,source:null},_prioritize:["crossOrigin"],_smoothing:"low",beans:!0,initialize:function(t,e){var n,i;this._initialize(t,e!==j&&L.read(arguments))||((i="string"==(i=typeof t)?_.getElementById(t):"object"==i?t:null)&&i!==V.NO_INSERT&&(i.getContext||null!=i.naturalHeight?n=i:i&&((i=k.read(arguments)).isZero()||(n=ht.getCanvas(i)))),n?this.setImage(n):this.setSource(t)),this._size||(this._size=new k,this._loaded=!1)},_equals:function(t){return this.getSource()===t.getSource()},copyContent:function(t){var e=t._image,n=t._canvas;e?this._setImage(e):n&&((e=ht.getCanvas(t._size)).getContext("2d").drawImage(n,0,0),this._setImage(e)),this._crossOrigin=t._crossOrigin},getSize:function(){var t=this._size;return new n(t?t.width:0,t?t.height:0,this,"setSize")},setSize:function(t,e){var n,i=k.read(arguments);i.equals(this._size)?e&&this.clear():0<i.width&&0<i.height?(n=!e&&this.getElement(),this._setImage(ht.getCanvas(i)),n&&this.getContext(!0).drawImage(n,0,0,i.width,i.height)):(this._canvas&&ht.release(this._canvas),this._size=i.clone())},getWidth:function(){return this._size?this._size.width:0},setWidth:function(t){this.setSize(t,this.getHeight())},getHeight:function(){return this._size?this._size.height:0},setHeight:function(t){this.setSize(this.getWidth(),t)},getLoaded:function(){return this._loaded},isEmpty:function(){var t=this._size;return!t||0===t.width&&0===t.height},getResolution:function(){var t=this._matrix,e=new L(0,0).transform(t),n=new L(1,0).transform(t).subtract(e),e=new L(0,1).transform(t).subtract(e);return new k(72/n.getLength(),72/e.getLength())},getPpi:"#getResolution",getImage:function(){return this._image},setImage:function(e){var i=this;function n(t){var e=i.getView(),n=t&&t.type||"load";e&&i.responds(n)&&(Bt=e._scope,i.emit(n,new et(t)))}this._setImage(e),this._loaded?setTimeout(n,0):e&&B.add(e,{load:function(t){i._setImage(e),n(t)},error:n})},_setImage:function(t){this._canvas&&ht.release(this._canvas),t&&t.getContext?(this._image=null,this._canvas=t,this._loaded=!0):(this._image=t,this._canvas=null,this._loaded=!!(t&&t.src&&t.complete)),this._size=new k(t?t.naturalWidth||t.width:0,t?t.naturalHeight||t.height:0),this._context=null,this._changed(1033)},getCanvas:function(){if(!this._canvas){var e=ht.getContext(this._size);try{this._image&&e.drawImage(this._image,0,0),this._canvas=e.canvas}catch(t){ht.release(e)}}return this._canvas},setCanvas:"#setImage",getContext:function(t){return this._context||(this._context=this.getCanvas().getContext("2d")),t&&(this._image=null,this._changed(1025)),this._context},setContext:function(t){this._context=t},getSource:function(){var t=this._image;return t&&t.src||this.toDataURL()},setSource:function(t){var e=new u.Image,n=this._crossOrigin;n&&(e.crossOrigin=n),t&&(e.src=t),this.setImage(e)},getCrossOrigin:function(){var t=this._image;return t&&t.crossOrigin||this._crossOrigin||""},setCrossOrigin:function(t){this._crossOrigin=t;var e=this._image;e&&(e.crossOrigin=t)},getSmoothing:function(){return this._smoothing},setSmoothing:function(t){this._smoothing="string"==typeof t?t:t?"low":"off",this._changed(257)},getElement:function(){return this._canvas||this._loaded&&this._image}},{beans:!1,getSubCanvas:function(){var t=b.read(arguments),e=ht.getContext(t.getSize());return e.drawImage(this.getCanvas(),t.x,t.y,t.width,t.height,0,0,t.width,t.height),e.canvas},getSubRaster:function(){var t=b.read(arguments),e=new d(V.NO_INSERT);return e._setImage(this.getSubCanvas(t)),e.translate(t.getCenter().subtract(this.getSize().divide(2))),e._matrix.prepend(this._matrix),e.insertAbove(this),e},toDataURL:function(){var t=this._image,t=t&&t.src;if(/^data:/.test(t))return t;t=this.getCanvas();return t?t.toDataURL.apply(t,arguments):null},drawImage:function(t){var e=L.read(arguments,1);this.getContext(!0).drawImage(t,e.x,e.y)},getAverageColor:function(t){if(t?t instanceof m?i=(r=t).getBounds():"object"==typeof t&&("width"in t?i=new b(t):"x"in t&&(i=new b(t.x-.5,t.y-.5,1,1))):i=this.getBounds(),!i)return null;var e=Math.min(i.width,32),n=Math.min(i.height,32),t=d._sampleContext;t?t.clearRect(0,0,33,33):t=d._sampleContext=ht.getContext(new k(32)),t.save();var i=(new A).scale(e/i.width,n/i.height).translate(-i.x,-i.y);i.applyToContext(t),r&&r.draw(t,new D({clip:!0,matrices:[i]})),this._matrix.applyToContext(t);var r=this.getElement(),i=this._size;r&&t.drawImage(r,-i.width/2,-i.height/2),t.restore();for(var s=t.getImageData(.5,.5,Math.ceil(e),Math.ceil(n)).data,a=[0,0,0],o=0,h=0,u=s.length;h<u;h+=4){var l=s[h+3];o+=l,l/=255,a[0]+=s[h]*l,a[1]+=s[h+1]*l,a[2]+=s[h+2]*l}for(h=0;h<3;h++)a[h]/=o;return o?C.read(a):null},getPixel:function(){var t=L.read(arguments),t=this.getContext().getImageData(t.x,t.y,1,1).data;return new C("rgb",[t[0]/255,t[1]/255,t[2]/255],t[3]/255)},setPixel:function(){var t=arguments,e=L.read(t),n=C.read(t),i=n._convert("rgb"),r=n._alpha,s=this.getContext(!0),t=s.createImageData(1,1),n=t.data;n[0]=255*i[0],n[1]=255*i[1],n[2]=255*i[2],n[3]=null!=r?255*r:255,s.putImageData(t,e.x,e.y)},clear:function(){var t=this._size;this.getContext(!0).clearRect(0,0,t.width+1,t.height+1)},createImageData:function(){var t=k.read(arguments);return this.getContext().createImageData(t.width,t.height)},getImageData:function(){var t=b.read(arguments);return t.isEmpty()&&(t=new b(this._size)),this.getContext().getImageData(t.x,t.y,t.width,t.height)},putImageData:function(t){var e=L.read(arguments,1);this.getContext(!0).putImageData(t,e.x,e.y)},setImageData:function(t){this.setSize(t),this.getContext(!0).putImageData(t,0,0)},_getBounds:function(t,e){var n=new b(this._size).setCenter(0,0);return t?t._transformBounds(n):n},_hitTestSelf:function(t){if(this._contains(t)){var e=this;return new O("pixel",e,{offset:t.add(e._size.divide(2)).round(),color:{get:function(){return e.getPixel(this.offset)}}})}},_draw:function(t,e,n){var i=this.getElement();i&&0<i.width&&0<i.height&&(t.globalAlpha=q.clamp(this._opacity,0,1),this._setStyles(t,e,n),e=this._smoothing,z.setPrefixed(t,(n="off"===e)?"imageSmoothingEnabled":"imageSmoothingQuality",!n&&e),t.drawImage(i,-this._size.width/2,-this._size.height/2))},_canComposite:function(){return!0}}),s=V.extend({_class:"SymbolItem",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!0},_serializeFields:{symbol:null},initialize:function(t,e){this._initialize(t,e!==j&&L.read(arguments,1))||this.setDefinition(t instanceof v?t:new v(t))},_equals:function(t){return this._definition===t._definition},copyContent:function(t){this.setDefinition(t._definition)},getDefinition:function(){return this._definition},setDefinition:function(t){this._definition=t,this._changed(9)},getSymbol:"#getDefinition",setSymbol:"#setDefinition",isEmpty:function(){return this._definition._item.isEmpty()},_getBounds:function(t,e){var n=this._definition._item;return n._getCachedBounds(n._matrix.prepended(t),e)},_hitTestSelf:function(t,e,n){e=e.extend({all:!1}),n=this._definition._item._hitTest(t,e,n);return n&&(n.item=this),n},_draw:function(t,e){this._definition._item.draw(t,e)}}),v=D.extend({_class:"SymbolDefinition",initialize:function(t,e){this._id=o.get(),this.project=Bt.project,t&&this.setItem(t,e)},_serialize:function(t,e){return e.add(this,function(){return D.serialize([this._class,this._item],t,!1,e)})},_changed:function(t){8&t&&V._clearBoundsCache(this),1&t&&this.project._changed(t)},getItem:function(){return this._item},setItem:function(t,e){t._symbol&&(t=t.clone()),this._item&&(this._item._symbol=null),(this._item=t).remove(),t.setSelected(!1),e||t.setPosition(new L),(t._symbol=this)._changed(9)},getDefinition:"#getItem",setDefinition:"#setItem",place:function(t){return new s(this,t)},clone:function(){return new v(this._item.clone(!1))},equals:function(t){return t===this||t&&this._item.equals(t._item)||!1}}),O=D.extend({_class:"HitResult",initialize:function(t,e,n){this.type=t,this.item=e,n&&this.inject(n)},statics:{getOptions:function(t){t=t&&D.read(t);return new D({type:null,tolerance:Bt.settings.hitTolerance,fill:!t,stroke:!t,segments:!t,handles:!1,ends:!1,position:!1,center:!1,bounds:!1,guides:!1,selected:!1},t)}}}),H=D.extend({_class:"Segment",beans:!0,_selection:0,initialize:function(t,e,n,i,r,s){var a,o,h,u,l=arguments.length;0<l&&(null==t||"object"==typeof t?u=1===l&&t&&"point"in t?(a=t.point,o=t.handleIn,h=t.handleOut,t.selection):(a=t,o=e,h=n,i):(a=[t,e],o=n!==j?[n,i]:null,h=r!==j?[r,s]:null)),new p(a,this,"_point"),new p(o,this,"_handleIn"),new p(h,this,"_handleOut"),u&&this.setSelection(u)},_serialize:function(t,e){var n=this._point,i=this._selection,n=i||this.hasHandles()?[n,this._handleIn,this._handleOut]:n;return i&&n.push(i),D.serialize(n,t,!0,e)},_changed:function(t){var e,n,i,r=this._path;r&&(e=r._curves,n=this._index,e&&(t&&t!==this._point&&t!==this._handleIn||!(i=0<n?e[n-1]:r._closed?e[e.length-1]:null)||i._changed(),t&&t!==this._point&&t!==this._handleOut||!(i=e[n])||i._changed()),r._changed(41))},getPoint:function(){return this._point},setPoint:function(){this._point.set(L.read(arguments))},getHandleIn:function(){return this._handleIn},setHandleIn:function(){this._handleIn.set(L.read(arguments))},getHandleOut:function(){return this._handleOut},setHandleOut:function(){this._handleOut.set(L.read(arguments))},hasHandles:function(){return!this._handleIn.isZero()||!this._handleOut.isZero()},isSmooth:function(){var t=this._handleIn,e=this._handleOut;return!t.isZero()&&!e.isZero()&&t.isCollinear(e)},clearHandles:function(){this._handleIn._set(0,0),this._handleOut._set(0,0)},getSelection:function(){return this._selection},setSelection:function(t){var e=this._selection,n=this._path;this._selection=t=t||0,n&&t!==e&&(n._updateSelection(this,e,t),n._changed(257))},_changeSelection:function(t,e){var n=this._selection;this.setSelection(e?n|t:n&~t)},isSelected:function(){return!!(7&this._selection)},setSelected:function(t){this._changeSelection(7,t)},getIndex:function(){return this._index!==j?this._index:null},getPath:function(){return this._path||null},getCurve:function(){var t=this._path,e=this._index;return t?(0<e&&!t._closed&&e===t._segments.length-1&&e--,t.getCurves()[e]||null):null},getLocation:function(){var t=this.getCurve();return t?new U(t,this===t._segment1?0:1):null},getNext:function(){var t=this._path&&this._path._segments;return t&&(t[this._index+1]||this._path._closed&&t[0])||null},smooth:function(t,e,n){var i=t||{},r=i.type,s=i.factor,a=this.getPrevious(),o=this.getNext(),h=(a||this)._point,u=this._point,l=(o||this)._point,c=h.getDistance(u),t=u.getDistance(l);if(r&&"catmull-rom"!==r){if("geometric"!==r)throw new Error("Smoothing method '"+r+"' not supported.");a&&o&&(i=h.subtract(l),r=(f=s===j?.4:s)*c/(c+t),e||this.setHandleIn(i.multiply(r)),n||this.setHandleOut(i.multiply(r-f)))}else{var d,_,f=s===j?.5:s,s=Math.pow(c,f),c=s*s,t=Math.pow(t,f),f=t*t;!e&&a&&(d=2*f+3*t*s+c,this.setHandleIn(0!==(_=3*t*(t+s))?new L((f*h._x+d*u._x-c*l._x)/_-u._x,(f*h._y+d*u._y-c*l._y)/_-u._y):new L)),!n&&o&&(d=2*c+3*s*t+f,this.setHandleOut(0!==(_=3*s*(s+t))?new L((c*l._x+d*u._x-f*h._x)/_-u._x,(c*l._y+d*u._y-f*h._y)/_-u._y):new L))}},getPrevious:function(){var t=this._path&&this._path._segments;return t&&(t[this._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return!this._index},isLast:function(){var t=this._path;return t&&this._index===t._segments.length-1||!1},reverse:function(){var t=this._handleIn,e=this._handleOut,n=t.clone();t.set(e),e.set(n)},reversed:function(){return new H(this._point,this._handleOut,this._handleIn)},remove:function(){return!!this._path&&!!this._path.removeSegment(this._index)},clone:function(){return new H(this._point,this._handleIn,this._handleOut)},equals:function(t){return t===this||t&&this._class===t._class&&this._point.equals(t._point)&&this._handleIn.equals(t._handleIn)&&this._handleOut.equals(t._handleOut)||!1},toString:function(){var t=["point: "+this._point];return this._handleIn.isZero()||t.push("handleIn: "+this._handleIn),this._handleOut.isZero()||t.push("handleOut: "+this._handleOut),"{ "+t.join(", ")+" }"},transform:function(t){this._transformCoordinates(t,new Array(6),!0),this._changed()},interpolate:function(t,e,n){var i=1-n,r=n,s=t._point,a=e._point,o=t._handleIn,n=e._handleIn,e=e._handleOut,t=t._handleOut;this._point._set(i*s._x+r*a._x,i*s._y+r*a._y,!0),this._handleIn._set(i*o._x+r*n._x,i*o._y+r*n._y,!0),this._handleOut._set(i*t._x+r*e._x,i*t._y+r*e._y,!0),this._changed()},_transformCoordinates:function(t,e,n){var i=this._point,r=n&&this._handleIn.isZero()?null:this._handleIn,s=n&&this._handleOut.isZero()?null:this._handleOut,a=i._x,o=i._y,h=2;return e[0]=a,e[1]=o,r&&(e[h++]=r._x+a,e[h++]=r._y+o),s&&(e[h++]=s._x+a,e[h++]=s._y+o),t&&(t._transformCoordinates(e,e,h/2),a=e[0],o=e[1],n?(i._x=a,i._y=o,h=2,r&&(r._x=e[h++]-a,r._y=e[h++]-o),s&&(s._x=e[h++]-a,s._y=e[h++]-o)):(r||(e[h++]=a,e[h++]=o),s||(e[h++]=a,e[h++]=o))),e}}),p=L.extend({initialize:function(t,e,n){var i,r,s;t?(i=t[0])!==j?r=t[1]:((i=(s=t).x)===j&&(i=(s=L.read(arguments)).x),r=s.y,s=s.selected):i=r=0,this._x=i,this._y=r,(this._owner=e)[n]=this,s&&this.setSelected(!0)},_set:function(t,e){return this._x=t,this._y=e,this._owner._changed(this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner._changed(this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner._changed(this)},isZero:function(){var t=q.isZero;return t(this._x)&&t(this._y)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner._changeSelection(this._getSelection(),t)},_getSelection:function(){var t=this._owner;return this===t._point?1:this===t._handleIn?2:this===t._handleOut?4:0}}),Z=D.extend({_class:"Curve",beans:!0,initialize:function(t,e,n,i,r,s,a,o){var h,u,l,c,d,_,f=arguments.length;3===f?(this._path=t,h=e,u=n):f?1===f?"segment1"in t?(h=new H(t.segment1),u=new H(t.segment2)):"point1"in t?(l=t.point1,d=t.handle1,_=t.handle2,c=t.point2):Array.isArray(t)&&(l=[t[0],t[1]],c=[t[6],t[7]],d=[t[2]-t[0],t[3]-t[1]],_=[t[4]-t[6],t[5]-t[7]]):2===f?(h=new H(t),u=new H(e)):4===f?(l=t,d=e,_=n,c=i):8===f&&(l=[t,e],c=[a,o],d=[n-t,i-e],_=[r-a,s-o]):(h=new H,u=new H),this._segment1=h||new H(l,null,d),this._segment2=u||new H(c,_,null)},_serialize:function(t,e){return D.serialize(this.hasHandles()?[this.getPoint1(),this.getHandle1(),this.getHandle2(),this.getPoint2()]:[this.getPoint1(),this.getPoint2()],t,!0,e)},_changed:function(){this._length=this._bounds=j},clone:function(){return new Z(this._segment1,this._segment2)},toString:function(){var t=["point1: "+this._segment1._point];return this._segment1._handleOut.isZero()||t.push("handle1: "+this._segment1._handleOut),this._segment2._handleIn.isZero()||t.push("handle2: "+this._segment2._handleIn),t.push("point2: "+this._segment2._point),"{ "+t.join(", ")+" }"},classify:function(){return Z.classify(this.getValues())},remove:function(){var t,e,n=!1;return this._path&&(e=(t=this._segment2)._handleOut,(n=t.remove())&&this._segment1._handleOut.set(e)),n},getPoint1:function(){return this._segment1._point},setPoint1:function(){this._segment1._point.set(L.read(arguments))},getPoint2:function(){return this._segment2._point},setPoint2:function(){this._segment2._point.set(L.read(arguments))},getHandle1:function(){return this._segment1._handleOut},setHandle1:function(){this._segment1._handleOut.set(L.read(arguments))},getHandle2:function(){return this._segment2._handleIn},setHandle2:function(){this._segment2._handleIn.set(L.read(arguments))},getSegment1:function(){return this._segment1},getSegment2:function(){return this._segment2},getPath:function(){return this._path},getIndex:function(){return this._segment1._index},getNext:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return!this._segment1._index},isLast:function(){var t=this._path;return t&&this._segment1._index===t._curves.length-1||!1},isSelected:function(){return this.getPoint1().isSelected()&&this.getHandle1().isSelected()&&this.getHandle2().isSelected()&&this.getPoint2().isSelected()},setSelected:function(t){this.getPoint1().setSelected(t),this.getHandle1().setSelected(t),this.getHandle2().setSelected(t),this.getPoint2().setSelected(t)},getValues:function(t){return Z.getValues(this._segment1,this._segment2,t)},getPoints:function(){for(var t=this.getValues(),e=[],n=0;n<8;n+=2)e.push(new L(t[n],t[n+1]));return e}},{getLength:function(){return null==this._length&&(this._length=Z.getLength(this.getValues(),0,1)),this._length},getArea:function(){return Z.getArea(this.getValues())},getLine:function(){return new N(this._segment1._point,this._segment2._point)},getPart:function(t,e){return new Z(Z.getPart(this.getValues(),t,e))},getPartLength:function(t,e){return Z.getLength(this.getValues(),t,e)},divideAt:function(t){return this.divideAtTime(t&&t.curve===this?t.time:this.getTimeAt(t))},divideAtTime:function(t,e){var n,i,r,s,a,o,h=null;return 1e-8<=t&&t<=1-1e-8&&(n=(o=Z.subdivide(this.getValues(),t))[0],i=o[1],r=e||this.hasHandles(),s=this._segment1,a=this._segment2,t=this._path,r&&(s._handleOut._set(n[2]-n[0],n[3]-n[1]),a._handleIn._set(i[4]-i[6],i[5]-i[7])),o=n[6],e=n[7],e=new H(new L(o,e),r&&new L(n[4]-o,n[5]-e),r&&new L(i[2]-o,i[3]-e)),h=t?(t.insert(s._index+1,e),this.getNext()):(this._segment2=e,this._changed(),new Z(e,a))),h},splitAt:function(t){var e=this._path;return e?e.splitAt(t):null},splitAtTime:function(t){return this.splitAt(this.getLocationAtTime(t))},divide:function(t,e){return this.divideAtTime(t===j?.5:e?t:this.getTimeAt(t))},split:function(t,e){return this.splitAtTime(t===j?.5:e?t:this.getTimeAt(t))},reversed:function(){return new Z(this._segment2.reversed(),this._segment1.reversed())},clearHandles:function(){this._segment1._handleOut._set(0,0),this._segment2._handleIn._set(0,0)},statics:{getValues:function(t,e,n,i){var r=t._point,s=t._handleOut,a=e._handleIn,o=e._point,t=r.x,e=r.y,r=o.x,o=o.y,o=i?[t,e,t,e,r,o,r,o]:[t,e,t+s._x,e+s._y,r+a._x,o+a._y,r,o];return n&&n._transformCoordinates(o,o,4),o},subdivide:function(t,e){var n=t[0],i=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],u=t[7],l=1-(e=e===j?.5:e),c=l*n+e*r,d=l*i+e*s,_=l*r+e*a,f=l*s+e*o,t=l*a+e*h,r=l*o+e*u,s=l*c+e*_,a=l*d+e*f,o=l*_+e*t,_=l*f+e*r,f=l*s+e*o,e=l*a+e*_;return[[n,i,c,d,s,a,f,e],[f,e,o,_,t,r,h,u]]},getMonoCurves:function(t,e){var n,i,r=[],s=e?0:1,a=t[0+s],o=t[2+s],e=t[4+s],s=t[6+s];return!(o<=a==e<=o&&e<=o==s<=e||Z.isStraight(t))&&(i=q.solveQuadratic(3*(o-e)-a+s,2*(a+e)-4*o,o-a,n=[],1e-8,1-1e-8))?(n.sort(),o=n[0],a=Z.subdivide(t,o),r.push(a[0]),1<i&&(o=(n[1]-o)/(1-o),a=Z.subdivide(a[1],o),r.push(a[0])),r.push(a[1])):r.push(t),r},solveCubic:function(t,e,n,i,r,s){var a=t[e],o=t[e+2],h=t[e+4],t=t[e+6],e=0;return e=!(a<n&&t<n&&o<n&&h<n||n<a&&n<t&&n<o&&n<h)?q.solveCubic(t-a-(t=3*(o-a))-(o=3*(h-o)-t),o,t,a-n,i,r,s):e},getTimeOf:function(t,e){var n=new L(t[0],t[1]),i=new L(t[6],t[7]);if(null===(e.isClose(n,1e-12)?0:e.isClose(i,1e-12)?1:null))for(var r=[e.x,e.y],s=[],a=0;a<2;a++)for(var o=Z.solveCubic(t,a,r[a],s,0,1),h=0;h<o;h++){var u=s[h];if(e.isClose(Z.getPoint(t,u),1e-7))return u}return e.isClose(n,1e-7)?0:e.isClose(i,1e-7)?1:null},getNearestTime:function(n,i){if(Z.isStraight(n)){var t=n[0],e=n[1],r=n[6]-t,s=n[7]-e,a=r*r+s*s;if(0==a)return 0;a=((i.x-t)*r+(i.y-e)*s)/a;return a<1e-12?0:.999999999999<a?1:Z.getTimeOf(n,new L(t+a*r,e+a*s))}var o=1/0,h=0;function u(t){if(0<=t&&t<=1){var e=i.getDistance(Z.getPoint(n,t),!0);return e<o?(o=e,h=t,1):void 0}}for(var l=0;l<=100;l++)u(l/100);for(var c=.005;1e-8<c;)u(h-c)||u(h+c)||(c/=2);return h},getPart:function(t,e,n){var i,r=n<e;return r&&(i=e,e=n,n=i),0<e&&(t=Z.subdivide(t,e)[1]),n<1&&(t=Z.subdivide(t,(n-e)/(1-e))[0]),r?[t[6],t[7],t[4],t[5],t[2],t[3],t[0],t[1]]:t},isFlatEnough:function(t,e){var n=t[0],i=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],t=t[7],r=3*r-2*n-h,s=3*s-2*i-t,n=3*a-2*h-n,i=3*o-2*t-i;return Math.max(r*r,n*n)+Math.max(s*s,i*i)<=16*e*e},getArea:function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],t=t[7];return 3*((t-n)*(i+s)-(o-e)*(r+a)+r*(e-s)-i*(n-a)+t*(s+e/3)-o*(a+n/3))/20},getBounds:function(t){for(var e=t.slice(0,2),n=e.slice(),i=[0,0],r=0;r<2;r++)Z._addBounds(t[r],t[r+2],t[r+4],t[r+6],r,0,e,n,i);return new b(e[0],e[1],n[0]-e[0],n[1]-e[1])},_addBounds:function(t,e,n,i,r,s,a,o,h){function u(t,e){var n=t-e,e=t+e;n<a[r]&&(a[r]=n),e>o[r]&&(o[r]=e)}var l=a[r]+(s/=2),c=o[r]-s;if(t<l||e<l||n<l||i<l||c<t||c<e||c<n||c<i)if(e<t!=e<i&&n<t!=n<i)u(t,0),u(i,0);else{var d=q.solveQuadratic(3*(e-n)-t+i,2*(t+n)-4*e,e-t,h);u(i,0);for(var _=0;_<d;_++){var f=h[_],g=1-f;1e-8<=f&&f<=1-1e-8&&u(g*g*g*t+3*g*g*f*e+3*g*f*f*n+f*f*f*i,s)}}}}},D.each(["getBounds","getStrokeBounds","getHandleBounds"],function(t){this[t]=function(){return this._bounds||(this._bounds={}),(this._bounds[t]||(this._bounds[t]=W[t]([this._segment1,this._segment2],!1,this._path))).clone()}},{}),D.each({isStraight:function(t,e,n,i){if(e.isZero()&&n.isZero())return!0;var r=i.subtract(t);if(r.isZero())return!1;if(r.isCollinear(e)&&r.isCollinear(n)){var s=new N(t,i);if(s.getDistance(t.add(e))<1e-7&&s.getDistance(i.add(n))<1e-7){i=r.dot(r),e=r.dot(e)/i,i=r.dot(n)/i;return 0<=e&&e<=1&&i<=0&&-1<=i}}return!1},isLinear:function(t,e,n,i){t=i.subtract(t).divide(3);return e.equals(t)&&n.negate().equals(t)}},function(a,t){this[t]=function(t){var e=this._segment1,n=this._segment2;return a(e._point,e._handleOut,n._handleIn,n._point,t)},this.statics[t]=function(t,e){var n=t[0],i=t[1],r=t[6],s=t[7];return a(new L(n,i),new L(t[2]-n,t[3]-i),new L(t[4]-r,t[5]-s),new L(r,s),e)}},{statics:{},hasHandles:function(){return!this._segment1._handleOut.isZero()||!this._segment2._handleIn.isZero()},hasLength:function(t){return(!this.getPoint1().equals(this.getPoint2())||this.hasHandles())&&this.getLength()>(t||0)},isCollinear:function(t){return t&&this.isStraight()&&t.isStraight()&&this.getLine().isCollinear(t.getLine())},isHorizontal:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).y)<1e-8},isVertical:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).x)<1e-8}}),{beans:!1,getLocationAt:function(t,e){return this.getLocationAtTime(e?t:this.getTimeAt(t))},getLocationAtTime:function(t){return null!=t&&0<=t&&t<=1?new U(this,t):null},getTimeAt:function(t,e){return Z.getTimeAt(this.getValues(),t,e)},getParameterAt:"#getTimeAt",getTimesWithTangent:function(){var t=L.read(arguments);return t.isZero()?[]:Z.getTimesWithTangent(this.getValues(),t)},getOffsetAtTime:function(t){return this.getPartLength(0,t)},getLocationOf:function(){return this.getLocationAtTime(this.getTimeOf(L.read(arguments)))},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getTimeOf:function(){return Z.getTimeOf(this.getValues(),L.read(arguments))},getParameterOf:"#getTimeOf",getNearestLocation:function(){var t=L.read(arguments),e=this.getValues(),n=Z.getNearestTime(e,t),e=Z.getPoint(e,n);return new U(this,n,e,null,t.getDistance(e))},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t&&t.getPoint()}},new function(){var t=["getPoint","getTangent","getNormal","getWeightedTangent","getWeightedNormal","getCurvature"];return D.each(t,function(i){this[i+"At"]=function(t,e){var n=this.getValues();return Z[i](n,e?t:Z.getTimeAt(n,t))},this[i+"AtTime"]=function(t){return Z[i](this.getValues(),t)}},{statics:{_evaluateMethods:t}})},new function(){function l(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],t=t[7],h=9*(i-s)+3*(o-e),u=6*(e+s)-12*i,l=3*(i-e),c=9*(r-a)+3*(t-n),d=6*(n+a)-12*r,_=3*(r-n);return function(t){var e=(h*t+u)*t+l,t=(c*t+d)*t+_;return Math.sqrt(e*e+t*t)}}function c(t,e){return Math.max(2,Math.min(16,Math.ceil(32*Math.abs(e-t))))}function n(t,e,n,i){if(null==e||e<0||1<e)return null;var r=t[0],s=t[1],a=t[2],o=t[3],h=t[4],u=t[5],l=t[6],c=t[7],d=q.isZero;d(a-r)&&d(o-s)&&(a=r,o=s),d(h-l)&&d(u-c)&&(h=l,u=c);var _,f,g=3*(a-r),v=3*(h-a)-g,p=l-r-g-v,m=3*(o-s),t=3*(u-o)-m,d=c-s-m-t;return 0===n?(_=0===e?r:1===e?l:((p*e+v)*e+g)*e+r,f=0===e?s:1===e?c:((d*e+t)*e+m)*e+s):(0,f=e<1e-8?(_=g,m):1-1e-8<e?(_=3*(l-h),3*(c-u)):(_=(3*p*e+2*v)*e+g,(3*d*e+2*t)*e+m),i&&(0===_&&0===f&&(e<1e-8||1-1e-8<e)&&(_=h-a,f=u-o),(o=Math.sqrt(_*_+f*f))&&(_/=o,f/=o)),3===n&&(h=6*p*e+2*v,u=6*d*e+2*t,_=0!==(t=Math.pow(_*_+f*f,1.5))?(_*u-f*h)/t:0,f=0)),2===n?new L(f,-_):new L(_,f)}return{statics:{classify:function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],t=i*(n-h)+r*(o-e)+e*h-n*o,i=3*(s*(r-n)+a*(e-i)+i*n-r*e),r=i-t,o=r-t+(e*(h-a)+n*(s-o)+o*a-h*s),a=Math.sqrt(o*o+r*r+i*i),h=0!==a?1/a:0,s=q.isZero,a="serpentine";function u(t,e,n){var i=e!==j,r=i&&0<e&&e<1,s=i&&0<n&&n<1;return!i||(r||s)&&("loop"!==t||r&&s)||(r=s=!(t="arch")),{type:t,roots:r||s?r&&s?e<n?[e,n]:[n,e]:[r?e:n]:null}}if(r*=h,i*=h,s(o*=h))return s(r)?u(s(i)?"line":"quadratic"):u(a,i/(3*r));i=3*r*r-4*o*i;if(s(i))return u("cusp",r/(2*o));s=0<i?Math.sqrt(i/3):Math.sqrt(-i),o*=2;return u(0<i?a:"loop",(r+s)/o,(r-s)/o)},getLength:function(t,e,n,i){if(e===j&&(e=0),n===j&&(n=1),Z.isStraight(t)){var r=t;n<1&&(r=Z.subdivide(r,n)[0],e/=n);var s=(r=0<e?Z.subdivide(r,e)[1]:r)[6]-r[0],r=r[7]-r[1];return Math.sqrt(s*s+r*r)}return q.integrate(i||l(t),e,n,c(e,n))},getTimeAt:function(t,e,n){if(n===j&&(n=e<0?1:0),0===e)return n;var i=Math.abs,r=0<e,s=r?n:0,a=r?1:n,o=l(t),h=Z.getLength(t,s,a,o),t=i(e)-h;if(i(t)<1e-12)return r?a:s;if(1e-12<t)return null;var u=0;return q.findRoot(function(t){return u+=q.integrate(o,n,t,c(n,t)),n=t,u-e},o,n+e/h,s,a,32,1e-12)},getPoint:function(t,e){return n(t,e,0,!1)},getTangent:function(t,e){return n(t,e,1,!0)},getWeightedTangent:function(t,e){return n(t,e,1,!1)},getNormal:function(t,e){return n(t,e,2,!0)},getWeightedNormal:function(t,e){return n(t,e,2,!1)},getCurvature:function(t,e){return n(t,e,3,!1).x},getPeaks:function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=3*i-e-3*s+t[6],s=3*e-6*i+3*s,i=-3*e+3*i,t=3*r-n-3*a+t[7],a=3*n-6*r+3*a,n=-3*n+3*r,r=[];return q.solveCubic(9*(o*o+t*t),9*(o*s+a*t),2*(s*s+a*a)+3*(i*o+n*t),i*s+a*n,r,1e-8,1-1e-8),r.sort()}}}},new function(){function z(t,e,n,i,r,s,a){var o=!a&&n.getPrevious()===r,h=!a&&n!==r&&n.getNext()===r;null!==i&&(o?1e-8:0)<=i&&i<=(h?1-1e-8:1)&&null!==s&&(h?1e-8:0)<=s&&s<=(o?1-1e-8:1)&&(i=new U(n,i,null,a),a=new U(r,s,null,a),(i._intersection=a)._intersection=i,e&&!e(i)||U.insert(t,i,!0))}function k(t,e,n,i,r,s,a,o,h,u,l,c,d){if(4096<=++h||40<=++o)return h;var _,f,g=e[0],v=e[1],p=e[6],m=e[7],y=N.getSignedDistance,w=y(g,v,p,m,e[2],e[3]),x=y(g,v,p,m,e[4],e[5]),b=0<w*x?.75:4/9,S=b*Math.min(0,w,x),C=b*Math.max(0,w,x),P=y(g,v,p,m,t[0],t[1]),I=y(g,v,p,m,t[2],t[3]),b=y(g,v,p,m,t[4],t[5]),v=y(g,v,p,m,t[6],t[7]),p=function(t,e,n,i){var r=[0,t],s=[1/3,e],a=[2/3,n],o=[1,i],e=e-(2*t+i)/3,t=n-(t+2*i)/3;o=e*t<0?[[r,s,o],[r,a,o]]:[2<=(i=e/t)?[r,s,o]:i<=.5?[r,a,o]:[r,s,a,o],[r,o]];return(e||t)<0?o.reverse():o}(P,I,b,v),m=p[0],p=p[1];if(0===w&&0===x&&0===P&&0===I&&0===b&&0===v||null==(_=A(m,p,S,C))||null==(f=A(m.reverse(),p.reverse(),S,C)))return h;var M,T,O,C=u+(l-u)*_,l=u+(l-u)*f;return Math.max(d-c,l-C)<1e-9?(M=(C+l)/2,O=(c+d)/2,z(r,s,a?i:n,a?O:M,a?n:i,a?M:O)):(t=Z.getPart(t,_,f),u=d-c,h=.8<f-_?u<l-C?(h=k(e,(T=Z.subdivide(t,.5))[0],i,n,r,s,!a,o,h,c,d,C,M=(C+l)/2),k(e,T[1],i,n,r,s,!a,o,h,c,d,M,l)):(h=k((T=Z.subdivide(e,.5))[0],t,i,n,r,s,!a,o,h,c,O=(c+d)/2,C,l),k(T[1],t,i,n,r,s,!a,o,h,O,d,C,l)):0==u||1e-9<=u?k(e,t,i,n,r,s,!a,o,h,c,d,C,l):k(t,e,n,i,r,s,a,o,h,C,l,c,d)),h}function A(t,e,n,i){return t[0][1]<n?r(t,!0,n):e[0][1]>i?r(e,!1,i):t[0][0]}function r(t,e,n){for(var i=t[0][0],r=t[0][1],s=1,a=t.length;s<a;s++){var o=t[s][0],h=t[s][1];if(e?n<=h:h<=n)return h===n?o:i+(n-r)*(o-i)/(h-r);i=o,r=h}return null}function y(t,e,n,i,r){var s=q.isZero;if(s(i)&&s(r)){s=Z.getTimeOf(t,new L(e,n));return null===s?[]:[s]}for(var i=Math.atan2(-r,i),a=Math.sin(i),o=Math.cos(i),h=[],i=[],u=0;u<8;u+=2){var l=t[u]-e,c=t[u+1]-n;h.push(l*o-c*a,l*a+c*o)}return Z.solveCubic(h,1,0,i,0,1),i}function x(t,e,n,i,r,s){var a=1e-12,o=Math.min,h=Math.max;if(h(t[0],t[2],t[4],t[6])+a>o(e[0],e[2],e[4],e[6])&&o(t[0],t[2],t[4],t[6])-a<h(e[0],e[2],e[4],e[6])&&h(t[1],t[3],t[5],t[7])+a>o(e[1],e[3],e[5],e[7])&&o(t[1],t[3],t[5],t[7])-a<h(e[1],e[3],e[5],e[7])){var u=w(t,e);if(u)for(var l=0;l<2;l++){var c=u[l];z(r,s,n,c[0],i,c[1],!0)}else{var d=Z.isStraight(t),_=Z.isStraight(e),f=d&&_,o=d&&!_,h=r.length;if((f?function(t,e,n,i,r,s){var a=N.intersect(t[0],t[1],t[6],t[7],e[0],e[1],e[6],e[7]);a&&z(r,s,n,Z.getTimeOf(t,a),i,Z.getTimeOf(e,a))}:d||_?function(t,e,n,i,r,s,a){for(var o=e[0],h=e[1],u=y(t,o,h,e[6]-o,e[7]-h),l=0,c=u.length;l<c;l++){var d=u[l],_=Z.getPoint(t,d),_=Z.getTimeOf(e,_);null!==_&&z(r,s,a?i:n,a?_:d,a?n:i,a?d:_)}}:k)(o?e:t,o?t:e,o?i:n,o?n:i,r,s,o,0,0,0,1,0,1),!f||r.length===h)for(l=0;l<4;l++){var g=l>>1,v=1&l,p=6*g,m=6*v,p=new L(t[p],t[1+p]),m=new L(e[m],e[1+m]);p.isClose(m,a)&&z(r,s,n,g,i,v)}}}return r}function b(t,e,n,i){t=Z.classify(t);return"loop"===t.type&&z(n,i,e,(t=t.roots)[0],e,t[1]),n}function w(t,e){function n(t){var e=t[6]-t[0],t=t[7]-t[1];return e*e+t*t}var i=Math.abs,r=N.getDistance,s=1e-7,a=Z.isStraight(t),o=Z.isStraight(e),h=a&&o,u=n(t)<n(e),l=u?e:t,c=u?t:e,d=l[0],_=l[1],f=l[6]-d,u=l[7]-_;if(r(d,_,f,u,c[0],c[1],!0)<s&&r(d,_,f,u,c[6],c[7],!0)<s)!h&&r(d,_,f,u,l[2],l[3],!0)<s&&r(d,_,f,u,l[4],l[5],!0)<s&&r(d,_,f,u,c[2],c[3],!0)<s&&r(d,_,f,u,c[4],c[5],!0)<s&&(a=o=h=!0);else if(h)return null;if(a^o)return null;for(var g=[t,e],v=[],p=0;p<4&&v.length<2;p++){var m=1&p,y=1^m,w=p>>1,y=Z.getTimeOf(g[m],new L(g[y][w?6:0],g[y][w?7:1]));if(null!=y&&(w=m?[w,y]:[y,w],(!v.length||1e-8<i(w[0]-v[0][0])&&1e-8<i(w[1]-v[0][1]))&&v.push(w)),2<p&&!v.length)break}return 2!==v.length?v=null:h||(t=Z.getPart(t,v[0][0],v[1][0]),(i((e=Z.getPart(e,v[0][1],v[1][1]))[2]-t[2])>s||i(e[3]-t[3])>s||i(e[4]-t[4])>s||i(e[5]-t[5])>s)&&(v=null)),v}return{getIntersections:function(t){var e=this.getValues(),n=t&&t!==this&&t.getValues();return n?x(e,n,this,t,[]):b(e,this,[])},statics:{getOverlaps:w,getIntersections:function(t,e,n,i,r,s){for(var a=!e,o=t.length,h=(e=a?t:e).length,u=new Array(o),l=a?u:new Array(h),c=[],d=0;d<o;d++)u[d]=t[d].getValues(i);if(!a)for(d=0;d<h;d++)l[d]=e[d].getValues(r);for(var _=R.findCurveBoundsCollisions(u,l,1e-7),f=0;f<o;f++){var g=t[f],v=u[f];a&&b(v,g,c,n);var p=_[f];if(p)for(var m=0;m<p.length;m++){if(s&&c.length)return c;var y,w=p[m];(!a||f<w)&&(y=e[w],x(v,l[w],g,y,c,n))}}return c},getCurveLineIntersections:y,getTimesWithTangent:function(t,e){var n,i=t[0],r=t[1],s=t[2],a=t[3],o=t[4],h=t[5],u=t[6],l=t[7],e=(t=e.normalize()).x,t=t.y,u=3*u-9*o+9*s-3*i,l=3*l-9*h+9*a-3*r,o=6*o-12*s+6*i,h=6*h-12*a+6*r,s=3*s-3*i,i=3*a-3*r,a=2*u*t-2*l*e,r=[];return Math.abs(a)<q.CURVETIME_EPSILON?0==(a=u*h-l*o)||0<=(n=-(u*i-l*s)/a)&&n<=1&&r.push(n):(n=o*t-h*e,0<=(i=(o*o-4*u*s)*t*t+(-2*o*h+4*l*s+4*u*i)*e*t+(h*h-4*l*i)*e*e)&&0!=a&&(i=(-n+(e=Math.sqrt(i)))/a,0<=(a=-(n+e)/a)&&a<=1&&r.push(a),0<=i&&i<=1&&r.push(i))),r}}}}),U=D.extend({_class:"CurveLocation",initialize:function(t,e,n,i,r){var s;.99999999<=e&&((s=t.getNext())&&(e=0,t=s)),this._setCurve(t),this._time=e,this._point=n||t.getPointAtTime(e),this._overlap=i,this._distance=r,this._intersection=this._next=this._previous=null},_setPath:function(t){this._path=t,this._version=t?t._version:0},_setCurve:function(t){this._setPath(t._path),this._curve=t,this._segment=null,this._segment1=t._segment1,this._segment2=t._segment2},_setSegment:function(t){var e=t.getCurve();e?this._setCurve(e):(this._setPath(t._path),this._segment1=t,this._segment2=null),this._segment=t,this._time=t===this._segment1?0:1,this._point=t._point.clone()},getSegment:function(){var t,e,n=this._segment;return n||(t=this.getCurve(),0===(e=this.getTime())?n=t._segment1:1===e?n=t._segment2:null!=e&&(n=t.getPartLength(0,e)<t.getPartLength(e,1)?t._segment1:t._segment2),this._segment=n),n},getCurve:function(){var t=this._path,e=this;function n(t){t=t&&t.getCurve();if(t&&null!=(e._time=t.getTimeOf(e._point)))return e._setCurve(t),t}return t&&t._version!==this._version&&(this._time=this._offset=this._curveOffset=this._curve=null),this._curve||n(this._segment)||n(this._segment1)||n(this._segment2.getPrevious())},getPath:function(){var t=this.getCurve();return t&&t._path},getIndex:function(){var t=this.getCurve();return t&&t.getIndex()},getTime:function(){var t=this.getCurve(),e=this._time;return t&&null==e?this._time=t.getTimeOf(this._point):e},getParameter:"#getTime",getPoint:function(){return this._point},getOffset:function(){if(null==(t=this._offset)){var t=0,e=this.getPath(),n=this.getIndex();if(e&&null!=n)for(var i=e.getCurves(),r=0;r<n;r++)t+=i[r].getLength();this._offset=t+=this.getCurveOffset()}return t},getCurveOffset:function(){var t,e,n=this._curveOffset;return null==n&&(t=this.getCurve(),e=this.getTime(),this._curveOffset=n=null!=e&&t&&t.getPartLength(0,e)),n},getIntersection:function(){return this._intersection},getDistance:function(){return this._distance},divide:function(){var t=this.getCurve(),t=t&&t.divideAtTime(this.getTime());return t&&this._setSegment(t._segment1),t},split:function(){var t=this.getCurve(),e=t._path,t=t&&t.splitAtTime(this.getTime());return t&&this._setSegment(e.getLastSegment()),t},equals:function(t,e){var n,i,r,s,a=this===t;return!a&&t instanceof U&&(r=this.getCurve(),s=t.getCurve(),(n=r._path)===s._path&&(r=(i=Math.abs)(this.getOffset()-t.getOffset()),s=!e&&this._intersection,t=!e&&t._intersection,a=(r<1e-7||n&&i(n.getLength()-r)<1e-7)&&(!s&&!t||s&&t&&s.equals(t,!0)))),a},toString:function(){var t=[],e=this.getPoint(),n=x.instance;e&&t.push("point: "+e);e=this.getIndex();null!=e&&t.push("index: "+e);e=this.getTime();return null!=e&&t.push("time: "+n.number(e)),null!=this._distance&&t.push("distance: "+n.number(this._distance)),"{ "+t.join(", ")+" }"},isTouching:function(){var t=this._intersection;if(t&&this.getTangent().isCollinear(t.getTangent())){var e=this.getCurve(),t=t.getCurve();return!(e.isStraight()&&t.isStraight()&&e.getLine().intersect(t.getLine()))}return!1},isCrossing:function(){var t=this._intersection;if(!t)return!1;var e=this.getTime(),n=t.getTime(),i=1e-8,r=1-i,s=i<=e&&e<=r,a=i<=n&&n<=r;if(s&&a)return!this.isTouching();var o=this.getCurve(),h=o&&e<i?o.getPrevious():o,u=t.getCurve(),t=u&&n<i?u.getPrevious():u;if(r<e&&(o=o.getNext()),r<n&&(u=u.getNext()),!(h&&o&&t&&u))return!1;var l=[];function c(t,e){var n=t.getValues(),i=Z.classify(n).roots||Z.getPeaks(n),t=i.length,i=Z.getLength(n,e&&t?i[t-1]:0,!e&&t?i[0]:1);l.push(t?i:i/32)}function d(t,e,n){return e<n?e<t&&t<n:e<t||t<n}s||(c(h,!0),c(o,!1)),a||(c(t,!0),c(u,!1));i=this.getPoint(),r=Math.min.apply(Math,l),o=s?o.getTangentAtTime(e):o.getPointAt(r).subtract(i),h=s?o.negate():h.getPointAt(-r).subtract(i),u=a?u.getTangentAtTime(n):u.getPointAt(r).subtract(i),i=a?u.negate():t.getPointAt(-r).subtract(i),h=h.getAngle(),o=o.getAngle(),i=i.getAngle(),u=u.getAngle();return!!(s?d(h,i,u)^d(o,i,u)&&d(h,u,i)^d(o,u,i):d(i,h,o)^d(u,h,o)&&d(i,o,h)^d(u,o,h))},hasOverlap:function(){return!!this._overlap}},D.each(Z._evaluateMethods,function(t){var n=t+"At";this[t]=function(){var t=this.getCurve(),e=this.getTime();return null!=e&&t&&t[n](e,!0)}},{preserve:!0}),new function(){function i(r,s,t){var a=r.length,e=0,n=a-1;function i(t,e){for(var n=t+e;-1<=n&&n<=a;n+=e){var i=r[(n%a+a)%a];if(!s.getPoint().isClose(i.getPoint(),1e-7))break;if(s.equals(i))return i}return null}for(;e<=n;){var o,h=e+n>>>1,u=r[h];if(t&&(o=s.equals(u)?u:i(h,-1)||i(h,1)))return s._overlap&&(o._overlap=o._intersection._overlap=!0),o;var l=s.getPath(),c=u.getPath();(l!==c?l._id-c._id:s.getIndex()+s.getTime()-(u.getIndex()+u.getTime()))<0?n=h-1:e=1+h}return r.splice(e,0,s),s}return{statics:{insert:i,expand:function(t){for(var e=t.slice(),n=t.length-1;0<=n;n--)i(e,t[n]._intersection,!1);return e}}}}),m=V.extend({_class:"PathItem",_selectBounds:!1,_canScaleStroke:!0,beans:!0,initialize:function(){},statics:{create:function(t){var e,n,i;return D.isPlainObject(t)?(n=t.segments,e=t.pathData):Array.isArray(t)?n=t:"string"==typeof t&&(e=t),n?i=(i=n[0])&&Array.isArray(i[0]):e&&(i=1<(e.match(/m/gi)||[]).length||/z\s*\S+/i.test(e)),new(i?G:W)(t)}},_asPathItem:function(){return this},isClockwise:function(){return 0<=this.getArea()},setClockwise:function(t){this.isClockwise()!=(t=!!t)&&this.reverse()},setPathData:function(t){var e,n,i=t&&t.match(/[mlhvcsqtaz][^mlhvcsqtaz]*/gi),r=!1,s=new L,a=new L;function o(t,e){t=+c[t];return r&&(t+=s[e]),t}function h(t){return new L(o(t,"x"),o(t+1,"y"))}this.clear();for(var u=0,l=i&&i.length;u<l;u++){var c,d=i[u],_=d[0],f=_.toLowerCase(),g=(c=d.match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g))&&c.length,r=_===f;switch("z"!==e||/[mz]/.test(f)||this.moveTo(s),f){case"m":case"l":for(var v="m"===f,p=0;p<g;p+=2)this[v?"moveTo":"lineTo"](s=h(p)),v&&(a=s,v=!1);n=s;break;case"h":case"v":for(var m="h"===f?"x":"y",s=s.clone(),p=0;p<g;p++)s[m]=o(p,m),this.lineTo(s);n=s;break;case"c":for(p=0;p<g;p+=6)this.cubicCurveTo(h(p),n=h(p+2),s=h(p+4));break;case"s":for(p=0;p<g;p+=4)this.cubicCurveTo(/[cs]/.test(e)?s.multiply(2).subtract(n):s,n=h(p),s=h(p+2)),e=f;break;case"q":for(p=0;p<g;p+=4)this.quadraticCurveTo(n=h(p),s=h(p+2));break;case"t":for(p=0;p<g;p+=2)this.quadraticCurveTo(n=/[qt]/.test(e)?s.multiply(2).subtract(n):s,s=h(p)),e=f;break;case"a":for(p=0;p<g;p+=7)this.arcTo(s=h(p+5),new k(+c[p],+c[p+1]),+c[p+2],+c[p+4],+c[p+3]);break;case"z":this.closePath(1e-12),s=a}e=f}},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_contains:function(t){t=t.isInside(this.getBounds({internal:!0,handle:!0}))?this._getWinding(t):{};return t.onPath||!!("evenodd"===this.getFillRule()?1&t.windingL||1&t.windingR:t.winding)},getIntersections:function(t,e,n,i){var r=this===t||!t,s=this._matrix._orNullIfIdentity(),n=r?s:(n||t._matrix)._orNullIfIdentity();return r||this.getBounds(s).intersects(t.getBounds(n),1e-12)?Z.getIntersections(this.getCurves(),!r&&t.getCurves(),e,s,n,i):[]},getCrossings:function(t){return this.getIntersections(t,function(t){return t.isCrossing()})},getNearestLocation:function(){for(var t=L.read(arguments),e=this.getCurves(),n=1/0,i=null,r=0,s=e.length;r<s;r++){var a=e[r].getNearestLocation(t);a._distance<n&&(n=a._distance,i=a)}return i},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t&&t.getPoint()},interpolate:function(t,e,n){var i=!this._children,r=i?"_segments":"_children",s=t[r],a=e[r],o=this[r];if(!s||!a||s.length!==a.length)throw new Error("Invalid operands in interpolate() call: "+t+", "+e);var e=o.length,h=a.length;if(e<h)for(var u=i?H:W,l=e;l<h;l++)this.add(new u);else h<e&&this[i?"removeSegments":"removeChildren"](h,e);for(l=0;l<h;l++)o[l].interpolate(s[l],a[l],n);i&&(this.setClosed(t._closed),this._changed(9))},compare:function(t){var e=!1;if(t){var n=this._children||[this],i=t._children?t._children.slice():[t],r=n.length,t=i.length,s=[],a=0;e=!0;for(var o=R.findItemBoundsCollisions(n,i,q.GEOMETRIC_EPSILON),h=r-1;0<=h&&e;h--){var u=n[h],e=!1,l=o[h];if(l)for(var c=l.length-1;0<=c&&!e;c--)u.compare(i[l[c]])&&(s[l[c]]||(s[l[c]]=!0,a++),e=!0)}e=e&&a===t}return e}}),W=m.extend({_class:"Path",_serializeFields:{segments:[],closed:!1},initialize:function(t){this._closed=!1,this._segments=[],this._version=0;var e=arguments,e=Array.isArray(t)?"object"==typeof t[0]?t:e:!t||t.size!==j||t.x===j&&t.point===j?null:e;e&&0<e.length?this.setSegments(e):(this._curves=j,this._segmentSelection=0,e||"string"!=typeof t||(this.setPathData(t),t=null)),this._initialize(!e&&t)},_equals:function(t){return this._closed===t._closed&&D.equals(this._segments,t._segments)},copyContent:function(t){this.setSegments(t._segments),this._closed=t._closed},_changed:function t(e){if(t.base.call(this,e),8&e){if(this._length=this._area=j,32&e)this._version++;else if(this._curves)for(var n=0,i=this._curves.length;n<i;n++)this._curves[n]._changed()}else 64&e&&(this._bounds=j)},getStyle:function(){var t=this._parent;return(t instanceof G?t:this)._style},getSegments:function(){return this._segments},setSegments:function(t){var e,n=this.isFullySelected(),i=t&&t.length;this._segments.length=0,this._segmentSelection=0,this._curves=j,i&&("boolean"==typeof(e=t[i-1])&&(this.setClosed(e),i--),this._add(H.readList(t,0,{},i))),n&&this.setFullySelected(!0)},getFirstSegment:function(){return this._segments[0]},getLastSegment:function(){return this._segments[this._segments.length-1]},getCurves:function(){var t=this._curves,e=this._segments;if(!t)for(var n=this._countCurves(),t=this._curves=new Array(n),i=0;i<n;i++)t[i]=new Z(this,e[i],e[i+1]||e[0]);return t},getFirstCurve:function(){return this.getCurves()[0]},getLastCurve:function(){var t=this.getCurves();return t[t.length-1]},isClosed:function(){return this._closed},setClosed:function(t){var e;this._closed!=(t=!!t)&&(this._closed=t,this._curves&&(e=this._curves.length=this._countCurves(),t&&(this._curves[e-1]=new Z(this,this._segments[e-1],this._segments[0]))),this._changed(41))}},{beans:!0,getPathData:function(n,t){var i,r,s,a,o,h,u,l,e=this._segments,c=e.length,d=new x(t),_=new Array(6),f=!0,g=[];function v(t,e){t._transformCoordinates(n,_),i=_[0],r=_[1],f?(g.push("M"+d.pair(i,r)),f=!1):(o=_[2],h=_[3],o===i&&h===r&&u===s&&l===a?e||(t=r-a,g.push(0==(e=i-s)?"v"+d.number(t):0==t?"h"+d.number(e):"l"+d.pair(e,t))):g.push("c"+d.pair(u-s,l-a)+" "+d.pair(o-s,h-a)+" "+d.pair(i-s,r-a))),s=i,a=r,u=_[4],l=_[5]}if(!c)return"";for(var p=0;p<c;p++)v(e[p]);return this._closed&&0<c&&(v(e[0],!0),g.push("z")),g.join("")},isEmpty:function(){return!this._segments.length},_transformContent:function(t){for(var e=this._segments,n=new Array(6),i=0,r=e.length;i<r;i++)e[i]._transformCoordinates(t,n,!0);return!0},_add:function(t,e){for(var n=this._segments,i=this._curves,r=t.length,s=null==e,e=s?n.length:e,a=0;a<r;a++){var o=t[a];(o=o._path?t[a]=o.clone():o)._path=this,o._index=e+a,o._selection&&this._updateSelection(o,0,o._selection)}if(s)D.push(n,t);else{n.splice.apply(n,[e,0].concat(t));for(var a=e+r,h=n.length;a<h;a++)n[a]._index=a}if(i){var u=this._countCurves(),l=0<e&&e+r-1===u?e-1:e,s=l,c=Math.min(l+r,u);t._curves&&(i.splice.apply(i,[l,0].concat(t._curves)),s+=t._curves.length);for(a=s;a<c;a++)i.splice(a,0,new Z(this,null,null));this._adjustCurves(l,c)}return this._changed(41),t},_adjustCurves:function(t,e){for(var n,i=this._segments,r=this._curves,s=t;s<e;s++)(n=r[s])._path=this,n._segment1=i[s],n._segment2=i[s+1]||i[0],n._changed();(n=r[this._closed&&!t?i.length-1:t-1])&&(n._segment2=i[t]||i[0],n._changed()),(n=r[e])&&(n._segment1=i[e],n._changed())},_countCurves:function(){var t=this._segments.length;return!this._closed&&0<t?t-1:t},add:function(t){var e=arguments;return 1<e.length&&"number"!=typeof t?this._add(H.readList(e)):this._add([H.read(e)])[0]},insert:function(t,e){var n=arguments;return 2<n.length&&"number"!=typeof e?this._add(H.readList(n,1),t):this._add([H.read(n,1)],t)[0]},addSegment:function(){return this._add([H.read(arguments)])[0]},insertSegment:function(t){return this._add([H.read(arguments,1)],t)[0]},addSegments:function(t){return this._add(H.readList(t))},insertSegments:function(t,e){return this._add(H.readList(e),t)},removeSegment:function(t){return this.removeSegments(t,t+1)[0]||null},removeSegments:function(t,e,n){t=t||0,e=D.pick(e,this._segments.length);var i=this._segments,r=this._curves,s=i.length,a=i.splice(t,e-t),o=a.length;if(!o)return a;for(var h=0;h<o;h++){var u=a[h];u._selection&&this._updateSelection(u,u._selection,0),u._index=u._path=null}for(var h=t,l=i.length;h<l;h++)i[h]._index=h;if(r){for(t=0<t&&e===s+(this._closed?1:0)?t-1:t,h=(r=r.splice(t,o)).length-1;0<=h;h--)r[h]._path=null;n&&(a._curves=r.slice(1)),this._adjustCurves(t,t)}return this._changed(41),a},clear:"#removeSegments",hasHandles:function(){for(var t=this._segments,e=0,n=t.length;e<n;e++)if(t[e].hasHandles())return!0;return!1},clearHandles:function(){for(var t=this._segments,e=0,n=t.length;e<n;e++)t[e].clearHandles()},getLength:function(){if(null==this._length){for(var t=this.getCurves(),e=0,n=0,i=t.length;n<i;n++)e+=t[n].getLength();this._length=e}return this._length},getArea:function(){if(null==(n=this._area)){for(var t=this._segments,e=this._closed,n=0,i=0,r=t.length;i<r;i++){var s=i+1===r;n+=Z.getArea(Z.getValues(t[i],t[s?0:i+1],null,s&&!e))}this._area=n}return n},isFullySelected:function(){var t=this._segments.length;return this.isSelected()&&0<t&&this._segmentSelection===7*t},setFullySelected:function(t){t&&this._selectSegments(!0),this.setSelected(t)},setSelection:function t(e){1&e||this._selectSegments(!1),t.base.call(this,e)},_selectSegments:function(t){var e=this._segments,n=e.length,i=t?7:0;this._segmentSelection=i*n;for(var r=0;r<n;r++)e[r]._selection=i},_updateSelection:function(t,e,n){t._selection=n,0<(this._segmentSelection+=n-e)&&this.setSelected(!0)},divideAt:function(t){var e,t=this.getLocationAt(t);return t&&(e=t.getCurve().divideAt(t.getCurveOffset()))?e._segment1:null},splitAt:function(t){var e=this.getLocationAt(t),n=e&&e.index,t=e&&e.time;1-1e-8<t&&(n++,t=0);e=this.getCurves();if(0<=n&&n<e.length){1e-8<=t&&e[n++].divideAtTime(t);var i,n=this.removeSegments(n,this._segments.length,!0);return this._closed?(this.setClosed(!1),i=this):((i=new W(V.NO_INSERT)).insertAbove(this),i.copyAttributes(this)),i._add(n,0),this.addSegment(n[0]),i}return null},split:function(t,e){e=e===j?t:(t=this.getCurves()[t])&&t.getLocationAtTime(e);return null!=e?this.splitAt(e):null},join:function(t,e){var n=e||0;if(t&&t!==this){var i=t._segments,r=this.getLastSegment(),s=t.getLastSegment();if(!s)return this;r&&r._point.isClose(s._point,n)&&t.reverse();e=t.getFirstSegment();r&&r._point.isClose(e._point,n)?(r.setHandleOut(e._handleOut),this._add(i.slice(1))):((r=this.getFirstSegment())&&r._point.isClose(e._point,n)&&t.reverse(),s=t.getLastSegment(),r&&r._point.isClose(s._point,n)?(r.setHandleIn(s._handleIn),this._add(i.slice(0,i.length-1),0)):this._add(i.slice())),t._closed&&this._add([i[0]]),t.remove()}i=this.getFirstSegment(),t=this.getLastSegment();return i!==t&&i._point.isClose(t._point,n)&&(i.setHandleIn(t._handleIn),t.remove(),this.setClosed(!0)),this},reduce:function(t){for(var e=this.getCurves(),n=t&&t.simplify,i=n?1e-7:0,r=e.length-1;0<=r;r--){var s=e[r];!s.hasHandles()&&(!s.hasLength(i)||n&&s.isCollinear(s.getNext()))&&s.remove()}return this},reverse:function(){this._segments.reverse();for(var t=0,e=this._segments.length;t<e;t++){var n=this._segments[t],i=n._handleIn;n._handleIn=n._handleOut,n._handleOut=i,n._index=t}this._curves=null,this._changed(9)},flatten:function(t){for(var e=new y(this,t||.25,256,!0).parts,n=e.length,i=[],r=0;r<n;r++)i.push(new H(e[r].curve.slice(0,2)));!this._closed&&0<n&&i.push(new H(e[n-1].curve.slice(6))),this.setSegments(i)},simplify:function(t){t=new h(this).fit(t||2.5);return t&&this.setSegments(t),!!t},smooth:function(t){var r=this,e=t||{},t=e.type||"asymmetric",n=this._segments,s=n.length,a=this._closed;function i(t,e){var n=t&&t.index;if(null!=n){var i=t.path;if(i&&i!==r)throw new Error(t._class+" "+n+" of "+i+" is not part of "+r);e&&t instanceof Z&&n++}else n="number"==typeof t?t:e;return Math.min(n<0&&a?n%s:n<0?n+s:n,s-1)}var o=a&&e.from===j&&e.to===j,h=i(e.from,0),u=i(e.to,s-1);if(u<h&&(a?h-=s:(c=h,h=u,u=c)),/^(?:asymmetric|continuous)$/.test(t)){var l="asymmetric"===t,c=Math.min,t=u-h+1,d=t-1,t=o?c(t,4):1,_=t,t=t,f=[];if(a||(_=c(1,h),t=c(1,s-u-1)),!((d+=_+t)<=1)){for(var g=0,v=h-_;g<=d;g++,v++)f[g]=n[(v<0?v+s:v)%s]._point;for(var p=d-1,m=[T=f[0]._x+2*f[1]._x],y=[O=f[0]._y+2*f[1]._y],w=[M=2],x=[],b=[],g=1;g<d;g++)var S=g<p,C=S?4:l?3:8,P=S?2:l?0:1,I=(S||l?1:2)/M,M=w[g]=(S?4:l?2:7)-I,T=m[g]=C*f[g]._x+P*f[g+1]._x-I*T,O=y[g]=C*f[g]._y+P*f[g+1]._y-I*O;x[p]=m[p]/w[p],b[p]=y[p]/w[p];for(g=d-2;0<=g;g--)x[g]=(m[g]-x[g+1])/w[g],b[g]=(y[g]-b[g+1])/w[g];x[d]=(3*f[d]._x-x[p])/2,b[d]=(3*f[d]._y-b[p])/2;for(var g=_,z=d-t,v=h;g<=z;g++,v++){var k=n[v<0?v+s:v],A=k._point,L=x[g]-A._x,A=b[g]-A._y;(o||g<z)&&k.setHandleOut(L,A),(o||_<g)&&k.setHandleIn(-L,-A)}}}else for(g=h;g<=u;g++)n[g<0?g+s:g].smooth(e,!o&&g===h,!o&&g===u)},toShape:function(t){if(!this._closed)return null;var e,n,i,r,s,a,o=this._segments;function h(t,e){var n=o[t],i=n.getNext(),t=o[e],e=t.getNext();return n._handleOut.isZero()&&i._handleIn.isZero()&&t._handleOut.isZero()&&e._handleIn.isZero()&&i._point.subtract(n._point).isCollinear(e._point.subtract(t._point))}function u(t){var e=o[t],n=e.getNext(),i=e._handleOut,r=n._handleIn,s=.5522847498307936;if(i.isOrthogonal(r)){t=e._point,e=n._point,n=new N(t,i,!0).intersect(new N(e,r,!0),!0);return n&&q.isZero(i.getLength()/n.subtract(t).getLength()-s)&&q.isZero(r.getLength()/n.subtract(e).getLength()-s)}}function l(t,e){return o[t]._point.getDistance(o[e]._point)}if(!this.hasHandles()&&4===o.length&&h(0,2)&&h(1,3)&&(s=o[r=1],a=s.getPrevious(),r=s.getNext(),a._handleOut.isZero()&&s._handleIn.isZero()&&s._handleOut.isZero()&&r._handleIn.isZero()&&s._point.subtract(a._point).isOrthogonal(r._point.subtract(s._point)))?(e=f.Rectangle,n=new k(l(0,3),l(0,1)),i=o[1]._point.add(o[2]._point).divide(2)):8===o.length&&u(0)&&u(2)&&u(4)&&u(6)&&h(1,5)&&h(3,7)?(e=f.Rectangle,d=(n=new k(l(1,6),l(0,3))).subtract(new k(l(0,7),l(1,2))).divide(2),i=o[3]._point.add(o[4]._point).divide(2)):4===o.length&&u(0)&&u(1)&&u(2)&&u(3)&&(d=q.isZero(l(0,2)-l(1,3))?(e=f.Circle,l(0,2)/2):(e=f.Ellipse,new k(l(2,0)/2,l(3,1)/2)),i=o[1]._point),e){var c=this.getPosition(!0),d=new e({center:c,size:n,radius:d,insert:!1});return d.copyAttributes(this,!0),d._matrix.prepend(this._matrix),d.rotate(i.subtract(c).getAngle()+90),t!==j&&!t||d.insertAbove(this),d}return null},toPath:"#clone",compare:function t(e){if(!e||e instanceof G)return t.base.call(this,e);var n=this.getCurves(),i=e.getCurves(),r=n.length,s=i.length;if(!r||!s)return r==s;for(var a,o,h=n[0].getValues(),u=[],l=0,c=0,d=0;d<s;d++){var _=i[d].getValues();if(u.push(_),v=Z.getOverlaps(h,_)){a=!d&&0<v[0][0]?s-1:d,o=v[0][1];break}}for(var f,g=Math.abs,_=u[a];h&&_;){var v=Z.getOverlaps(h,_);if(v)if(g(v[0][0]-c)<1e-8){1===(c=v[1][0])&&(h=++l<r?n[l].getValues():null,c=0);var p=v[0][1];if(g(p-o)<1e-8){if(f=f||[a,p],1===(o=v[1][1])&&(_=u[a=++a>=s?0:a]||i[a].getValues(),o=0),!h)return f[0]===a&&f[1]===o;continue}}break}return!1},_hitTestSelf:function(n,r,t,i){var s,a,o,h,e,u,l=this,c=this.getStyle(),d=this._segments,_=d.length,f=this._closed,g=r._tolerancePadding,v=g,p=r.stroke&&c.hasStroke(),m=r.fill&&c.hasFill(),y=r.curves,w=p?c.getStrokeWidth()/2:m&&0<r.tolerance||y?0:null;function x(t,e){return n.subtract(t).divide(e).length<=1}function b(t,e,n){if(!r.selected||e.isSelected()){var i=t._point;if(x(e=e!==i?e.add(i):e,v))return new O(n,l,{segment:t,point:e})}}function S(t,e){return(e||r.segments)&&b(t,t._point,"segment")||!e&&r.handles&&(b(t,t._handleIn,"handle-in")||b(t,t._handleOut,"handle-out"))}function C(t){h.add(t)}function P(t){var e=f||0<t._index&&t._index<_-1;return"round"===(e?s:a)?x(t._point,v):(h=new W({internal:!0,closed:!0}),e?t.isSmooth()||W._addBevelJoin(t,s,w,o,null,i,C,!0):"square"===a&&W._addSquareCap(t,a,w,null,i,C,!0),!h.isEmpty()&&(h.contains(n)||(t=h.getNearestLocation(n))&&x(t.getPoint(),g)))}if(null!==w&&(0<w?(s=c.getStrokeJoin(),a=c.getStrokeCap(),o=c.getMiterLimit(),v=v.add(W._getStrokePadding(w,i))):s=a="round"),!r.ends||r.segments||f){if(r.segments||r.handles)for(var I=0;I<_;I++)if(e=S(d[I]))return e}else if(e=S(d[0],!0)||S(d[_-1],!0))return e;if(null!==w&&((u=this.getNearestLocation(n))&&(0===(c=u.getTime())||1===c&&1<_?P(u.getSegment())||(u=null):x(u.getPoint(),v)||(u=null)),!u&&"miter"===s&&1<_))for(I=0;I<_;I++){var M=d[I];if(n.getDistance(M._point)<=o*w&&P(M)){u=M.getLocation();break}}return!u&&m&&this._contains(n)||u&&!p&&!y?new O("fill",this):u?new O(p?"stroke":"curve",this,{location:u,point:u.getPoint()}):null}},D.each(Z._evaluateMethods,function(e){this[e+"At"]=function(t){t=this.getLocationAt(t);return t&&t[e]()}},{beans:!1,getLocationOf:function(){for(var t=L.read(arguments),e=this.getCurves(),n=0,i=e.length;n<i;n++){var r=e[n].getLocationOf(t);if(r)return r}return null},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getLocationAt:function(t){if("number"==typeof t){for(var e=this.getCurves(),n=0,i=0,r=e.length;i<r;i++){var s=n,a=e[i];if(t<(n+=a.getLength()))return a.getLocationAt(t-s)}if(0<e.length&&t<=this.getLength())return new U(e[e.length-1],1)}else if(t&&t.getPath&&t.getPath()===this)return t;return null},getOffsetsWithTangent:function(){var t=L.read(arguments);if(t.isZero())return[];for(var e=[],n=0,i=this.getCurves(),r=0,s=i.length;r<s;r++){for(var a=i[r],o=a.getTimesWithTangent(t),h=0,u=o.length;h<u;h++){var l=n+a.getOffsetAtTime(o[h]);e.indexOf(l)<0&&e.push(l)}n+=a.length}return e}}),new function(){function p(i,t,r){var s,a,o,h,u,l,c,d,e=t._segments,n=e.length,_=new Array(6),f=!0;function g(t){var e,n;a=r?(t._transformCoordinates(r,_),s=_[0],_[1]):(e=t._point,s=e._x,e._y),f?(i.moveTo(s,a),f=!1):(l=r?(u=_[2],_[3]):(n=t._handleIn,u=s+n._x,a+n._y),u===s&&l===a&&c===o&&d===h?i.lineTo(s,a):i.bezierCurveTo(c,d,u,l,s,a)),o=s,h=a,d=r?(c=_[4],_[5]):(n=t._handleOut,c=o+n._x,h+n._y)}for(var v=0;v<n;v++)g(e[v]);t._closed&&0<n&&g(e[0])}return{_draw:function(t,e,n,i){var r=e.dontStart,s=e.dontFinish||e.clip,a=this.getStyle(),o=a.hasFill(),h=a.hasStroke(),u=a.getDashArray(),l=!Bt.support.nativeDash&&h&&u&&u.length;function c(t){return u[(t%l+l)%l]}if(r||t.beginPath(),(o||h&&!l||s)&&(p(t,this,i),this._closed&&t.closePath()),!s&&(o||h)&&(this._setStyles(t,e,n),o&&(t.fill(a.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),h)){if(l){r||t.beginPath();for(var d,_=new y(this,.25,32,!1,i),f=_.length,g=-a.getDashOffset(),v=0;0<g;)g-=c(v--)+c(v--);for(;g<f;)d=g+c(v++),(0<g||0<d)&&_.drawPart(t,Math.max(g,0),Math.max(d,0)),g=d+c(v++)}t.stroke()}},_drawSelected:function(t,e){t.beginPath(),p(t,this,e),t.stroke(),function(n,t,e,i){if(!(i<=0))for(var r,s,a=i/2,o=i-2,h=a-1,u=new Array(6),l=0,c=t.length;l<c;l++){var d=t[l],_=d._selection;d._transformCoordinates(e,u),r=u[0],s=u[1],2&_&&f(2),4&_&&f(4),n.fillRect(r-a,s-a,i,i),0<o&&!(1&_)&&(_=n.fillStyle,n.fillStyle="#ffffff",n.fillRect(r-h,s-h,o,o),n.fillStyle=_)}function f(t){var e=u[t],t=u[t+1];r==e&&s==t||(n.beginPath(),n.moveTo(r,s),n.lineTo(e,t),n.stroke(),n.beginPath(),n.arc(e,t,a,0,2*Math.PI,!0),n.fill())}}(t,this._segments,e,Bt.settings.handleSize)}}},new function(){function z(t){t=t._segments;if(!t.length)throw new Error("Use a moveTo() command first");return t[t.length-1]}return{moveTo:function(){var t=this._segments;1===t.length&&this.removeSegment(0),t.length||this._add([new H(L.read(arguments))])},moveBy:function(){throw new Error("moveBy() is unsupported on Path items.")},lineTo:function(){this._add([new H(L.read(arguments))])},cubicCurveTo:function(){var t=arguments,e=L.read(t),n=L.read(t),i=L.read(t),t=z(this);t.setHandleOut(e.subtract(t._point)),this._add([new H(i,n.subtract(i))])},quadraticCurveTo:function(){var t=arguments,e=L.read(t),n=L.read(t),t=z(this)._point;this.cubicCurveTo(e.add(t.subtract(e).multiply(1/3)),e.add(n.subtract(e).multiply(1/3)),n)},curveTo:function(){var t=arguments,e=L.read(t),n=L.read(t),i=D.pick(D.read(t),.5),r=1-i,t=z(this)._point,r=e.subtract(t.multiply(r*r)).subtract(n.multiply(i*i)).divide(2*i*r);if(r.isNaN())throw new Error("Cannot put a curve through points with parameter = "+i);this.quadraticCurveTo(r,n)},arcTo:function(){var t,e=arguments,n=Math.abs,i=Math.sqrt,r=z(this),s=r._point,a=L.read(e),o=D.peek(e);if("boolean"==typeof(d=D.pick(o,!0)))var h=(f=s.add(a).divide(2)).add(f.subtract(s).rotate(d?-90:90));else if(D.remain(e)<=2)h=a,a=L.read(e);else if(!s.equals(a)){var u=k.read(e),l=q.isZero;if(l(u.width)||l(u.height))return this.lineTo(a);var c=D.read(e),d=!!D.read(e),_=!!D.read(e),f=s.add(a).divide(2),g=(T=s.subtract(f).rotate(-c)).x,v=T.y,p=n(u.width),m=n(u.height),y=p*p,o=m*m,l=g*g,e=v*v,u=i(l/y+e/o);if(1<u&&(y=(p*=u)*p,o=(m*=u)*m),(u=n(u=(y*o-y*e-o*l)/(y*e+o*l))<1e-12?0:u)<0)throw new Error("Cannot create an arc with the given arguments");w=new L(p*v/m,-m*g/p).multiply((_===d?-1:1)*i(u)).rotate(c).add(f),c=(x=(t=(new A).translate(w).rotate(c).scale(p,m))._inverseTransform(s)).getDirectedAngle(t._inverseTransform(a)),!d&&0<c?c-=360:d&&c<0&&(c+=360)}if(h){var w,p=new N(s.add(h).divide(2),h.subtract(s).rotate(90),!0),m=new N(h.add(a).divide(2),a.subtract(h).rotate(90),!0),d=new N(s,a),h=d.getSide(h);if(!(w=p.intersect(m,!0))){if(!h)return this.lineTo(a);throw new Error("Cannot create an arc with the given arguments")}var x,c=(x=s.subtract(w)).getDirectedAngle(a.subtract(w)),d=d.getSide(w,!0);0===d?c=h*n(c):h===d&&(c+=c<0?360:-360)}if(c){for(var n=n(c),b=360<=n?4:Math.ceil((n-1e-5)/90),S=c/b,c=S*Math.PI/360,C=4/3*Math.sin(c)/(1+Math.cos(c)),P=[],I=0;I<=b;I++){var M,T=a,O=null;I<b&&(O=x.rotate(90).multiply(C),t?(T=t._transformPoint(x),O=t._transformPoint(x.add(O)).subtract(T)):T=w.add(x)),I?(M=x.rotate(-90).multiply(C),t&&(M=t._transformPoint(x.add(M)).subtract(T)),P.push(new H(T,M,O))):r.setHandleOut(O),x=x.rotate(S)}this._add(P)}},lineBy:function(){var t=L.read(arguments),e=z(this)._point;this.lineTo(e.add(t))},curveBy:function(){var t=arguments,e=L.read(t),n=L.read(t),i=D.read(t),t=z(this)._point;this.curveTo(t.add(e),t.add(n),i)},cubicCurveBy:function(){var t=arguments,e=L.read(t),n=L.read(t),i=L.read(t),t=z(this)._point;this.cubicCurveTo(t.add(e),t.add(n),t.add(i))},quadraticCurveBy:function(){var t=arguments,e=L.read(t),n=L.read(t),t=z(this)._point;this.quadraticCurveTo(t.add(e),t.add(n))},arcBy:function(){var t=arguments,e=z(this)._point,n=e.add(L.read(t)),i=D.pick(D.peek(t),!0);"boolean"==typeof i?this.arcTo(n,i):this.arcTo(n,e.add(L.read(t)))},closePath:function(t){this.setClosed(!0),this.join(this,t)}}},{_getBounds:function(t,e){var n=e.handle?"getHandleBounds":e.stroke?"getStrokeBounds":"getBounds";return W[n](this._segments,this._closed,this,t,e)},statics:{getBounds:function(t,e,n,i,r,s){var a=t[0];if(!a)return new b;var o=new Array(6),h=a._transformCoordinates(i,new Array(6)),u=h.slice(0,2),l=u.slice(),c=new Array(2);function d(t){t._transformCoordinates(i,o);for(var e=0;e<2;e++)Z._addBounds(h[e],h[e+4],o[e+2],o[e],e,s?s[e]:0,u,l,c);t=h;h=o,o=t}for(var _=1,f=t.length;_<f;_++)d(t[_]);return e&&d(a),new b(u[0],u[1],l[0]-u[0],l[1]-u[1])},getStrokeBounds:function(t,e,n,i,r){var s=n.getStyle(),a=s.hasStroke(),o=s.getStrokeWidth(),h=a&&n._getStrokeMatrix(i,r),u=a&&W._getStrokePadding(o,h),l=W.getBounds(t,e,n,i,r,u);if(!a)return l;var c=o/2,d=s.getStrokeJoin(),o=s.getStrokeCap(),_=s.getMiterLimit(),f=new b(new k(u));function g(t){l=l.include(t)}function v(t){l=l.unite(f.setCenter(t._point.transform(i)))}function p(t,e){"round"===e||t.isSmooth()?v(t):W._addBevelJoin(t,e,c,_,i,h,g)}function m(t,e){"round"===e?v(t):W._addSquareCap(t,e,c,i,h,g)}var y=t.length-(e?0:1);if(0<y){for(var w=1;w<y;w++)p(t[w],d);e?p(t[0],d):(m(t[0],o),m(t[t.length-1],o))}return l},_getStrokePadding:function(t,e){if(!e)return[t,t];var n=new L(t,0).transform(e),i=new L(0,t).transform(e),r=n.getAngleInRadians(),s=n.getLength(),t=i.getLength(),e=Math.sin(r),n=Math.cos(r),i=Math.tan(r),r=Math.atan2(t*i,s),i=Math.atan2(t,i*s);return[Math.abs(s*Math.cos(r)*n+t*Math.sin(r)*e),Math.abs(t*Math.sin(i)*n+s*Math.cos(i)*e)]},_addBevelJoin:function(t,e,n,i,r,s,a,o){var h=t.getCurve(),t=h.getPrevious(),r=h.getPoint1().transform(r),t=t.getNormalAtTime(1).multiply(n).transform(s),h=h.getNormalAtTime(0).multiply(n).transform(s),s=t.getDirectedAngle(h);(s<0||180<=s)&&(t=t.negate(),h=h.negate()),o&&a(r),a(r.add(t)),"miter"!==e||(t=new N(r.add(t),new L(-t.y,t.x),!0).intersect(new N(r.add(h),new L(-h.y,h.x),!0),!0))&&r.getDistance(t)<=i*n&&a(t),a(r.add(h))},_addSquareCap:function(t,e,n,i,r,s,a){i=t._point.transform(i),t=t.getLocation(),r=t.getNormal().multiply(0===t.getTime()?n:-n).transform(r);"square"===e&&(a&&(s(i.subtract(r)),s(i.add(r))),i=i.add(r.rotate(-90))),s(i.add(r)),s(i.subtract(r))},getHandleBounds:function(t,e,n,i,r){var s,a,o,h=n.getStyle();r.stroke&&h.hasStroke()&&(o=n._getStrokeMatrix(i,r),r=n=h.getStrokeWidth()/2,"miter"===h.getStrokeJoin()&&(r=n*h.getMiterLimit()),"square"===h.getStrokeCap()&&(r=Math.max(r,n*Math.SQRT2)),s=W._getStrokePadding(n,o),a=W._getStrokePadding(r,o));for(var u=new Array(6),l=1/0,c=-l,d=l,_=c,f=0,g=t.length;f<g;f++){t[f]._transformCoordinates(i,u);for(var v=0;v<6;v+=2){var p=v?s:a,m=p?p[0]:0,y=p?p[1]:0,w=u[v],x=u[v+1],p=w-m,w=w+m,m=x-y,y=x+y;p<l&&(l=p),c<w&&(c=w),m<d&&(d=m),_<y&&(_=y)}}return new b(l,d,c-l,_-d)}}});W.inject({statics:new function(){var u=.5522847498307936,a=[new H([-1,0],[0,u],[0,-u]),new H([0,-1],[-u,0],[u,0]),new H([1,0],[0,-u],[0,u]),new H([0,1],[u,0],[-u,0])];function l(t,e,n){var i=D.getNamed(n),n=new W(i&&(1==i.insert?V.INSERT:0==i.insert?V.NO_INSERT:null));return n._add(t),n._closed=e,n.set(i,V.INSERT)}function i(t,e,n){for(var i=new Array(4),r=0;r<4;r++){var s=a[r];i[r]=new H(s._point.multiply(e).add(t),s._handleIn.multiply(e),s._handleOut.multiply(e))}return l(i,!0,n)}return{Line:function(){var t=arguments;return l([new H(L.readNamed(t,"from")),new H(L.readNamed(t,"to"))],!1,t)},Circle:function(){var t=arguments,e=L.readNamed(t,"center"),n=D.readNamed(t,"radius");return i(e,new k(n),t)},Rectangle:function(){var t,e,n=arguments,i=b.readNamed(n,"rectangle"),r=k.readNamed(n,"radius",0,{readNull:!0}),s=i.getBottomLeft(!0),a=i.getTopLeft(!0),o=i.getTopRight(!0),h=i.getBottomRight(!0);return l(!r||r.isZero()?[new H(s),new H(a),new H(o),new H(h)]:(t=(r=k.min(r,i.getSize(!0).divide(2))).width,e=r.height,i=t*u,r=e*u,[new H(s.add(t,0),null,[-i,0]),new H(s.subtract(0,e),[0,r]),new H(a.add(0,e),null,[0,-r]),new H(a.add(t,0),[-i,0],null),new H(o.subtract(t,0),null,[i,0]),new H(o.add(0,e),[0,-r],null),new H(h.subtract(0,e),null,[0,r]),new H(h.subtract(t,0),[i,0])]),!0,n)},RoundRectangle:"#Rectangle",Ellipse:function(){var t=arguments,e=f._readEllipse(t);return i(e.center,e.radius,t)},Oval:"#Ellipse",Arc:function(){var t=arguments,e=L.readNamed(t,"from"),n=L.readNamed(t,"through"),i=L.readNamed(t,"to"),r=D.getNamed(t),t=new W(r&&0==r.insert&&V.NO_INSERT);return t.moveTo(e),t.arcTo(n,i),t.set(r)},RegularPolygon:function(){for(var t=arguments,e=L.readNamed(t,"center"),n=D.readNamed(t,"sides"),i=D.readNamed(t,"radius"),r=360/n,s=n%3==0,a=new L(0,s?-i:i),o=s?-1:.5,h=new Array(n),u=0;u<n;u++)h[u]=new H(e.add(a.rotate((u+o)*r)));return l(h,!0,t)},Star:function(){for(var t=arguments,e=L.readNamed(t,"center"),n=2*D.readNamed(t,"points"),i=D.readNamed(t,"radius1"),r=D.readNamed(t,"radius2"),s=360/n,a=new L(0,-1),o=new Array(n),h=0;h<n;h++)o[h]=new H(e.add(a.rotate(s*h).multiply(h%2?r:i)));return l(o,!0,t)}}}});var G=m.extend({_class:"CompoundPath",_serializeFields:{children:[]},beans:!0,initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||("string"==typeof t?this.setPathData(t):this.addChildren(Array.isArray(t)?t:arguments))},insertChildren:function t(e,n){var i=n,r=i[0];r&&"number"==typeof r[0]&&(i=[i]);for(var s=n.length-1;0<=s;s--){var a=i[s];i!==n||a instanceof W||(i=D.slice(i)),Array.isArray(a)?i[s]=new W({segments:a,insert:!1}):a instanceof G&&(i.splice.apply(i,[s,1].concat(a.removeChildren())),a.remove())}return t.base.call(this,e,i)},reduce:function t(e){for(var n,i=this._children,r=i.length-1;0<=r;r--)(n=i[r].reduce(e)).isEmpty()&&n.remove();return i.length?t.base.call(this):((n=new W(V.NO_INSERT)).copyAttributes(this),n.insertAbove(this),this.remove(),n)},isClosed:function(){for(var t=this._children,e=0,n=t.length;e<n;e++)if(!t[e]._closed)return!1;return!0},setClosed:function(t){for(var e=this._children,n=0,i=e.length;n<i;n++)e[n].setClosed(t)},getFirstSegment:function(){var t=this.getFirstChild();return t&&t.getFirstSegment()},getLastSegment:function(){var t=this.getLastChild();return t&&t.getLastSegment()},getCurves:function(){for(var t=this._children,e=[],n=0,i=t.length;n<i;n++)D.push(e,t[n].getCurves());return e},getFirstCurve:function(){var t=this.getFirstChild();return t&&t.getFirstCurve()},getLastCurve:function(){var t=this.getLastChild();return t&&t.getLastCurve()},getArea:function(){for(var t=this._children,e=0,n=0,i=t.length;n<i;n++)e+=t[n].getArea();return e},getLength:function(){for(var t=this._children,e=0,n=0,i=t.length;n<i;n++)e+=t[n].getLength();return e},getPathData:function(t,e){for(var n=this._children,i=[],r=0,s=n.length;r<s;r++){var a=n[r],o=a._matrix;i.push(a.getPathData(t&&!o.isIdentity()?t.appended(o):t,e))}return i.join("")},_hitTestChildren:function t(e,n,i){return t.base.call(this,e,n.class===W||"path"===n.type?n:D.set({},n,{fill:!1}),i)},_draw:function(t,e,n,i){var r=this._children;if(r.length){e=e.extend({dontStart:!0,dontFinish:!0}),t.beginPath();for(var s=0,a=r.length;s<a;s++)r[s].draw(t,e,i);e.clip||(this._setStyles(t,e,n),(n=this._style).hasFill()&&(t.fill(n.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),n.hasStroke()&&t.stroke())}},_drawSelected:function(t,e,n){for(var i=this._children,r=0,s=i.length;r<s;r++){var a=i[r],o=a._matrix;n[a._id]||a._drawSelected(t,o.isIdentity()?e:e.appended(o))}}},new function(){function n(t,e){t=t._children;if(e&&!t.length)throw new Error("Use a moveTo() command first");return t[t.length-1]}return D.each(["lineTo","cubicCurveTo","quadraticCurveTo","curveTo","arcTo","lineBy","cubicCurveBy","quadraticCurveBy","curveBy","arcBy"],function(e){this[e]=function(){var t=n(this,!0);t[e].apply(t,arguments)}},{moveTo:function(){var t=n(this),e=t&&t.isEmpty()?t:new W(V.NO_INSERT);e!==t&&this.addChild(e),e.moveTo.apply(e,arguments)},moveBy:function(){var t=n(this,!0),e=t&&t.getLastSegment(),t=L.read(arguments);this.moveTo(e?t.add(e._point):t)},closePath:function(t){n(this,!0).closePath(t)}})},D.each(["reverse","flatten","simplify","smooth"],function(s){this[s]=function(t){for(var e,n=this._children,i=0,r=n.length;i<r;i++)e=n[i][s](t)||e;return e}},{}));m.inject(new function(){var A=Math.min,L=Math.max,N=Math.abs,S={unite:{1:!0,2:!0},intersect:{2:!0},subtract:{1:!0},exclude:{1:!0,"-1":!0}};function C(t){return t._children||[t]}function P(t,e){var n=t.clone(!1).reduce({simplify:!0}).transform(null,!0,!0);if(e){for(var i=C(n),r=0,s=i.length;r<s;r++)(t=i[r])._closed||t.isEmpty()||(t.closePath(1e-12),t.getFirstSegment().setHandleIn(0,0),t.getLastSegment().setHandleOut(0,0));n=n.resolveCrossings().reorient("nonzero"===n.getFillRule(),!0)}return n}function I(t,e,n,i,r){var s=new G(V.NO_INSERT);return s.addChildren(t,!0),s=s.reduce({simplify:e}),r&&0==r.insert||s.insertAbove(i&&n.isSibling(i)&&n.getIndex()<i.getIndex()?i:n),s.copyAttributes(n,!0),s}function M(t){return t.hasOverlap()||t.isCrossing()}function n(t,e,n,i){if(i&&(0==i.trace||i.stroke)&&/^(subtract|intersect)$/.test(n))return T(t,e,n);var r=P(t,!0),s=e&&t!==e&&P(e,!0),a=S[n];a[n]=!0,s&&(a.subtract||a.exclude)^(s.isClockwise()^r.isClockwise())&&s.reverse();var o,h=k(U.expand(r.getIntersections(s,M))),u=C(r),n=s&&C(s),l=[],c=[];function d(t){for(var e=0,n=t.length;e<n;e++){var i=t[e];D.push(l,i._segments),D.push(c,i.getCurves()),i._overlapsOnly=!0}}function _(t){for(var e=[],n=0,i=t&&t.length;n<i;n++)e.push(c[t[n]]);return e}if(h.length){d(u),n&&d(n);for(var f=new Array(c.length),g=0,v=c.length;g<v;g++)f[g]=c[g].getValues();for(var p=R.findCurveBoundsCollisions(f,f,0,!0),m={},g=0;g<c.length;g++){var y=c[g],w=y._path._id;(m[w]=m[w]||{})[y.getIndex()]={hor:_(p[g].hor),ver:_(p[g].ver)}}for(g=0,v=h.length;g<v;g++)E(h[g]._segment,r,s,m,a);for(g=0,v=l.length;g<v;g++){var x=l[g],b=x._intersection;x._winding||E(x,r,s,m,a),b&&b._overlap||(x._path._overlapsOnly=!1)}o=F(l,a)}else o=z(n?u.concat(n):u.slice(),function(t){return!!a[t]});return I(o,!0,t,e,i)}function T(t,e,n){var i=P(t),r=P(e),s=i.getIntersections(r,M),a="subtract"===n,o="divide"===n,h={},u=[];function l(t){return!h[t._id]&&(o||r.contains(t.getPointAt(t.getLength()/2))^a)&&(u.unshift(t),h[t._id]=!0)}for(var c=s.length-1;0<=c;c--){var d=s[c].split();d&&(l(d)&&d.getFirstSegment().setHandleIn(0,0),i.getLastSegment().setHandleOut(0,0))}return l(i),I(u,!1,t,e)}function b(t,e){for(var n=t;n;){if(n===e)return;n=n._previous}for(;t._next&&t._next!==e;)t=t._next;if(!t._next){for(;e._previous;)e=e._previous;(t._next=e)._previous=t}}function O(t){for(var e=t.length-1;0<=e;e--)t[e].clearHandles()}function z(t,e,n){var i=t&&t.length;if(i){var r=D.each(t,function(t,e){this[t._id]={container:null,winding:t.isClockwise()?1:-1,index:e}},{}),s=t.slice().sort(function(t,e){return N(e.getArea())-N(t.getArea())}),a=s[0],o=R.findItemBoundsCollisions(s,null,q.GEOMETRIC_EPSILON);null==n&&(n=a.isClockwise());for(var h=0;h<i;h++){var u,l=s[h],c=r[l._id],d=0,_=o[h];if(_)for(var f=null,g=_.length-1;0<=g;g--)if(_[g]<h){var f=f||l.getInteriorPoint(),v=s[_[g]];if(v.contains(f)){var p=r[v._id],d=p.winding;c.winding+=d,c.container=p.exclude?p.container:v;break}}e(c.winding)===e(d)?(c.exclude=!0,t[c.index]=null):(u=c.container,l.setClockwise(u?!u.isClockwise():n))}}return t}function k(t,e,n){var i,r,s,a=e&&[],o=!1,h=n||[],u=n&&{};function l(t){return t._path._id+"."+t._segment1._index}for(var c=(n&&n.length)-1;0<=c;c--)(d=n[c])._path&&(u[l(d)]=!0);for(c=t.length-1;0<=c;c--){var d,_=t[c],f=_._time,g=f,v=e&&!e(_);if((d=_._curve)&&(d!==r?(o=!d.hasHandles()||u&&u[l(d)],i=[],s=null,r=d):1e-8<=s&&(f/=s)),v)i&&i.push(_);else{if(e&&a.unshift(_),s=g,f<1e-8)p=d._segment1;else if(1-1e-8<f)p=d._segment2;else{g=d.divideAtTime(f,!0);o&&h.push(d,g);for(var p=g._segment1,m=i.length-1;0<=m;m--){var y=i[m];y._time=(y._time-f)/(1-f)}}_._setSegment(p);var w=p._intersection,_=_._intersection;if(w){b(w,_);for(var x=w;x;)b(x._intersection,w),x=x._next}else p._intersection=_}}return n||O(h),a||t}function B(u,l,c,d,_){var t,e=Array.isArray(l)?l:l[c?"hor":"ver"],f=c?1:0,g=1^f,n=[u.x,u.y],v=n[f],p=n[g],m=1e-6,y=v-1e-9,w=v+1e-9,i=0,r=0,x=0,b=0,S=!1,s=!1,C=1,P=[];function a(t){var e=t[g+0],n=t[g+2],i=t[g+4],r=t[g+6];if(p<=L(e,n,i,r)&&p>=A(e,n,i,r))for(var s,e=t[f+0],n=t[f+2],i=t[f+4],r=t[f+6],a=y>L(e,n,i,r)||w<A(e,n,i,r)?[t]:Z.getMonoCurves(t,c),o=0,h=a.length;o<h;o++)if(s=function(t){var e=t[g+0],n=t[g+6];if(!(p<A(e,n)||p>L(e,n))){var i=t[f+0],r=t[f+2],s=t[f+4],a=t[f+6];if(e!==n){var o=p===e?0:p!==n&&!(y>L(i,r,s,a)||w<A(i,r,s,a))&&0<Z.solveCubic(t,g,p,P,0,1)?P[0]:1,h=0===o?i:1===o?a:Z.getPoint(t,o)[c?"y":"x"],r=n<e?1:-1,s=O[g]>O[g+6]?1:-1,n=O[f+6];return p!==e?(h<y?x+=r:w<h?b+=r:S=!0,v-m<h&&h<v+m&&(C/=2)):(r!=s?i<y?x+=r:w<i&&(b+=r):i!=n&&(n<w&&w<h?(b+=r,S=!0):y<n&&h<y&&(x+=r,S=!0)),C/=4),O=t,!_&&y<h&&h<w&&0===Z.getTangent(t,o)[c?"x":"y"]&&B(u,l,!c,d,!0)}(i<w&&y<a||a<w&&y<i)&&(S=!0)}}(a[o]))return s}for(var o=0,h=e.length;o<h;o++){var I=e[o],M=I._path,T=I.getValues();if(!(o&&e[o-1]._path===M||(O=null,M._closed||(t=Z.getValues(M.getLastCurve().getSegment2(),I.getSegment1(),null,!d))[g]!==t[g+6]&&(O=t),O)))for(var O=T,z=M.getLastCurve();z&&z!==I;){var k=z.getValues();if(k[g]!==k[g+6]){O=k;break}z=z.getPrevious()}if(T=a(T))return T;if(o+1===h||e[o+1]._path!==M){if(t&&(T=a(t)))return T;i+=x=S&&!x&&!b?b=M.isClockwise(d)^c?1:-1:x,r+=b,x=b=0,S=S&&!(s=!0),t=null}}return i=N(i),r=N(r),{winding:L(i,r),windingL:i,windingR:r,quality:C,onPath:s}}function E(t,e,n,i,r){var s=[],a=t,o=0;do{}while((v=t.getCurve())&&(c=v.getLength(),s.push({segment:t,curve:v,length:c}),o+=c),(t=t.getNext())&&!t._intersection&&t!==a);for(var h=[.5,.25,.75],u={winding:0,quality:-1},l=0;l<h.length&&u.quality<.5;l++)for(var c=o*h[l],d=0,_=s.length;d<_;d++){var f=s[d],g=f.length;if(c<=g){var v,p=(v=f.curve)._path,m=p._parent,y=m instanceof G?m:p,w=q.clamp(v.getTimeAt(c),.001,.999),x=v.getPointAtTime(w),f=N(v.getTangentAtTime(w).y)<Math.SQRT1_2,m=null;if(r.subtract&&n){w=(y===e?n:e)._getWinding(x,f,!0);if(y===e&&w.winding||y===n&&!w.winding){if(w.quality<1)continue;m={winding:0,quality:1}}}(m=m||B(x,i[p._id][v.getIndex()],f,!0)).quality>u.quality&&(u=m);break}c-=g}for(d=s.length-1;0<=d;d--)s[d].segment._winding=u}function F(t,e){var h,n=[];function u(t){return!(!t||t._visited||e&&(!e[(t=t._winding||{}).winding]||e.unite&&2===t.winding&&t.windingL&&t.windingR))}function l(t){if(t)for(var e=0,n=h.length;e<n;e++)if(t===h[e])return!0;return!1}function i(t){for(var e=t._segments,n=0,i=e.length;n<i;n++)e[n]._visited=!0}t.sort(function(t,e){var n=t._intersection,i=e._intersection,r=!(!n||!n._overlap),s=!(!i||!i._overlap),a=t._path,o=e._path;return r^s?r?1:-1:!n^!i?n?1:-1:a!==o?a._id-o._id:t._index-e._index});for(var r=0,s=t.length;r<s;r++){var a,o,c,d,_,f=t[r],g=u(f),v=null,p=!1,m=!0,y=[];for(g&&f._path._overlapsOnly&&(d=f._path,_=f._intersection._segment._path,d.compare(_)&&(d.getArea()&&n.push(d.clone(!1)),i(d),i(_),g=!1));g;){var w=!v,x=function(s,a){var t=s._intersection,e=t,o=[];function n(t,e){for(;t&&t!==e;){var n,i=t._segment,r=i&&i._path;r&&(r=(n=i.getNext()||r.getFirstSegment())._intersection,i!==s&&(l(i)||l(n)||n&&u(i)&&(u(n)||r&&u(r._segment)))&&o.push(i),a&&h.push(i)),t=t._next}}if(a&&(h=[s]),t){for(n(t);t&&t._previous;)t=t._previous;n(t,e)}return o}(f,w),b=x.shift(),S=!(p=!w&&(l(f)||l(b)))&&b;if(w&&(v=new W(V.NO_INSERT),a=null),p){(f.isFirst()||f.isLast())&&(m=f._path._closed),f._visited=!0;break}if(S&&a&&(y.push(a),a=null),a||(S&&x.push(f),a={start:v._segments.length,crossings:x,visited:o=[],handleIn:c}),!u(f=S?b:f)){v.removeSegments(a.start);for(var C=0,P=o.length;C<P;C++)o[C]._visited=!1;for(o.length=0;(f=a&&a.crossings.shift())&&f._path||(f=null,(a=y.pop())&&(o=a.visited,c=a.handleIn)),a&&!u(f););if(!f)break}b=f.getNext();v.add(new H(f._point,c,b&&f._handleOut)),f._visited=!0,o.push(f),f=b||f._path.getFirstSegment(),c=b&&b._handleIn}p&&(m&&(v.getFirstSegment().setHandleIn(c),v.setClosed(m)),0!==v.getArea()&&n.push(v))}return n}return{_getWinding:function(t,e,n){return B(t,this.getCurves(),e,n)},unite:function(t,e){return n(this,t,"unite",e)},intersect:function(t,e){return n(this,t,"intersect",e)},subtract:function(t,e){return n(this,t,"subtract",e)},exclude:function(t,e){return n(this,t,"exclude",e)},divide:function(t,e){return e&&(0==e.trace||e.stroke)?T(this,t,"divide"):I([this.subtract(t,e),this.intersect(t,e)],!0,this,t,e)},resolveCrossings:function(){var t=this._children,e=t||[this];function n(t,e){t=t&&t._intersection;return t&&t._overlap&&t._path===e}var i=!1,r=!1,s=this.getIntersections(null,function(t){return t.hasOverlap()?i=!0:t.isCrossing()&&(r=!0)}),a=i&&r&&[],s=U.expand(s);if(i)for(var o=k(s,function(t){return t.hasOverlap()},a),h=o.length-1;0<=h;h--){var u=o[h],l=u._path,c=u._segment,d=c.getPrevious(),u=c.getNext();n(d,l)&&n(u,l)&&(c.remove(),d._handleOut._set(0,0),u._handleIn._set(0,0),d===c||d.getCurve().hasLength()||(u._handleIn.set(d._handleIn),d.remove()))}r&&(k(s,i&&function(t){var e=t.getCurve(),n=t.getSegment(),i=t._intersection,t=i._curve,i=i._segment;if(e&&t&&e._path&&t._path)return!0;n&&(n._intersection=null),i&&(i._intersection=null)},a),a&&O(a),e=F(D.each(e,function(t){D.push(this,t._segments)},[])));var _,a=e.length;return 1<a&&t?(e!==t&&this.setChildren(e),_=this):1!==a||t||(e[0]!==this&&this.setSegments(e[0].removeSegments()),_=this),_||((_=new G(V.NO_INSERT)).addChildren(e),(_=_.reduce()).copyAttributes(this),this.replaceWith(_)),_},reorient:function(e,t){var n=this._children;return n&&n.length?this.setChildren(z(this.removeChildren(),function(t){return!!(e?t:1&t)},t)):t!==j&&this.setClockwise(t),this},getInteriorPoint:function(){var t=this.getBounds().getCenter(!0);if(!this.contains(t)){for(var e=this.getCurves(),n=t.y,i=[],r=[],s=0,a=e.length;s<a;s++){var o=e[s].getValues(),h=o[1],u=o[3],l=o[5],c=o[7];if(n>=A(h,u,l,c)&&n<=L(h,u,l,c))for(var d=Z.getMonoCurves(o),_=0,f=d.length;_<f;_++){var g=d[_],v=g[1],p=g[7];v!==p&&(v<=n&&n<=p||p<=n&&n<=v)&&(g=n===v?g[0]:n===p?g[6]:1===Z.solveCubic(g,1,n,r,0,1)?Z.getPoint(g,r[0]).x:(g[0]+g[6])/2,i.push(g))}}1<i.length&&(i.sort(function(t,e){return t-e}),t.x=(i[0]+i[1])/2)}return t}}});var y=D.extend({_class:"PathFlattener",initialize:function(t,o,e,h,n){var i,r=[],u=[],l=0,c=1/(e||32),s=t._segments,a=s[0];function d(t,e){e=Z.getValues(t,e,n);r.push(e),function t(e,n,i,r){{var s,a;!(c<r-i)||h&&Z.isStraight(e)||Z.isFlatEnough(e,o||.25)?(s=e[6]-e[0],a=e[7]-e[1],0<(a=Math.sqrt(s*s+a*a))&&(l+=a,u.push({offset:l,curve:e,index:n,time:r}))):(a=Z.subdivide(e,.5),e=(i+r)/2,t(a[0],n,i,e),t(a[1],n,e,r))}}(e,t._index,0,1)}for(var _=1,f=s.length;_<f;_++)d(a,i=s[_]),a=i;t._closed&&d(i||a,s[0]),this.curves=r,this.parts=u,this.length=l,this.index=0},_get:function(t){for(var e,n=this.parts,i=n.length,r=this.index;(e=r)&&!(n[--r].offset<t););for(;e<i;e++){var s=n[e];if(s.offset>=t){var a=n[(this.index=e)-1],o=a&&a.index===s.index?a.time:0,a=a?a.offset:0;return{index:s.index,time:o+(s.time-o)*(t-a)/(s.offset-a)}}}return{index:n[i-1].index,time:1}},drawPart:function(t,e,n){for(var i=this._get(e),r=this._get(n),s=i.index,a=r.index;s<=a;s++){var o=Z.getPart(this.curves[s],s===i.index?i.time:0,s===r.index?r.time:1);s===i.index&&t.moveTo(o[0],o[1]),t.bezierCurveTo.apply(t,o.slice(2))}}},D.each(Z._evaluateMethods,function(e){this[e+"At"]=function(t){t=this._get(t);return Z[e](this.curves[t.index],t.time)}},{})),h=D.extend({initialize:function(t){for(var e,n=this.points=[],i=t._segments,t=t._closed,r=0,s=i.length;r<s;r++){var a=i[r].point;e&&e.equals(a)||n.push(e=a.clone())}t&&(n.unshift(n[n.length-1]),n.push(n[1])),this.closed=t},fit:function(t){var e=this.points,n=e.length,i=null;return 0<n&&(i=[new H(e[0])],1<n&&(this.fitCubic(i,t,0,n-1,e[1].subtract(e[0]),e[n-2].subtract(e[n-1])),this.closed&&(i.shift(),i.pop()))),i},fitCubic:function(t,e,n,i,r,s){var a=this.points;if(i-n!=1){for(var o,h=this.chordLengthParameterize(n,i),u=Math.max(e,e*e),l=!0,c=0;c<=4;c++){var d=this.generateBezier(n,i,h,r,s),_=this.findMaxError(n,i,d,h);if(_.error<e&&l)return void this.addCurve(t,d);if(o=_.index,_.error>=u)break;l=this.reparameterize(n,i,h,d),u=_.error}var f=a[o-1].subtract(a[o+1]);this.fitCubic(t,e,n,o,r,f),this.fitCubic(t,e,o,i,f.negate(),s)}else{var g=a[n],f=a[i],a=g.getDistance(f)/3;this.addCurve(t,[g,g.add(r.normalize(a)),f.add(s.normalize(a)),f])}},addCurve:function(t,e){t[t.length-1].setHandleOut(e[1].subtract(e[0])),t.push(new H(e[3],e[2].subtract(e[3])))},generateBezier:function(t,e,n,i,r){for(var s=Math.abs,a=this.points,o=a[t],h=a[e],u=[[0,0],[0,0]],l=[0,0],c=0,d=e-t+1;c<d;c++){var _=n[c],f=1-_,g=3*_*f,v=f*f*f,p=g*f,m=g*_,f=_*_*_,g=i.normalize(p),_=r.normalize(m),f=a[t+c].subtract(o.multiply(v+p)).subtract(h.multiply(m+f));u[0][0]+=g.dot(g),u[0][1]+=g.dot(_),u[1][0]=u[0][1],u[1][1]+=_.dot(_),l[0]+=g.dot(f),l[1]+=_.dot(f)}var y,w,e=u[0][0]*u[1][1]-u[1][0]*u[0][1];1e-12<s(e)?(w=u[0][0]*l[1]-u[1][0]*l[0],y=(l[0]*u[1][1]-l[1]*u[0][1])/e,w=w/e):(e=u[0][0]+u[0][1],S=u[1][0]+u[1][1],y=w=1e-12<s(e)?l[0]/e:1e-12<s(S)?l[1]/S:0);var x,b,s=h.getDistance(o),S=1e-12*s;return y<S||w<S?y=w=s/3:(S=h.subtract(o),x=i.normalize(y),b=r.normalize(w),x.dot(S)-b.dot(S)>s*s&&(y=w=s/3,x=b=null)),[o,o.add(x||i.normalize(y)),h.add(b||r.normalize(w)),h]},reparameterize:function(t,e,n,i){for(var r=t;r<=e;r++)n[r-t]=this.findRoot(i,this.points[r],n[r-t]);for(var r=1,s=n.length;r<s;r++)if(n[r]<=n[r-1])return!1;return!0},findRoot:function(t,e,n){for(var i=[],r=[],s=0;s<=2;s++)i[s]=t[s+1].subtract(t[s]).multiply(3);for(s=0;s<=1;s++)r[s]=i[s+1].subtract(i[s]).multiply(2);var a=this.evaluate(3,t,n),o=this.evaluate(2,i,n),h=this.evaluate(1,r,n),e=a.subtract(e),h=o.dot(o)+e.dot(h);return q.isMachineZero(h)?n:n-e.dot(o)/h},evaluate:function(t,e,n){for(var i=e.slice(),r=1;r<=t;r++)for(var s=0;s<=t-r;s++)i[s]=i[s].multiply(1-n).add(i[s+1].multiply(n));return i[0]},chordLengthParameterize:function(t,e){for(var n=[0],i=t+1;i<=e;i++)n[i-t]=n[i-t-1]+this.points[i].getDistance(this.points[i-1]);for(var i=1,r=e-t;i<=r;i++)n[i]/=n[r];return n},findMaxError:function(t,e,n,i){for(var r=Math.floor((e-t+1)/2),s=0,a=t+1;a<e;a++){var o=this.evaluate(3,n,i[a-t]).subtract(this.points[a]),o=o.x*o.x+o.y*o.y;s<=o&&(s=o,r=a)}return{error:s,index:r}}}),w=V.extend({_class:"TextItem",_applyMatrix:!1,_canApplyMatrix:!1,_serializeFields:{content:null},_boundsOptions:{stroke:!1,handle:!1},initialize:function(t){this._content="",this._lines=[];var e=t&&D.isPlainObject(t)&&t.x===j&&t.y===j;this._initialize(e&&t,!e&&L.read(arguments))},_equals:function(t){return this._content===t._content},copyContent:function(t){this.setContent(t._content)},getContent:function(){return this._content},setContent:function(t){this._content=""+t,this._lines=this._content.split(/\r\n|\n|\r/gm),this._changed(521)},isEmpty:function(){return!this._content},getCharacterStyle:"#getStyle",setCharacterStyle:"#setStyle",getParagraphStyle:"#getStyle",setParagraphStyle:"#setStyle"}),S=w.extend({_class:"PointText",initialize:function(){w.apply(this,arguments)},getPoint:function(){var t=this._matrix.getTranslation();return new c(t.x,t.y,this,"setPoint")},setPoint:function(){var t=L.read(arguments);this.translate(t.subtract(this._matrix.getTranslation()))},_draw:function(t,e,n){if(this._content){this._setStyles(t,e,n);var i=this._lines,n=this._style,r=n.hasFill(),s=n.hasStroke(),a=n.getLeading(),o=t.shadowColor;t.font=n.getFontStyle(),t.textAlign=n.getJustification();for(var h=0,u=i.length;h<u;h++){t.shadowColor=o;var l=i[h];r&&(t.fillText(l,0,0),t.shadowColor="rgba(0,0,0,0)"),s&&t.strokeText(l,0,0),t.translate(0,a)}}},_getBounds:function(t,e){var n=this._style,i=this._lines,r=i.length,s=n.getJustification(),a=n.getLeading(),n=this.getView().getTextWidth(n.getFontStyle(),i),i=0;"left"!==s&&(i-=n/("center"===s?2:1));a=new b(i,r?-.75*a:0,n,r*a);return t?t._transformBounds(a,a):a}}),C=D.extend(new function(){var p,m={gray:["gray"],rgb:["red","green","blue"],hsb:["hue","saturation","brightness"],hsl:["hue","saturation","lightness"],gradient:["gradient","origin","destination","highlight"]},y={},w={transparent:[0,0,0,0]};var r=[[0,3,1],[2,0,1],[1,0,3],[1,2,0],[3,1,0],[0,1,2]],n={"rgb-hsb":function(t,e,n){var i=Math.max(t,e,n),r=i-Math.min(t,e,n);return[0==r?0:60*(i==t?(e-n)/r+(e<n?6:0):i==e?(n-t)/r+2:(t-e)/r+4),0===i?0:r/i,i]},"hsb-rgb":function(t,e,n){t=(t/60%6+6)%6;var i=Math.floor(t),t=t-i,t=[n,n*(1-e),n*(1-e*t),n*(1-e*(1-t))];return[t[(i=r[i])[0]],t[i[1]],t[i[2]]]},"rgb-hsl":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0==s,o=(i+r)/2;return[a?0:60*(i==t?(e-n)/s+(e<n?6:0):i==e?(n-t)/s+2:(t-e)/s+4),a?0:o<.5?s/(i+r):s/(2-i-r),o]},"hsl-rgb":function(t,e,n){if(0===e)return[n,n,n];for(var i=[(t=(t/360%1+1)%1)+1/3,t,t-1/3],r=n<.5?n*(1+e):n+e-n*e,s=2*n-r,a=[],o=0;o<3;o++){var h=i[o];h<0&&(h+=1),1<h&&--h,a[o]=6*h<1?s+6*(r-s)*h:2*h<1?r:3*h<2?s+(r-s)*(2/3-h)*6:s}return a},"rgb-gray":function(t,e,n){return[.2989*t+.587*e+.114*n]},"gray-rgb":function(t){return[t,t,t]},"gray-hsb":function(t){return[0,0,t]},"gray-hsl":function(t){return[0,0,t]},"gradient-rgb":function(){return[]},"rgb-gradient":function(){return[]}};return D.each(m,function(t,s){y[s]=[],D.each(t,function(t,e){var n=D.capitalize(t),i=/^(hue|saturation)$/.test(t),r=y[s][e]="gradient"===s?"gradient"===t?function(t){var e=this._components[0];return e!==(t=P.read(Array.isArray(t)?t:arguments,0,{readNull:!0}))&&(e&&e._removeOwner(this),t&&t._addOwner(this)),t}:function(){return L.read(arguments,0,{readNull:"highlight"===t,clone:!0})}:function(t){return null==t||isNaN(t)?0:+t};this["get"+n]=function(){return(this._type===s||i&&/^hs[bl]$/.test(this._type)?this._components:this._convert(s))[e]},this["set"+n]=function(t){this._type===s||i&&/^hs[bl]$/.test(this._type)||(this._components=this._convert(s),this._properties=m[s],this._type=s),this._components[e]=r.call(this,t),this._changed()}},this)},{_class:"Color",_readIndex:!0,initialize:function t(e){var n,i,r=arguments,s=this.__read,a=0,o=null!=(e=Array.isArray(e)?(r=e)[0]:e)&&typeof e;if("string"===o&&e in m&&(h=e,e=r[1],Array.isArray(e)?(n=e,l=r[2]):(s&&(a=1),r=D.slice(r,1),o=typeof e)),!n){if(i="number"===o?r:"object"===o&&null!=e.length?e:null){var h=h||(3<=i.length?"rgb":"gray"),u=m[h].length,l=i[u];s&&(a+=i===arguments?u+(null!=l?1:0):1),i.length>u&&(i=D.slice(i,0,u))}else if("string"===o){u=function(t){var e=t.match(/^#([\da-f]{2})([\da-f]{2})([\da-f]{2})([\da-f]{2})?$/i)||t.match(/^#([\da-f])([\da-f])([\da-f])([\da-f])?$/i),n="rgb";if(e)for(var i=e[4]?4:3,r=new Array(i),s=0;s<i;s++){var a=e[s+1];r[s]=parseInt(1==a.length?a+a:a,16)/255}else if(e=t.match(/^(rgb|hsl)a?\((.*)\)$/)){n=e[1],r=e[2].trim().split(/[,\s]+/g);for(var o="hsl"===n,s=0,h=Math.min(r.length,4);s<h;s++){var u,l=r[s],a=parseFloat(l);o?0===s?(u=l.match(/([a-z]*)$/)[1],a*={turn:360,rad:180/Math.PI,grad:.9}[u]||1):s<3&&(a/=100):s<3&&(a/=/%$/.test(l)?100:255),r[s]=a}}else{var c,d=w[t];r=(d=d||(T?(p||((p=ht.getContext(1,1,{willReadFrequently:!0})).globalCompositeOperation="copy"),p.fillStyle="rgba(0,0,0,0)",p.fillStyle=t,p.fillRect(0,0,1,1),c=p.getImageData(0,0,1,1).data,w[t]=[c[0]/255,c[1]/255,c[2]/255]):[0,0,0])).slice()}return[n,r]}(e);h=u[0],4===(n=u[1]).length&&(l=n[3],n.length--)}else if("object"===o)if(e.constructor===t){if(h=e._type,n=e._components.slice(),l=e._alpha,"gradient"===h)for(var c=1,d=n.length;c<d;c++){var _=n[c];_&&(n[c]=_.clone())}}else if(e.constructor===P)h="gradient",i=r;else{h="hue"in e?"lightness"in e?"hsl":"hsb":"gradient"in e||"stops"in e||"radial"in e?"gradient":"gray"in e?"gray":"rgb";var f=m[h],g=y[h];this._components=n=[];for(c=0,d=f.length;c<d;c++)null==(v=e[f[c]])&&!c&&"gradient"===h&&"stops"in e&&(v={stops:e.stops,radial:e.radial}),null!=(v=g[c].call(this,v))&&(n[c]=v);l=e.alpha}s&&h&&(a=1)}if(this._type=h||"rgb",!n){this._components=n=[];for(var v,c=0,d=(g=y[this._type]).length;c<d;c++)null!=(v=g[c].call(this,i&&i[c]))&&(n[c]=v)}return this._components=n,this._properties=m[this._type],this._alpha=l,s&&(this.__read=a),this},set:"#initialize",_serialize:function(t,e){var n=this.getComponents();return D.serialize(/^(gray|rgb)$/.test(this._type)?n:[this._type].concat(n),t,!0,e)},_changed:function(){this._canvasStyle=null,this._owner&&(this._setter?this._owner[this._setter](this):this._owner._changed(129))},_convert:function(t){var e;return this._type===t?this._components.slice():(e=n[this._type+"-"+t])?e.apply(this,this._components):n["rgb-"+t].apply(this,n[this._type+"-rgb"].apply(this,this._components))},convert:function(t){return new C(t,this._convert(t),this._alpha)},getType:function(){return this._type},setType:function(t){this._components=this._convert(t),this._properties=m[t],this._type=t},getComponents:function(){var t=this._components.slice();return null!=this._alpha&&t.push(this._alpha),t},getAlpha:function(){return null!=this._alpha?this._alpha:1},setAlpha:function(t){this._alpha=null==t?null:Math.min(Math.max(t,0),1),this._changed()},hasAlpha:function(){return null!=this._alpha},equals:function(t){var e=D.isPlainValue(t,!0)?C.read(arguments):t;return e===this||e&&this._class===e._class&&this._type===e._type&&this.getAlpha()===e.getAlpha()&&D.equals(this._components,e._components)||!1},toString:function(){for(var t=this._properties,e=[],n="gradient"===this._type,i=x.instance,r=0,s=t.length;r<s;r++){var a=this._components[r];null!=a&&e.push(t[r]+": "+(n?a:i.number(a)))}return null!=this._alpha&&e.push("alpha: "+i.number(this._alpha)),"{ "+e.join(", ")+" }"},toCSS:function(t){var e=this._convert("rgb"),n=t||null==this._alpha?1:this._alpha;function i(t){return Math.round(255*(t<0?0:1<t?1:t))}return e=[i(e[0]),i(e[1]),i(e[2])],n<1&&e.push(n<0?0:n),t?"#"+((1<<24)+(e[0]<<16)+(e[1]<<8)+e[2]).toString(16).slice(1):(4==e.length?"rgba(":"rgb(")+e.join(",")+")"},toCanvasStyle:function(t,e){if(this._canvasStyle)return this._canvasStyle;if("gradient"!==this._type)return this._canvasStyle=this.toCSS();var n,i=this._components,r=i[0],s=r._stops,a=i[1],o=i[2],i=i[3],e=e&&e.inverted();e&&(a=e._transformPoint(a),o=e._transformPoint(o),i=i&&e._transformPoint(i)),n=r._radial?(e=o.getDistance(a),!i||(r=i.subtract(a)).getLength()>e&&(i=a.add(r.normalize(e-.1))),t.createRadialGradient((i=i||a).x,i.y,0,a.x,a.y,e)):t.createLinearGradient(a.x,a.y,o.x,o.y);for(var h=0,u=s.length;h<u;h++){var l=s[h],c=l._offset;n.addColorStop(null==c?h/(u-1):c,l._color.toCanvasStyle())}return this._canvasStyle=n},transform:function(t){if("gradient"===this._type){for(var e=this._components,n=1,i=e.length;n<i;n++){var r=e[n];t._transformPoint(r,r,!0)}this._changed()}},statics:{_types:m,random:function(){var t=Math.random;return new C(t(),t(),t())},_setOwner:function(t,e,n){return t&&!(t=t._owner&&e&&t._owner!==e?t.clone():t)._owner^!e&&(t._owner=e||null,t._setter=n||null),t}}})},new function(){return D.each({add:function(t,e){return t+e},subtract:function(t,e){return t-e},multiply:function(t,e){return t*e},divide:function(t,e){return t/e}},function(a,t){this[t]=function(t){t=C.read(arguments);for(var e=this._type,n=this._components,i=t._convert(e),r=0,s=n.length;r<s;r++)i[r]=a(n[r],i[r]);return new C(e,i,null!=this._alpha?a(this._alpha,t.getAlpha()):null)}},{})}),P=D.extend({_class:"Gradient",initialize:function(t,e){this._id=o.get(),t&&D.isPlainObject(t)&&(this.set(t),t=e=null),null==this._stops&&this.setStops(t||["white","black"]),null==this._radial&&this.setRadial("string"==typeof e&&"radial"===e||e||!1)},_serialize:function(t,e){return e.add(this,function(){return D.serialize([this._stops,this._radial],t,!0,e)})},_changed:function(){for(var t=0,e=this._owners&&this._owners.length;t<e;t++)this._owners[t]._changed()},_addOwner:function(t){this._owners||(this._owners=[]),this._owners.push(t)},_removeOwner:function(t){t=this._owners?this._owners.indexOf(t):-1;-1!=t&&(this._owners.splice(t,1),this._owners.length||(this._owners=j))},clone:function(){for(var t=[],e=0,n=this._stops.length;e<n;e++)t[e]=this._stops[e].clone();return new P(t,this._radial)},getStops:function(){return this._stops},setStops:function(t){if(t.length<2)throw new Error("Gradient stop list needs to contain at least two stops.");var e=this._stops;if(e)for(var n=0,i=e.length;n<i;n++)e[n]._owner=j;for(n=0,i=(e=this._stops=I.readList(t,0,{clone:!0})).length;n<i;n++)e[n]._owner=this;this._changed()},getRadial:function(){return this._radial},setRadial:function(t){this._radial=t,this._changed()},equals:function(t){if(t===this)return!0;if(t&&this._class===t._class){var e=this._stops,n=t._stops,i=e.length;if(i===n.length){for(var r=0;r<i;r++)if(!e[r].equals(n[r]))return!1;return!0}}return!1}}),I=D.extend({_class:"GradientStop",initialize:function(t,e){var n=t,i=e;"object"==typeof t&&e===j&&(Array.isArray(t)&&"number"!=typeof t[0]?(n=t[0],i=t[1]):("color"in t||"offset"in t||"rampPoint"in t)&&(n=t.color,i=t.offset||t.rampPoint||0)),this.setColor(n),this.setOffset(i)},clone:function(){return new I(this._color.clone(),this._offset)},_serialize:function(t,e){var n=this._color,i=this._offset;return D.serialize(null==i?[n]:[n,i],t,!0,e)},_changed:function(){this._owner&&this._owner._changed(129)},getOffset:function(){return this._offset},setOffset:function(t){this._offset=t,this._changed()},getRampPoint:"#getOffset",setRampPoint:"#setOffset",getColor:function(){return this._color},setColor:function(){C._setOwner(this._color,null),this._color=C._setOwner(C.read(arguments,0),this,"setColor"),this._changed()},equals:function(t){return t===this||t&&this._class===t._class&&this._color.equals(t._color)&&this._offset==t._offset||!1}}),M=D.extend(new function(){var i={fillColor:null,fillRule:"nonzero",strokeColor:null,strokeWidth:1,strokeCap:"butt",strokeJoin:"miter",strokeScaling:!0,miterLimit:10,dashOffset:0,dashArray:[],shadowColor:null,shadowBlur:0,shadowOffset:new L,selectedColor:null},r=D.set({},i,{fontFamily:"sans-serif",fontWeight:"normal",fontSize:12,leading:null,justification:"left"}),s=D.set({},r,{fillColor:new C}),n={strokeWidth:193,strokeCap:193,strokeJoin:193,strokeScaling:201,miterLimit:193,fontFamily:9,fontWeight:9,fontSize:9,font:9,leading:9,justification:9},a={beans:!0},_={_class:"Style",beans:!0,initialize:function(t,e,n){this._values={},this._owner=e,this._project=e&&e._project||n||Bt.project,this._defaults=!e||e instanceof g?r:e instanceof w?s:i,t&&this.set(t)}};return D.each(r,function(t,h){var u=/Color$/.test(h),l="shadowOffset"===h,e=D.capitalize(h),o=n[h],c="set"+e,d="get"+e;_[c]=function(t){var e,n=this._owner,i=n&&n._children,r=i&&0<i.length&&!(n instanceof G);if(r)for(var s=0,a=i.length;s<a;s++)i[s]._style[c](t);"selectedColor"!==h&&r||!(h in this._defaults)||(e=this._values[h])!==t&&(u&&(e&&(C._setOwner(e,null),e._canvasStyle=null),t&&t.constructor===C&&(t=C._setOwner(t,n,r&&c))),this._values[h]=t,n&&n._changed(o||129))},_[d]=function(t){var e,n=this._owner,i=n&&n._children,r=i&&0<i.length&&!(n instanceof G);if(r&&!t)for(var s=0,a=i.length;s<a;s++){var o=i[s]._style[d]();if(s){if(!D.equals(e,o))return j}else e=o}else h in this._defaults&&((e=this._values[h])===j?(e=this._defaults[h])&&e.clone&&(e=e.clone()):!(t=u?C:l?L:null)||e&&e.constructor===t||(this._values[h]=e=t.read([e],0,{readNull:!0,clone:!0})));return e=e&&u?C._setOwner(e,n,r&&c):e},a[d]=function(t){return this._style[d](t)},a[c]=function(t){this._style[c](t)}}),D.each({Font:"FontFamily",WindingRule:"FillRule"},function(t,e){var n="get"+e,e="set"+e;_[n]=a[n]="#get"+t,_[e]=a[e]="#set"+t}),V.inject(a),_},{set:function(t){var e,n=t instanceof M,i=n?t._values:t;if(i)for(var r in i)r in this._defaults&&(e=i[r],this[r]=e&&n&&e.clone?e.clone():e)},equals:function(t){function e(t,e,n){var i,r=t._values,s=e._values,a=e._defaults;for(i in r){var o=r[i],h=s[i];if(!(n&&i in s||D.equals(o,h===j?a[i]:h)))return!1}return!0}return t===this||t&&this._class===t._class&&e(this,t)&&e(t,this,!0)||!1},_dispose:function(){var t=this.getFillColor();t&&(t._canvasStyle=null),(t=this.getStrokeColor())&&(t._canvasStyle=null),(t=this.getShadowColor())&&(t._canvasStyle=null)},hasFill:function(){var t=this.getFillColor();return!!t&&0<t.alpha},hasStroke:function(){var t=this.getStrokeColor();return!!t&&0<t.alpha&&0<this.getStrokeWidth()},hasShadow:function(){var t=this.getShadowColor();return!!t&&0<t.alpha&&(0<this.getShadowBlur()||!this.getShadowOffset().isZero())},getView:function(){return this._project._view},getFontStyle:function(){var t=this.getFontSize();return this.getFontWeight()+" "+t+(/[a-z]/i.test(t+"")?" ":"px ")+this.getFontFamily()},getFont:"#getFontFamily",setFont:"#setFontFamily",getLeading:function t(){var e=t.base.call(this),n=this.getFontSize();return/pt|em|%|px/.test(n)&&(n=this.getView().getPixelSize(n)),null!=e?e:1.2*n}}),z=new function(){function r(t,e,n,i){for(var r=["","webkit","moz","Moz","ms","o"],s=e[0].toUpperCase()+e.substring(1),a=0;a<6;a++){var o=r[a],o=o?o+s:e;if(o in t){if(!n)return t[o];t[o]=i;break}}}return{getStyles:function(t){var e=t&&9!==t.nodeType?t.ownerDocument:t,e=e&&e.defaultView;return e&&e.getComputedStyle(t,"")},getBounds:function(t,e){var n,i=t.ownerDocument,r=i.body,s=i.documentElement;try{n=t.getBoundingClientRect()}catch(t){n={left:0,top:0,width:0,height:0}}var a=n.left-(s.clientLeft||r.clientLeft||0),t=n.top-(s.clientTop||r.clientTop||0);return e||(a+=(i=i.defaultView).pageXOffset||s.scrollLeft||r.scrollLeft,t+=i.pageYOffset||s.scrollTop||r.scrollTop),new b(a,t,n.width,n.height)},getViewportBounds:function(t){var e=t.ownerDocument,t=e.defaultView,e=e.documentElement;return new b(0,0,t.innerWidth||e.clientWidth,t.innerHeight||e.clientHeight)},getOffset:function(t,e){return z.getBounds(t,e).getPoint()},getSize:function(t){return z.getBounds(t,!0).getSize()},isInvisible:function(t){return z.getSize(t).equals(new k(0,0))},isInView:function(t){return!z.isInvisible(t)&&z.getViewportBounds(t).intersects(z.getBounds(t,!0))},isInserted:function(t){return _.body.contains(t)},getPrefixed:function(t,e){return t&&r(t,e)},setPrefixed:function(t,e,n){if("object"==typeof e)for(var i in e)r(t,i,!0,e[i]);else r(t,e,!0,n)}}},B={add:function(t,e){if(t)for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;s<a;s++){var o=r[s];t.addEventListener(o,i,t===_&&("touchstart"===o||"touchmove"===o)&&{passive:!1})}},remove:function(t,e){if(t)for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;s<a;s++)t.removeEventListener(r[s],i,!1)},getPoint:function(t){t=t.targetTouches?(t.targetTouches.length?t.targetTouches:t.changedTouches)[0]:t;return new L(t.pageX||t.clientX+_.documentElement.scrollLeft,t.pageY||t.clientY+_.documentElement.scrollTop)},getTarget:function(t){return t.target||t.srcElement},getRelatedTarget:function(t){return t.relatedTarget||t.toElement},getOffset:function(t,e){return B.getPoint(t).subtract(z.getOffset(e||B.getTarget(t)))}};B.requestAnimationFrame=new function(){var e,i=z.getPrefixed(T,"requestAnimationFrame"),r=!1,s=[];function a(){var t=s;s=[];for(var e=0,n=t.length;e<n;e++)t[e]();(r=i&&s.length)&&i(a)}return function(t){s.push(t),i?r||(i(a),r=!0):e=e||setInterval(a,1e3/60)}};var E,F,$,J,K,Q,X,Y=D.extend(t,{_class:"View",initialize:function t(e,n){function i(t){return n[t]||parseInt(n.getAttribute(t),10)}function r(){var t=z.getSize(n);return t.isNaN()||t.isZero()?new k(i("width"),i("height")):t}var s,a,o,h,u;T&&n?(this._id=n.getAttribute("id"),null==this._id&&n.setAttribute("id",this._id="paper-view-"+t._id++),B.add(n,this._viewEvents),z.setPrefixed(n.style,{userDrag:u="none",userSelect:u,touchCallout:u,contentZooming:u,tapHighlightColor:"rgba(0,0,0,0)"}),l.hasAttribute(n,"resize")&&B.add(T,(a=this)._windowEvents={resize:function(){a.setViewSize(r())}}),s=r(),l.hasAttribute(n,"stats")&&"undefined"!=typeof Stats&&(this._stats=new Stats,h=(o=this._stats.domElement).style,u=z.getOffset(n),h.position="absolute",h.left=u.x+"px",h.top=u.y+"px",_.body.appendChild(o))):(s=new k(n),n=null),this._project=e,this._scope=e._scope,this._element=n,this._pixelRatio||(this._pixelRatio=T&&T.devicePixelRatio||1),this._setElementSize(s.width,s.height),this._viewSize=s,t._views.push(this),((t._viewsById[this._id]=this)._matrix=new A)._owner=this,t._focused||(t._focused=this),this._frameItems={},this._frameItemCount=0,this._itemEvents={native:{},virtual:{}},this._autoUpdate=!Bt.agent.node,this._needsUpdate=!1},remove:function(){if(!this._project)return!1;Y._focused===this&&(Y._focused=null),Y._views.splice(Y._views.indexOf(this),1),delete Y._viewsById[this._id];var t=this._project;return t._view===this&&(t._view=null),B.remove(this._element,this._viewEvents),B.remove(T,this._windowEvents),this._element=this._project=null,this.off("frame"),this._animate=!1,this._frameItems={},!0},_events:D.each(V._itemHandlers.concat(["onResize","onKeyDown","onKeyUp"]),function(t){this[t]={}},{onFrame:{install:function(){this.play()},uninstall:function(){this.pause()}}}),_animate:!1,_time:0,_count:0,getAutoUpdate:function(){return this._autoUpdate},setAutoUpdate:function(t){(this._autoUpdate=t)&&this.requestUpdate()},update:function(){},draw:function(){this.update()},requestUpdate:function(){var e;this._requested||(e=this,B.requestAnimationFrame(function(){var t;e._requested=!1,e._animate&&(e.requestUpdate(),t=e._element,z.getPrefixed(_,"hidden")&&"true"!==l.getAttribute(t,"keepalive")||!z.isInView(t)||e._handleFrame()),e._autoUpdate&&e.update()}),this._requested=!0)},play:function(){this._animate=!0,this.requestUpdate()},pause:function(){this._animate=!1},_handleFrame:function(){Bt=this._scope;var t=Date.now()/1e3,e=this._last?t-this._last:0;this._last=t,this.emit("frame",new D({delta:e,time:this._time+=e,count:this._count++})),this._stats&&this._stats.update()},_animateItem:function(t,e){var n=this._frameItems;e?(n[t._id]={item:t,time:0,count:0},1==++this._frameItemCount&&this.on("frame",this._handleFrameItems)):(delete n[t._id],0==--this._frameItemCount&&this.off("frame",this._handleFrameItems))},_handleFrameItems:function(t){for(var e in this._frameItems){e=this._frameItems[e];e.item.emit("frame",new D(t,{time:e.time+=t.delta,count:e.count++}))}},_changed:function(){this._project._changed(4097),this._bounds=this._decomposed=j},getElement:function(){return this._element},getPixelRatio:function(){return this._pixelRatio},getResolution:function(){return 72*this._pixelRatio},getViewSize:function(){var t=this._viewSize;return new n(t.width,t.height,this,"setViewSize")},setViewSize:function(){var t=k.read(arguments),e=t.subtract(this._viewSize);e.isZero()||(this._setElementSize(t.width,t.height),this._viewSize.set(t),this._changed(),this.emit("resize",{size:t,delta:e}),this._autoUpdate&&this.update())},_setElementSize:function(t,e){var n=this._element;n&&(n.width!==t&&(n.width=t),n.height!==e&&(n.height=e))},getBounds:function(){return this._bounds||(this._bounds=this._matrix.inverted()._transformBounds(new b(new L,this._viewSize))),this._bounds},getSize:function(){return this.getBounds().getSize()},isVisible:function(){return z.isInView(this._element)},isInserted:function(){return z.isInserted(this._element)},getPixelSize:function(t){var e,n,i=this._element;return i?(n=i.parentNode,(i=_.createElement("div")).style.fontSize=t,n.appendChild(i),e=parseFloat(z.getStyles(i).fontSize),n.removeChild(i)):e=parseFloat(e),e},getTextWidth:function(t,e){return 0}},D.each(["rotate","scale","shear","skew"],function(n){var i="rotate"===n;this[n]=function(){var t=arguments,e=(i?D:L).read(t),t=L.read(t,0,{readNull:!0});return this.transform((new A)[n](e,t||this.getCenter(!0)))}},{_decompose:function(){return this._decomposed||(this._decomposed=this._matrix.decompose())},translate:function(){var t=new A;return this.transform(t.translate.apply(t,arguments))},getCenter:function(){return this.getBounds().getCenter()},setCenter:function(){var t=L.read(arguments);this.translate(this.getCenter().subtract(t))},getZoom:function(){var t=this._decompose().scaling;return(t.x+t.y)/2},setZoom:function(t){this.transform((new A).scale(t/this.getZoom(),this.getCenter()))},getRotation:function(){return this._decompose().rotation},setRotation:function(t){var e=this.getRotation();null!=e&&null!=t&&this.rotate(t-e)},getScaling:function(){var t=this._decompose().scaling;return new c(t.x,t.y,this,"setScaling")},setScaling:function(){var t=this.getScaling(),e=L.read(arguments,0,{clone:!0,readNull:!0});t&&e&&this.scale(e.x/t.x,e.y/t.y)},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.set.apply(t,arguments)},transform:function(t){this._matrix.append(t)},scrollBy:function(){this.translate(L.read(arguments).negate())}}),{projectToView:function(){return this._matrix._transformPoint(L.read(arguments))},viewToProject:function(){return this._matrix._inverseTransform(L.read(arguments))},getEventPoint:function(t){return this.viewToProject(B.getOffset(t,this._element))}},{statics:{_views:[],_viewsById:{},_id:0,create:function(t,e){return _&&"string"==typeof e&&(e=_.getElementById(e)),new(T?tt:Y)(t,e)}}},new function(){if(T){var i,r,t,e,n,f=!1,s=!1,a=T.navigator;a.pointerEnabled||a.msPointerEnabled?(t="pointerdown MSPointerDown",e="pointermove MSPointerMove",n="pointerup pointercancel MSPointerUp MSPointerCancel"):(t="touchstart",e="touchmove",n="touchend touchcancel","ontouchstart"in T&&a.userAgent.match(/mobile|tablet|ip(ad|hone|od)|android|silk/i)||(t+=" mousedown",e+=" mousemove",n+=" mouseup"));var o={},a={mouseout:function(t){var e,n,i,r=Y._focused,s=B.getRelatedTarget(t);!r||s&&"HTML"!==s.nodeName||(n=(e=B.getOffset(t,r._element)).x,s=(i=Math.abs)(n),e.x=i(i=s-(1<<25))<s?i*(n<0?-1:1):n,d(r,t,r.viewToProject(e)))},scroll:c};o[t]=function(t){var e=Y._focused=l(t);f||(f=!0,e._handleMouseEvent("mousedown",t))},a[e]=function(t){var e,n=Y._focused;s||((e=l(t))?n!==e&&(n&&d(n,t),i=i||n,n=Y._focused=r=e):r&&r===n&&(i&&!i.isInserted()&&(i=null),n=Y._focused=i,i=null,c())),n&&d(n,t)},a[t]=function(){s=!0},a[n]=function(t){var e=Y._focused;e&&f&&e._handleMouseEvent("mouseup",t),s=f=!1},B.add(_,a),B.add(T,{load:c});var g,v,p,m,y,w,x,b,S=!1,C=!1,u={doubleclick:"click",mousedrag:"mousemove"},P=!1,h={mousedown:{mousedown:1,mousedrag:1,click:1,doubleclick:1},mouseup:{mouseup:1,mousedrag:1,click:1,doubleclick:1},mousemove:{mousedrag:1,mousemove:1,mouseenter:1,mouseleave:1}};return{_viewEvents:o,_handleMouseEvent:function(t,e,n){var i=this._itemEvents,r=i.native[t],s="mousemove"===t,a=this._scope.tool,o=this;function h(t){return i.virtual[t]||o.responds(t)||a&&a.responds(t)}s&&f&&h("mousedrag")&&(t="mousedrag"),n=n||this.getEventPoint(e);var u=this.getBounds().contains(n),l=r&&u&&o._project.hitTest(n,{tolerance:0,fill:!0,stroke:!0}),c=l&&l.item||null,d=!1,l={};if(l[t.substr(5)]=!0,r&&c!==m&&(m&&I(m,null,"mouseleave",e,n),c&&I(c,null,"mouseenter",e,n),m=c),P^u&&(I(this,null,u?"mouseenter":"mouseleave",e,n),d=!0),!u&&!l.drag||n.equals(v)||(M(this,c,s?t:"mousemove",e,n,v),d=!0),P=u,l.down&&u||l.up&&g){if(M(this,c,t,e,n,g),l.down){if(b=c===w&&Date.now()-x<300,p=w=c,!C&&c){for(var _=c;_&&!_.responds("mousedrag");)_=_._parent;_&&(y=c)}g=n}else l.up&&(C||c!==p||(x=Date.now(),M(this,c,b?"doubleclick":"click",e,n,g),b=!1),p=y=null);d=!(P=!1)}v=n,d&&a&&(S=a._handleMouseEvent(t,e,n,l)||S),!1!==e.cancelable&&(S&&!l.move||l.down&&h("mouseup"))&&e.preventDefault()},_handleKeyEvent:function(e,n,i,r){var s,a=this._scope,t=a.tool;function o(t){t.responds(e)&&(Bt=a,t.emit(e,s=s||new nt(e,n,i,r)))}this.isVisible()&&(o(this),t&&t.responds(e)&&o(t))},_countItemEvent:function(t,e){var n,i=this._itemEvents,r=i.native,i=i.virtual;for(n in h)r[n]=(r[n]||0)+(h[n][t]||0)*e;i[t]=(i[t]||0)+e},statics:{updateFocus:c,_resetState:function(){f=s=S=P=!1,i=r=g=v=p=m=y=w=x=b=null}}}}function l(t){t=B.getTarget(t);return t.getAttribute&&Y._viewsById[t.getAttribute("id")]}function c(){var t=Y._focused;if(!t||!t.isVisible())for(var e=0,n=Y._views.length;e<n;e++)if((t=Y._views[e]).isVisible()){Y._focused=r=t;break}}function d(t,e,n){t._handleMouseEvent("mousemove",e,n)}function I(t,i,e,r,s,a,n){var o,h=!1;for(;t&&t!==n&&!function t(e,n){if(e.responds(n)){if(o=o||new rt(n,r,s,i||e,a?s.subtract(a):null),e.emit(n,o)&&(S=!0,o.prevented&&(C=!0),o.stopped))return h=!0}else if(n=u[n])return t(e,n)}(t,e);)t=t._parent;return h}function M(t,e,n,i,r,s){return t._project.removeOn(n),C=S=!1,y&&I(y,null,n,i,r,s)||e&&e!==y&&!e.isDescendant(y)&&I(e,null,"mousedrag"===n?"mousemove":n,i,r,s,y)||I(t,y||e||t,n,i,r,s)}}),tt=Y.extend({_class:"CanvasView",initialize:function(t,e){if(!(e instanceof T.HTMLCanvasElement)){var n=k.read(arguments,1);if(n.isZero())throw new Error("Cannot create CanvasView with the provided argument: "+D.slice(arguments,1));e=ht.getCanvas(n)}var i=this._context=e.getContext("2d");i.save(),this._pixelRatio=1,/^off|false$/.test(l.getAttribute(e,"hidpi"))||(n=T.devicePixelRatio||1,i=z.getPrefixed(i,"backingStorePixelRatio")||1,this._pixelRatio=n/i),Y.call(this,t,e),this._needsUpdate=!0},remove:function t(){return this._context.restore(),t.base.call(this)},_setElementSize:function t(e,n){var i,r,s=this._pixelRatio;t.base.call(this,e*s,n*s),1!==s&&(r=this._element,i=this._context,l.hasAttribute(r,"resize")||((r=r.style).width=e+"px",r.height=n+"px"),i.restore(),i.save(),i.scale(s,s))},getContext:function(){return this._context},getPixelSize:function t(e){var n,i,r=Bt.agent;return r&&r.firefox?n=t.base.call(this,e):(r=(i=this._context).font,i.font=e+" serif",n=parseFloat(i.font),i.font=r),n},getTextWidth:function(t,e){var n=this._context,i=n.font,r=0;n.font=t;for(var s=0,a=e.length;s<a;s++)r=Math.max(r,n.measureText(e[s]).width);return n.font=i,r},update:function(){if(!this._needsUpdate)return!1;var t=this._project,e=this._context,n=this._viewSize;return e.clearRect(0,0,n.width+1,n.height+1),t&&t.draw(e,this._matrix,this._pixelRatio),!(this._needsUpdate=!1)}}),et=D.extend({_class:"Event",initialize:function(t){this.event=t,this.type=t&&t.type},prevented:!1,stopped:!1,preventDefault:function(){this.prevented=!0,this.event.preventDefault()},stopPropagation:function(){this.stopped=!0,this.event.stopPropagation()},stop:function(){this.stopPropagation(),this.preventDefault()},getTimeStamp:function(){return this.event.timeStamp},getModifiers:function(){return it.modifiers}}),nt=et.extend({_class:"KeyEvent",initialize:function(t,e,n,i){this.type=t,this.event=e,this.key=n,this.character=i},toString:function(){return"{ type: '"+this.type+"', key: '"+this.key+"', character: '"+this.character+"', modifiers: "+this.getModifiers()+" }"}}),it=new function(){var h,i,n={"\t":"tab"," ":"space","\b":"backspace","\x7f":"delete",Spacebar:"space",Del:"delete",Win:"meta",Esc:"escape"},r={tab:"\t",space:" ",enter:"\r"},u={},l={},c=new D({shift:!1,control:!1,alt:!1,meta:!1,capsLock:!1,space:!1}).inject({option:{get:function(){return this.alt}},command:{get:function(){var t=Bt&&Bt.agent;return t&&t.mac?this.meta:this.control}}});function s(t){var e=t.key||t.keyIdentifier,e=/^U\+/.test(e)?String.fromCharCode(parseInt(e.substr(2),16)):/^Arrow[A-Z]/.test(e)?e.substr(5):"Unidentified"===e||e===j?String.fromCharCode(t.keyCode):e;return n[e]||(1<e.length?D.hyphenate(e):e.toLowerCase())}function d(t,e,n,i){var r,s=Y._focused;if((u[e]=t)?l[e]=n:delete l[e],1<e.length&&(r=D.camelize(e))in c){c[r]=t;var a=Bt&&Bt.agent;if("meta"===r&&a&&a.mac)if(t)h={};else{for(var o in h)o in l&&d(!1,o,h[o],i);h=null}}else t&&h&&(h[e]=n);s&&s._handleKeyEvent(t?"keydown":"keyup",i,e,n)}return B.add(_,{keydown:function(t){var e=s(t),n=Bt&&Bt.agent;1<e.length||n&&n.chrome&&(t.altKey||n.mac&&t.metaKey||!n.mac&&t.ctrlKey)?d(!0,e,r[e]||(1<e.length?"":e),t):i=e},keypress:function(t){var e,n;i&&(e=s(t),n=32<=(n=t.charCode)?String.fromCharCode(n):1<e.length?"":e,d(!0,e=e!==i?n.toLowerCase():e,n,t),i=null)},keyup:function(t){var e=s(t);e in l&&d(!1,e,l[e],t)}}),B.add(T,{blur:function(t){for(var e in l)d(!1,e,l[e],t)}}),{modifiers:c,isDown:function(t){return!!u[t]}}},rt=et.extend({_class:"MouseEvent",initialize:function(t,e,n,i,r){this.type=t,this.event=e,this.point=n,this.target=i,this.delta=r},toString:function(){return"{ type: '"+this.type+"', point: "+this.point+", target: "+this.target+(this.delta?", delta: "+this.delta:"")+", modifiers: "+this.getModifiers()+" }"}}),st=et.extend({_class:"ToolEvent",_item:null,initialize:function(t,e,n){this.tool=t,this.type=e,this.event=n},_choosePoint:function(t,e){return t||(e?e.clone():null)},getPoint:function(){return this._choosePoint(this._point,this.tool._point)},setPoint:function(t){this._point=t},getLastPoint:function(){return this._choosePoint(this._lastPoint,this.tool._lastPoint)},setLastPoint:function(t){this._lastPoint=t},getDownPoint:function(){return this._choosePoint(this._downPoint,this.tool._downPoint)},setDownPoint:function(t){this._downPoint=t},getMiddlePoint:function(){return!this._middlePoint&&this.tool._lastPoint?this.tool._point.add(this.tool._lastPoint).divide(2):this._middlePoint},setMiddlePoint:function(t){this._middlePoint=t},getDelta:function(){return!this._delta&&this.tool._lastPoint?this.tool._point.subtract(this.tool._lastPoint):this._delta},setDelta:function(t){this._delta=t},getCount:function(){return this.tool[/^mouse(down|up)$/.test(this.type)?"_downCount":"_moveCount"]},setCount:function(t){this.tool[/^mouse(down|up)$/.test(this.type)?"downCount":"count"]=t},getItem:function(){if(!this._item){var t=this.tool._scope.project.hitTest(this.getPoint());if(t){for(var e=t.item,n=e._parent;/^(Group|CompoundPath)$/.test(n._class);)n=(e=n)._parent;this._item=e}}return this._item},setItem:function(t){this._item=t},toString:function(){return"{ type: "+this.type+", point: "+this.getPoint()+", count: "+this.getCount()+", modifiers: "+this.getModifiers()+" }"}}),at=(e.extend({_class:"Tool",_list:"tools",_reference:"tool",_events:["onMouseDown","onMouseUp","onMouseDrag","onMouseMove","onActivate","onDeactivate","onEditOptions","onKeyDown","onKeyUp"],initialize:function(t){e.call(this),this._moveCount=-1,this._downCount=-1,this.set(t)},getMinDistance:function(){return this._minDistance},setMinDistance:function(t){null!=(this._minDistance=t)&&null!=this._maxDistance&&t>this._maxDistance&&(this._maxDistance=t)},getMaxDistance:function(){return this._maxDistance},setMaxDistance:function(t){this._maxDistance=t,null!=this._minDistance&&null!=t&&t<this._minDistance&&(this._minDistance=t)},getFixedDistance:function(){return this._minDistance==this._maxDistance?this._minDistance:null},setFixedDistance:function(t){this._minDistance=this._maxDistance=t},_handleMouseEvent:function(t,e,a,o){Bt=this._scope,o.drag&&!this.responds(t)&&(t="mousemove");var h=o.move||o.drag,n=this.responds(t),i=!1,u=this;function r(t,e){var n=a,i=h?u._point:u._downPoint||n;if(h){if(0<=u._moveCount&&n.equals(i))return;if(i&&(null!=t||null!=e)){var r=n.subtract(i),s=r.getLength();if(s<(t||0))return;e&&(n=i.add(r.normalize(Math.min(s,e))))}u._moveCount++}return u._point=n,u._lastPoint=i||n,o.down&&(u._moveCount=-1,u._downPoint=n,u._downCount++),1}function s(){n&&(i=u.emit(t,new st(u,t,e))||i)}if(o.down)r(),s();else if(o.up)r(null,this._maxDistance),s();else if(n)for(;r(this._minDistance,this._maxDistance);)s();return i}}),D.extend(t,{_class:"Tween",statics:{easings:new D({linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return t*(2-t)},easeInOutQuad:function(t){return t<.5?2*t*t:2*(2-t)*t-1},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return 1- --t*t*t*t},easeInOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return 1+--t*t*t*t*t},easeInOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t}})},initialize:function t(e,n,i,r,s,a){this.object=e;var o=typeof s,e="function"==o;this.type=e?o:"string"==o?s:"linear",this.easing=e?s:t.easings[this.type],this.duration=r,this.running=!1,this._then=null,this._startTime=null;r=n||i;this._keys=r?Object.keys(r):[],this._parsedKeys=this._parseKeys(this._keys),this._from=r&&this._getState(n),this._to=r&&this._getState(i),!1!==a&&this.start()},then:function(t){return this._then=t,this},start:function(){return this._startTime=null,this.running=!0,this},stop:function(){return this.running=!1,this},update:function(e){if(this.running){1<=e&&(this.running=!(e=1));function t(t){return"function"==typeof t?t(n,e):t}for(var n=this.easing(e),i=this._keys,r=0,s=i&&i.length;r<s;r++){var a=i[r],o=t(this._from[a]),h=t(this._to[a]),o=o&&h&&o.__add&&h.__add?h.__subtract(o).__multiply(n).__add(o):(h-o)*n+o;this._setProperty(this._parsedKeys[a],o)}this.responds("update")&&this.emit("update",new D({progress:e,factor:n})),!this.running&&this._then&&this._then(this.object)}return this},_events:{onUpdate:{}},_handleFrame:function(t){var e=this._startTime,n=e?(t-e)/this.duration:0;e||(this._startTime=t),this.update(n)},_getState:function(t){for(var e=this._keys,n={},i=0,r=e.length;i<r;i++){var s,a=e[i],o=this._parsedKeys[a],h=this._getProperty(o);t?(s=this._resolveValue(h,t[a]),this._setProperty(o,s),s=(s=this._getProperty(o))&&s.clone?s.clone():s,this._setProperty(o,h)):s=h&&h.clone?h.clone():h,n[a]=s}return n},_resolveValue:function(t,e){if(e){if(Array.isArray(e)&&2===e.length){var n=e[0];return n&&n.match&&n.match(/^[+\-\*\/]=/)?this._calculate(t,n[0],e[1]):e}if("string"==typeof e){n=e.match(/^[+\-*/]=(.*)/);if(n){n=JSON.parse(n[1].replace(/(['"])?([a-zA-Z0-9_]+)(['"])?:/g,'"$2": '));return this._calculate(t,e[0],n)}}}return e},_calculate:function(t,e,n){return Bt.PaperScript.calculateBinary(t,e,n)},_parseKeys:function(t){for(var e={},n=0,i=t.length;n<i;n++){var r=t[n],s=r.replace(/\.([^.]*)/g,"/$1").replace(/\[['"]?([^'"\]]*)['"]?\]/g,"/$1");e[r]=s.split("/")}return e},_getProperty:function(t,e){for(var n=this.object,i=0,r=t.length-(e||0);i<r&&n;i++)n=n[t[i]];return n},_setProperty:function(t,e){var n=this._getProperty(t,1);n&&(n[t[t.length-1]]=e)}})),ot=function(n){var i=new u.XMLHttpRequest;return i.open((n.method||"get").toUpperCase(),n.url,D.pick(n.async,!0)),n.mimeType&&i.overrideMimeType(n.mimeType),i.onload=function(){var t=i.status;0===t||200===t?n.onLoad&&n.onLoad.call(i,i.responseText):i.onerror()},i.onerror=function(){var t=i.status,e='Could not load "'+n.url+'" (Status: '+t+")";if(!n.onError)throw new Error(e);n.onError(e,t)},i.send(null)},ht=D.exports.CanvasProvider={canvases:[],getCanvas:function(t,e,n){if(!T)return null;var i,r=!0;"object"==typeof t&&(e=t.height,t=t.width),this.canvases.length?i=this.canvases.pop():(i=_.createElement("canvas"),r=!1);n=i.getContext("2d",n||{});if(!n)throw new Error("Canvas "+i+" is unable to provide a 2D context.");return i.width===t&&i.height===e?r&&n.clearRect(0,0,t+1,e+1):(i.width=t,i.height=e),n.save(),i},getContext:function(t,e,n){e=this.getCanvas(t,e,n);return e?e.getContext("2d",n||{}):null},release:function(t){t=t&&t.canvas?t.canvas:t;t&&t.getContext&&(t.getContext("2d").restore(),this.canvases.push(t))}},ut=new function(){var f,g,v,p,m,y,w,x,b,S,C,a=Math.min,o=Math.max,t=Math.abs;function h(t,e,n){return.2989*t+.587*e+.114*n}function e(t,e,n,i){var r,s=i-h(t,e,n),i=h(b=t+s,S=e+s,C=n+s),n=a(b,S,C),s=o(b,S,C);n<0&&(b=i+(b-i)*i/(r=i-n),S=i+(S-i)*i/r,C=i+(C-i)*i/r),255<s&&(b=i+(b-i)*(r=255-i)/(s=s-i),S=i+(S-i)*r/s,C=i+(C-i)*r/s)}function n(t,e,n){return o(t,e,n)-a(t,e,n)}function i(t,e,n,i){var r=[t,e,n],s=o(t,e,n),n=a(t,e,n),e=0===a(n=n===t?0:n===e?1:2,s=s===t?0:s===e?1:2)?1===o(n,s)?2:1:0;r[s]>r[n]?(r[e]=(r[e]-r[n])*i/(r[s]-r[n]),r[s]=i):r[e]=r[s]=0,r[n]=0,b=r[0],S=r[1],C=r[2]}var P={multiply:function(){b=m*f/255,S=y*g/255,C=w*v/255},screen:function(){b=m+f-m*f/255,S=y+g-y*g/255,C=w+v-w*v/255},overlay:function(){b=m<128?2*m*f/255:255-2*(255-m)*(255-f)/255,S=y<128?2*y*g/255:255-2*(255-y)*(255-g)/255,C=w<128?2*w*v/255:255-2*(255-w)*(255-v)/255},"soft-light":function(){var t=f*m/255;b=t+m*(255-(255-m)*(255-f)/255-t)/255,S=(t=g*y/255)+y*(255-(255-y)*(255-g)/255-t)/255,C=(t=v*w/255)+w*(255-(255-w)*(255-v)/255-t)/255},"hard-light":function(){b=f<128?2*f*m/255:255-2*(255-f)*(255-m)/255,S=g<128?2*g*y/255:255-2*(255-g)*(255-y)/255,C=v<128?2*v*w/255:255-2*(255-v)*(255-w)/255},"color-dodge":function(){b=0===m?0:255===f?255:a(255,255*m/(255-f)),S=0===y?0:255===g?255:a(255,255*y/(255-g)),C=0===w?0:255===v?255:a(255,255*w/(255-v))},"color-burn":function(){b=255===m?255:0===f?0:o(0,255-255*(255-m)/f),S=255===y?255:0===g?0:o(0,255-255*(255-y)/g),C=255===w?255:0===v?0:o(0,255-255*(255-w)/v)},darken:function(){b=m<f?m:f,S=y<g?y:g,C=w<v?w:v},lighten:function(){b=f<m?m:f,S=g<y?y:g,C=v<w?w:v},difference:function(){(b=m-f)<0&&(b=-b),(S=y-g)<0&&(S=-S),(C=w-v)<0&&(C=-C)},exclusion:function(){b=m+f*(255-m-m)/255,S=y+g*(255-y-y)/255,C=w+v*(255-w-w)/255},hue:function(){i(f,g,v,n(m,y,w)),e(b,S,C,h(m,y,w))},saturation:function(){i(m,y,w,n(f,g,v)),e(b,S,C,h(m,y,w))},luminosity:function(){e(m,y,w,h(f,g,v))},color:function(){e(f,g,v,h(m,y,w))},add:function(){b=a(m+f,255),S=a(y+g,255),C=a(w+v,255)},subtract:function(){b=o(m-f,0),S=o(y-g,0),C=o(w-v,0)},average:function(){b=(m+f)/2,S=(y+g)/2,C=(w+v)/2},negation:function(){b=255-t(255-f-m),S=255-t(255-g-y),C=255-t(255-v-w)}},I=this.nativeModes=D.each(["source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","lighter","darker","copy","xor"],function(t){this[t]=!0},{}),r=ht.getContext(1,1,{willReadFrequently:!0});r&&(D.each(P,function(t,e){var n="darken"===e,i=!1;r.save();try{r.fillStyle=n?"#300":"#a00",r.fillRect(0,0,1,1),r.globalCompositeOperation=e,r.globalCompositeOperation===e&&(r.fillStyle=n?"#a00":"#300",r.fillRect(0,0,1,1),i=r.getImageData(0,0,1,1).data[0]!==n?170:51)}catch(t){}r.restore(),I[e]=i}),ht.release(r)),this.process=function(t,e,n,i,r){var s=e.canvas,a="normal"===t;if(a||I[t])n.save(),n.setTransform(1,0,0,1,0,0),n.globalAlpha=i,a||(n.globalCompositeOperation=t),n.drawImage(s,r.x,r.y),n.restore();else{var o=P[t];if(o){for(var t=n.getImageData(r.x,r.y,s.width,s.height),h=t.data,u=e.getImageData(0,0,s.width,s.height).data,l=0,c=h.length;l<c;l+=4){f=u[l],m=h[l],g=u[l+1],y=h[l+1],v=u[l+2],w=h[l+2],p=u[l+3],x=h[l+3],o();var d=p*i/255,_=1-d;h[l]=d*b+_*m,h[l+1]=d*S+_*y,h[l+2]=d*C+_*w,h[l+3]=p*i+_*x}n.putImageData(t,r.x,r.y)}}}},lt=new function(){var i="http://www.w3.org/2000/svg",t="http://www.w3.org/2000/xmlns",e="http://www.w3.org/1999/xlink",a={href:e,xlink:t,xmlns:t+"/","xmlns:xlink":t+"/"};function r(t,e,n){for(var i in e){var r=e[i],s=a[i];"number"==typeof r&&n&&(r=n.number(r)),s?t.setAttributeNS(s,i,r):t.setAttribute(i,r)}return t}return{svg:i,xmlns:t,xlink:e,create:function(t,e,n){return r(_.createElementNS(i,t),e,n)},get:function(t,e){var n=a[e];return"null"===(e=n?t.getAttributeNS(n,e):t.getAttribute(e))?null:e},set:r}},ct=D.each({fillColor:["fill","color"],fillRule:["fill-rule","string"],strokeColor:["stroke","color"],strokeWidth:["stroke-width","number"],strokeCap:["stroke-linecap","string"],strokeJoin:["stroke-linejoin","string"],strokeScaling:["vector-effect","lookup",{true:"none",false:"non-scaling-stroke"},function(t,e){return!e&&(t instanceof m||t instanceof f||t instanceof w)}],miterLimit:["stroke-miterlimit","number"],dashArray:["stroke-dasharray","array"],dashOffset:["stroke-dashoffset","number"],fontFamily:["font-family","string"],fontWeight:["font-weight","string"],fontSize:["font-size","number"],justification:["text-anchor","lookup",{left:"start",center:"middle",right:"end"}],opacity:["opacity","number"],blendMode:["mix-blend-mode","style"]},function(t,e){var n=D.capitalize(e),i=t[2];this[e]={type:t[1],property:e,attribute:t[0],toSVG:i,fromSVG:i&&D.each(i,function(t,e){this[t]=e},{}),exportFilter:t[3],get:"get"+n,set:"set"+n}},{});function dt(t,e,n){var i,r,s=new D,a=t.getTranslation();return e&&(t.isInvertible()?(i=(t=t._shiftless())._inverseTransform(a),a=null):i=new L,s[n?"cx":"x"]=i.x,s[n?"cy":"y"]=i.y),t.isIdentity()||((r=t.decompose())?(e=[],n=r.rotation,i=r.scaling,r=r.skewing,a&&!a.isZero()&&e.push("translate("+E.point(a)+")"),n&&e.push("rotate("+E.number(n)+")"),q.isZero(i.x-1)&&q.isZero(i.y-1)||e.push("scale("+E.point(i)+")"),r.x&&e.push("skewX("+E.number(r.x)+")"),r.y&&e.push("skewY("+E.number(r.y)+")"),s.transform=e.join(" ")):s.transform="matrix("+t.getValues().join(",")+")"),s}function _t(t,e){for(var n=dt(t._matrix),i=t._children,r=lt.create("g",n,E),s=0,a=i.length;s<a;s++){var o,h=i[s],u=yt(h,e);u&&(h.isClipMask()?((o=lt.create("clipPath")).appendChild(u),pt(h,o,"clip"),lt.set(r,{"clip-path":"url(#"+o.id+")"})):r.appendChild(u))}return r}function ft(t){var e,n=t._type,i=t._radius,r=dt(t._matrix,!0,"rectangle"!==n);return"rectangle"===n&&(n="rect",t=(e=t._size).width,e=e.height,r.x-=t/2,r.y-=e/2,r.width=t,r.height=e,i.isZero()&&(i=null)),i&&("circle"===n?r.r=i:(r.rx=i.width,r.ry=i.height)),lt.create(n,r,E)}function gt(r,t,s,e){var a={},o=!e&&r.getParent(),h=[];return null!=r._name&&(a.id=r._name),D.each(ct,function(t){var e=t.get,n=t.type,i=r[e]();(t.exportFilter?!t.exportFilter(r,i):0!=s.reduceAttributes&&o&&D.equals(o[e](),i))||("color"!==n||null==i||(e=i.getAlpha())<1&&(a[t.attribute+"-opacity"]=e),"style"===n?h.push(t.attribute+": "+i):a[t.attribute]=null==i?"none":"color"===n?i.gradient?function(t){if(!(o=vt(t,"color"))){var e,n,i=t.getGradient(),r=i._radial,s=t.getOrigin(),a=t.getDestination();r?(e={cx:s.x,cy:s.y,r:s.getDistance(a)},(n=t.getHighlight())&&(e.fx=n.x,e.fy=n.y)):e={x1:s.x,y1:s.y,x2:a.x,y2:a.y},e.gradientUnits="userSpaceOnUse";for(var o=lt.create((r?"radial":"linear")+"Gradient",e,E),h=i._stops,u=0,l=h.length;u<l;u++){var c=h[u],d=c._color,_=d.getAlpha(),c=c._offset;e={offset:null==c?u/(l-1):c},d&&(e["stop-color"]=d.toCSS(!0)),_<1&&(e["stop-opacity"]=_),o.appendChild(lt.create("stop",e,E))}pt(t,o,"color")}return"url(#"+o.id+")"}(i):i.toCSS(!0):"array"===n?i.join(","):"lookup"===n?t.toSVG[i]:i)}),h.length&&(a.style=h.join(";")),1===a.opacity&&delete a.opacity,r._visible||(a.visibility="hidden"),lt.set(t,a,E)}function vt(t,e){return F=F||{ids:{},svgs:{}},t&&F.svgs[e+"-"+(t._id||t.__id||(t.__id=o.get("svg")))]}function pt(t,e,n){F||vt();var i=F.ids[n]=(F.ids[n]||0)+1;e.id=n+"-"+i,F.svgs[n+"-"+(t._id||t.__id)]=e}function mt(t,e){var n=t,i=null;if(F){for(var r in n="svg"===t.nodeName.toLowerCase()&&t,F.svgs)i||(n||(n=lt.create("svg")).appendChild(t),i=n.insertBefore(lt.create("defs"),n.firstChild)),i.appendChild(F.svgs[r]);F=null}return e.asString?(new u.XMLSerializer).serializeToString(n):n}function yt(t,e,n){var i=$[t._class],r=i&&i(t,e);return r&&((i=e.onExport)&&(r=i(t,r,e)||r),(i=JSON.stringify(t._data))&&"{}"!==i&&"null"!==i&&r.setAttribute("data-paper-data",i)),r&&gt(t,r,e,n)}function wt(t){return E=new x((t=t||{}).precision),t}function xt(t,e,n,i,r,s){s=lt.get(t,e)||s,n=null==s?i?null:n?"":0:n?s:parseFloat(s);return/%\s*$/.test(s)?n/100*(r?1:J[/x|^width/.test(e)?"width":"height"]):n}function bt(t,e,n,i,r,s,a){return e=xt(t,e||"x",!1,i,r,s),n=xt(t,n||"y",!1,i,r,a),!i||null!=e&&null!=n?new L(e,n):null}function St(t,e,n,i,r){return e=xt(t,e||"width",!1,i,r),n=xt(t,n||"height",!1,i,r),!i||null!=e&&null!=n?new k(e,n):null}function Ct(t,e,n){return"none"===t?null:"number"===e?parseFloat(t):"array"===e?t?t.split(/[\s,]+/g).map(parseFloat):[]:"color"===e?At(t)||t:"lookup"===e?n[t]:t}function Pt(t,e,n,i){var r=t.childNodes,s="clippath"===e,a="defs"===e,o=new g,h=o._project,e=h._currentStyle,u=[];if(s||a||(o=kt(o,t,i),h._currentStyle=o._style.clone()),i)for(var l=t.querySelectorAll("defs"),c=0,d=l.length;c<d;c++)Lt(l[c],n,!1);for(c=0,d=r.length;c<d;c++){var _,f=r[c];1!==f.nodeType||/^defs$/i.test(f.nodeName)||!(_=Lt(f,n,!1))||_ instanceof v||u.push(_)}return o.addChildren(u),s&&(o=kt(o.reduce(),t,i)),h._currentStyle=e,(s||a)&&(o.remove(),o=null),o}function It(t,e){for(var n=t.getAttribute("points").match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g),i=[],r=0,s=n.length;r<s;r+=2)i.push(new L(parseFloat(n[r]),parseFloat(n[r+1])));t=new W(i);return"polygon"===e&&t.closePath(),t}function Mt(t,e){var n,i=(xt(t,"href",!0)||"").substring(1),e="radialgradient"===e;if(i)(n=K[i].getGradient())._radial^e&&((n=n.clone())._radial=e);else{for(var r=t.childNodes,s=[],a=0,o=r.length;a<o;a++){var h=r[a];1===h.nodeType&&s.push(kt(new I,h))}n=new P(s,e)}var u,l,c,i="userSpaceOnUse"!==xt(t,"gradientUnits",!0);return e?(l=(u=bt(t,"cx","cy",!1,i,"50%","50%")).add(xt(t,"r",!1,!1,i,"50%"),0),c=bt(t,"fx","fy",!0,i)):(u=bt(t,"x1","y1",!1,i,"0%","0%"),l=bt(t,"x2","y2",!1,i,"100%","0%")),kt(new C(n,u,l,c),t)._scaleToBounds=i,null}function Tt(t,e,n,i){if(t.transform){for(var r=(i.getAttribute(n)||"").split(/\)\s*/g),s=new A,a=0,o=r.length;a<o;a++){var h=r[a];if(!h)break;for(var u=h.split(/\(\s*/),h=u[0].trim(),l=u[1].split(/[\s,]+/g),c=0,d=l.length;c<d;c++)l[c]=parseFloat(l[c]);switch(h){case"matrix":s.append(new A(l[0],l[1],l[2],l[3],l[4],l[5]));break;case"rotate":s.rotate(l[0],l[1]||0,l[2]||0);break;case"translate":s.translate(l[0],l[1]||0);break;case"scale":s.scale(l);break;case"skewX":s.skew(l[0],0);break;case"skewY":s.skew(0,l[0])}}t.transform(s)}}function Ot(t,e,n){n="fill-opacity"===n?"getFillColor":"getStrokeColor",n=t[n]&&t[n]();n&&n.setAlpha(parseFloat(e))}function zt(t,e,n){var i=t.attributes[e],i=i&&i.value;return!i&&t.style&&(e=D.camelize(e),(i=t.style[e])||n.node[e]===n.parent[e]||(i=n.node[e])),i?"none"===i?null:i:j}function kt(i,r,t){var e=r.parentNode,s={node:z.getStyles(r)||{},parent:!t&&!/^defs$/i.test(e.tagName)&&z.getStyles(e)||{}};return D.each(X,function(t,e){var n=zt(r,e,s);i=n!==j&&t(i,n,e,r,s)||i}),i}function At(t){t=t&&t.match(/\((?:["'#]*)([^"')]+)/),t=t&&t[1],t=t&&K[T?t.replace(T.location.href.split("#")[0]+"#",""):t];return t&&t._scaleToBounds&&((t=t.clone())._scaleToBounds=!0),t}function Lt(t,e,n){var i,r,s,a=t.nodeName.toLowerCase(),o="#document"!==a,h=_.body;n&&o&&(J=Bt.getView().getSize(),J=St(t,null,null,!0)||J,i=lt.create("svg",{style:"stroke-width: 1px; stroke-miterlimit: 10"}),r=t.parentNode,s=t.nextSibling,i.appendChild(t),h.appendChild(i));var u=Bt.settings,l=u.applyMatrix,c=u.insertItems;u.applyMatrix=!1,u.insertItems=!1;var d=Q[a],a=d&&d(t,a,e,n)||null;return u.insertItems=c,u.applyMatrix=l,a&&(!o||a instanceof g||(a=kt(a,t,n)),u=e.onImport,o=o&&t.getAttribute("data-paper-data"),u&&(a=u(t,a,e)||a),e.expandShapes&&a instanceof f&&(a.remove(),a=a.toPath()),o&&(a._data=JSON.parse(o))),i&&(h.removeChild(i),r&&(s?r.insertBefore(t,s):r.appendChild(t))),n&&(K={},a&&D.pick(e.applyMatrix,l)&&a.matrix.apply(!0,!0)),a}function Nt(i,r,s){if(!i)return null;r="function"==typeof r?{onLoad:r}:r||{};var a=Bt,o=null;function t(t){try{var e="object"==typeof t?t:(new u.DOMParser).parseFromString(t.trim(),"image/svg+xml");if(!e.nodeName)throw e=null,new Error("Unsupported SVG source: "+i);Bt=a,o=Lt(e,r,!0),r&&!1===r.insert||s._insertItem(j,o);var n=r.onLoad;n&&n(o,t)}catch(t){h(t)}}function h(t,e){var n=r.onError;if(!n)throw new Error(t);n(t,e)}if("string"!=typeof i||/^[\s\S]*</.test(i)){if("undefined"!=typeof File&&i instanceof File){var e=new FileReader;return e.onload=function(){t(e.result)},e.onerror=function(){h(e.error)},e.readAsText(i)}t(i)}else{var n=_.getElementById(i);n?t(n):ot({url:i,async:!0,onLoad:t,onError:h})}return o}$={Group:_t,Layer:_t,Raster:function(t,e){var n=dt(t._matrix,!0),i=t.getSize(),r=t.getImage();return n.x-=i.width/2,n.y-=i.height/2,n.width=i.width,n.height=i.height,n.href=0==e.embedImages&&r&&r.src||t.toDataURL(),lt.create("image",n,E)},Path:function(t,e){var n=e.matchShapes;if(n){var i=t.toShape(!1);if(i)return ft(i)}var r=t._segments,s=r.length,a=dt(t._matrix);if(n&&2<=s&&!t.hasHandles())if(2<s){for(var o=t._closed?"polygon":"polyline",h=[],u=0;u<s;u++)h.push(E.point(r[u]._point));a.points=h.join(" ")}else{o="line";i=r[0]._point,n=r[1]._point;a.set({x1:i.x,y1:i.y,x2:n.x,y2:n.y})}else o="path",a.d=t.getPathData(null,e.precision);return lt.create(o,a,E)},Shape:ft,CompoundPath:function(t,e){var n=dt(t._matrix);return(e=t.getPathData(null,e.precision))&&(n.d=e),lt.create("path",n,E)},SymbolItem:function(t,e){var n=dt(t._matrix,!0),i=t._definition,r=vt(i,"symbol"),s=i._item,t=s.getStrokeBounds();return r||((r=lt.create("symbol",{viewBox:E.rectangle(t)})).appendChild(yt(s,e)),pt(i,r,"symbol")),n.href="#"+r.id,n.x+=t.x,n.y+=t.y,n.width=t.width,n.height=t.height,n.overflow="visible",lt.create("use",n,E)},PointText:function(t){var e=lt.create("text",dt(t._matrix,!0),E);return e.textContent=t._content,e}},V.inject({exportSVG:function(t){return mt(yt(this,t=wt(t),!0),t)}}),i.inject({exportSVG:function(t){t=wt(t);var e=this._children,n=this.getView(),i=D.pick(t.bounds,"view"),r=t.matrix||"view"===i&&n._matrix,r=r&&A.read([r]),n="view"===i?new b([0,0],n.getViewSize()):"content"===i?V._getBounds(e,r,{stroke:!0}).rect:b.read([i],0,{readNull:!0}),i={version:"1.1",xmlns:lt.svg,"xmlns:xlink":lt.xlink};n&&(i.width=n.width,i.height=n.height,(n.x||0===n.x||n.y||0===n.y)&&(i.viewBox=E.rectangle(n)));var i=lt.create("svg",i,E),s=i;r&&!r.isIdentity()&&(s=i.appendChild(lt.create("g",dt(r),E)));for(var a=0,o=e.length;a<o;a++)s.appendChild(yt(e[a],t,!0));return mt(i,t)}}),K={},Q={"#document":function(t,e,n,i){for(var r=t.childNodes,s=0,a=r.length;s<a;s++){var o=r[s];if(1===o.nodeType)return Lt(o,n,i)}},g:Pt,svg:Pt,clippath:Pt,polygon:It,polyline:It,path:function(t){return m.create(t.getAttribute("d"))},lineargradient:Mt,radialgradient:Mt,image:function(e){var t=new d(xt(e,"href",!0));return t.on("load",function(){var t=St(e);this.setSize(t);t=bt(e).add(t.divide(2));this._matrix.append((new A).translate(t))}),t},symbol:function(t,e,n,i){return new v(Pt(t,e,n,i),!0)},defs:Pt,use:function(t){var e=(xt(t,"href",!0)||"").substring(1),e=K[e],t=bt(t);return e?e instanceof v?e.place(t):e.clone().translate(t):null},circle:function(t){return new f.Circle(bt(t,"cx","cy"),xt(t,"r"))},ellipse:function(t){return new f.Ellipse({center:bt(t,"cx","cy"),radius:St(t,"rx","ry")})},rect:function(t){return new f.Rectangle(new b(bt(t),St(t)),St(t,"rx","ry"))},line:function(t){return new W.Line(bt(t,"x1","y1"),bt(t,"x2","y2"))},text:function(t){var e=new S(bt(t).add(bt(t,"dx","dy")));return e.setContent(t.textContent.trim()||""),e},switch:Pt},X=D.set(D.each(ct,function(n){this[n.attribute]=function(t,e){t[n.set]&&(t[n.set](Ct(e,n.type,n.fromSVG)),"color"!==n.type||(e=t[n.get]())&&e._scaleToBounds&&(t=t.getBounds(),e.transform((new A).translate(t.getPoint()).scale(t.getSize()))))}},{}),{id:function(t,e){(K[e]=t).setName&&t.setName(e)},"clip-path":function(t,e){e=At(e);if(e){if((e=e.clone()).setClipMask(!0),!(t instanceof g))return new g(e,t);t.insertChild(0,e)}},gradientTransform:Tt,transform:Tt,"fill-opacity":Ot,"stroke-opacity":Ot,visibility:function(t,e){t.setVisible&&t.setVisible("visible"===e)},display:function(t,e){t.setVisible&&t.setVisible(null!==e)},"stop-color":function(t,e){t.setColor&&t.setColor(e)},"stop-opacity":function(t,e){t._color&&t._color.setAlpha(parseFloat(e))},offset:function(t,e){var n;t.setOffset&&(n=e.match(/(.*)%$/),t.setOffset(n?n[1]/100:parseFloat(e)))},viewBox:function(t,e,n,i,r){var s,a,o=new b(Ct(e,"array")),e=St(i,null,null,!0);t instanceof g?(a=e?e.divide(o.getSize()):1,s=(new A).scale(a).translate(o.getPoint().negate()),a=t):t instanceof v&&(e&&o.setSize(e),a=t._item),a&&("visible"!==zt(i,"overflow",r)&&((o=new f.Rectangle(o)).setClipMask(!0),a.addChild(o)),s&&a.transform(s))}}),V.inject({importSVG:function(t,e){return Nt(t,e,this)}}),i.inject({importSVG:function(t,e){return this.activate(),Nt(t,e,this)}});var Bt=new(l.inject(D.exports,{Base:D,Numerical:q,Key:it,DomEvent:B,DomElement:z,document:_,window:T,Symbol:v,PlacedSymbol:s}));return Bt.agent.node&&require("./node/extend.js")(Bt),"function"==typeof define&&define.amd?define("paper",Bt):"object"==typeof module&&module&&(module.exports=Bt),Bt}.call(this,"object"==typeof self?self:null);