import type { SVGCommand, TransformFunction } from './types.js';
declare function ROUND(roundVal?: number): (command: SVGCommand) => SVGCommand;
declare function TO_ABS(): (command: SVGCommand) => any;
declare function TO_REL(): (command: SVGCommand) => any;
declare function NORMALIZE_HVZ(normalizeZ?: boolean, normalizeH?: boolean, normalizeV?: boolean): (command: SVGCommand) => any;
declare function NORMALIZE_ST(): (command: SVGCommand) => any;
declare function QT_TO_C(): (command: SVGCommand) => any;
declare function INFO(f: (command: any, prevXAbs: number, prevYAbs: number, pathStartXAbs: number, pathStartYAbs: number) => any | any[]): (command: SVGCommand) => any;
declare function SANITIZE(EPS?: number): (command: SVGCommand) => any;
declare function MATRIX(a: number, b: number, c: number, d: number, e: number, f: number): (command: SVGCommand) => any;
declare function ROTATE(a: number, x?: number, y?: number): (command: SVGCommand) => any;
declare function TRANSLATE(dX: number, dY?: number): (command: SVGCommand) => any;
declare function SCALE(dX: number, dY?: number): (command: SVGCommand) => any;
declare function SKEW_X(a: number): (command: SVGCommand) => any;
declare function SKEW_Y(a: number): (command: SVGCommand) => any;
declare function X_AXIS_SYMMETRY(xOffset?: number): (command: SVGCommand) => any;
declare function Y_AXIS_SYMMETRY(yOffset?: number): (command: SVGCommand) => any;
declare function A_TO_C(): (command: SVGCommand) => any;
declare function ANNOTATE_ARCS(): (command: SVGCommand) => any;
declare function CLONE<T extends SVGCommand>(): (c: T) => T;
declare function CALCULATE_BOUNDS(): TransformFunction & {
    minX: number;
    maxX: number;
    minY: number;
    maxY: number;
};
export declare const SVGPathDataTransformer: {
    ROUND: typeof ROUND;
    TO_ABS: typeof TO_ABS;
    TO_REL: typeof TO_REL;
    NORMALIZE_HVZ: typeof NORMALIZE_HVZ;
    NORMALIZE_ST: typeof NORMALIZE_ST;
    QT_TO_C: typeof QT_TO_C;
    INFO: typeof INFO;
    SANITIZE: typeof SANITIZE;
    MATRIX: typeof MATRIX;
    ROTATE: typeof ROTATE;
    TRANSLATE: typeof TRANSLATE;
    SCALE: typeof SCALE;
    SKEW_X: typeof SKEW_X;
    SKEW_Y: typeof SKEW_Y;
    X_AXIS_SYMMETRY: typeof X_AXIS_SYMMETRY;
    Y_AXIS_SYMMETRY: typeof Y_AXIS_SYMMETRY;
    A_TO_C: typeof A_TO_C;
    ANNOTATE_ARCS: typeof ANNOTATE_ARCS;
    CLONE: typeof CLONE;
    CALCULATE_BOUNDS: typeof CALCULATE_BOUNDS;
};
export {};
