import { describe, test, expect } from '@jest/globals';
import { SVGPathData } from '../index.js';
describe('X axis symmetry', () => {
    test('should work with an arbitrary path', () => {
        expect(new SVGPathData('m12.5 140c0 0 7.63017 -32.95472 17.21798 -45.085701c0 0 8.60793 -7.043235 12.91188 -7.630171c4.30396 -0.586937 31.109058 -1.173872 31.109058 -1.173872l8.021699 -9.821022h3.717026l1.173872 -15.810194l-3.521618 -3.717024l-1.564688 -9.782503l0.586937 -4.50008h1.760808c0 0 1.138927 -12.71791 0.977752 -14.0879c-0.160463 -1.36928 4.911579 -16.18532 17.628774 -18.17648c12.71719 -1.99188 35.0336 10.50851 35.0336 10.50851l-1.20525 21.55903l-2.34775 6.65242l1.36928 0.39153c0 0 -0.1954 3.71702 -1.76081 6.260173c0 0 -2.15233 10.760974 -7.63017 10.956382l-4.30467 12.521783l-3.71703 4.109267l-2.93468 8.607922l14.67341 17.80493l1.17387 10.36944c0 0 8.52734 7.60521 6.31794 20.04214h-124.68722z')
            .toAbs()
            .xSymmetry(150)
            .encode()).toEqual('M137.5 140C137.5 140 129.86983 107.04527999999999 120.28202 94.914299C120.28202 94.914299 111.67409 87.871064 107.37013999999999 87.284128C103.06618 86.69719099999999 76.261082 86.11025599999999 76.261082 86.11025599999999L68.239383 76.289234H64.522357L63.348485 60.47904L66.870103 56.762015999999996L68.434791 46.979513L67.847854 42.479433H66.087046C66.087046 42.479433 64.948119 29.761523 65.109294 28.391533000000003C65.269757 27.022253000000003 60.197715 12.206213000000002 47.48052000000001 10.215053000000001C34.76333000000001 8.223173000000001 12.446920000000006 20.723563 12.446920000000006 20.723563L13.652170000000012 42.282593L15.999920000000003 48.935013L14.63064 49.326543C14.63064 49.326543 14.826040000000006 53.043563 16.391449999999992 55.586716C16.391449999999992 55.586716 18.543779999999998 66.34769 24.021619999999984 66.543098L28.326289999999986 79.064881L32.04331999999998 83.174148L34.97799999999998 91.78207L20.30458999999999 109.587L19.130719999999997 119.95644C19.130719999999997 119.95644 10.603379999999987 127.56165 12.812780000000004 139.99858H137.5z');
    });
    test('should work when reversed', () => {
        expect(new SVGPathData('m12.5 140c0 0 7.63017 -32.95472 17.21798 -45.085701c0 0 8.60793 -7.043235 12.91188 -7.630171c4.30396 -0.586937 31.109058 -1.173872 31.109058 -1.173872l8.021699 -9.821022h3.717026l1.173872 -15.810194l-3.521618 -3.717024l-1.564688 -9.782503l0.586937 -4.50008h1.760808c0 0 1.138927 -12.71791 0.977752 -14.0879c-0.160463 -1.36928 4.911579 -16.18532 17.628774 -18.17648c12.71719 -1.99188 35.0336 10.50851 35.0336 10.50851l-1.20525 21.55903l-2.34775 6.65242l1.36928 0.39153c0 0 -0.1954 3.71702 -1.76081 6.260173c0 0 -2.15233 10.760974 -7.63017 10.956382l-4.30467 12.521783l-3.71703 4.109267l-2.93468 8.607922l14.67341 17.80493l1.17387 10.36944c0 0 8.52734 7.60521 6.31794 20.04214h-124.68722z')
            .toAbs()
            .xSymmetry(150)
            .xSymmetry(150)
            .encode()).toEqual('M12.5 140C12.5 140 20.130169999999993 107.04527999999999 29.717979999999997 94.914299C29.717979999999997 94.914299 38.32590999999999 87.871064 42.62986000000001 87.284128C46.93382 86.69719099999999 73.738918 86.11025599999999 73.738918 86.11025599999999L81.760617 76.289234H85.477643L86.651515 60.47904L83.129897 56.762015999999996L81.565209 46.979513L82.152146 42.479433H83.912954C83.912954 42.479433 85.051881 29.761523 84.890706 28.391533000000003C84.730243 27.022253000000003 89.802285 12.206213000000002 102.51947999999999 10.215053000000001C115.23666999999999 8.223173000000001 137.55308 20.723563 137.55308 20.723563L136.34783 42.282593L134.00008 48.935013L135.36936 49.326543C135.36936 49.326543 135.17396 53.043563 133.60855 55.586716C133.60855 55.586716 131.45622 66.34769 125.97838000000002 66.543098L121.67371000000001 79.064881L117.95668000000002 83.174148L115.02200000000002 91.78207L129.69541 109.587L130.86928 119.95644C130.86928 119.95644 139.39662 127.56165 137.18722 139.99858H12.5z');
    });
});
describe('Y axis symmetry', () => {
    test('should work with an arbitrary path', () => {
        expect(new SVGPathData('m12.5 140c0 0 7.63017 -32.95472 17.21798 -45.085701c0 0 8.60793 -7.043235 12.91188 -7.630171c4.30396 -0.586937 31.109058 -1.173872 31.109058 -1.173872l8.021699 -9.821022h3.717026l1.173872 -15.810194l-3.521618 -3.717024l-1.564688 -9.782503l0.586937 -4.50008h1.760808c0 0 1.138927 -12.71791 0.977752 -14.0879c-0.160463 -1.36928 4.911579 -16.18532 17.628774 -18.17648c12.71719 -1.99188 35.0336 10.50851 35.0336 10.50851l-1.20525 21.55903l-2.34775 6.65242l1.36928 0.39153c0 0 -0.1954 3.71702 -1.76081 6.260173c0 0 -2.15233 10.760974 -7.63017 10.956382l-4.30467 12.521783l-3.71703 4.109267l-2.93468 8.607922l14.67341 17.80493l1.17387 10.36944c0 0 8.52734 7.60521 6.31794 20.04214h-124.68722z')
            .toAbs()
            .ySymmetry(150)
            .encode()).toEqual('M12.5 10C12.5 10 20.13017 42.95472000000001 29.71798 55.085701C29.71798 55.085701 38.32591 62.128935999999996 42.62986 62.715872000000005C46.93382 63.30280900000001 73.738918 63.88974400000001 73.738918 63.88974400000001L81.760617 73.710766H85.477643L86.651515 89.52096L83.129897 93.23798400000001L81.565209 103.020487L82.152146 107.520567H83.912954C83.912954 107.520567 85.051881 120.238477 84.890706 121.60846699999999C84.730243 122.977747 89.802285 137.793787 102.51947999999999 139.784947C115.23666999999999 141.776827 137.55308 129.276437 137.55308 129.276437L136.34783 107.71740700000001L134.00008 101.064987L135.36936 100.673457C135.36936 100.673457 135.17396 96.956437 133.60855 94.413284C133.60855 94.413284 131.45622 83.65231 125.97838000000002 83.456902L121.67371000000001 70.935119L117.95668000000002 66.825852L115.02200000000002 58.217929999999996L129.69541 40.413L130.86928 30.04356C130.86928 30.04356 139.39662 22.43835 137.18722 10.001419999999996H12.5z');
    });
    test('should work when reversed', () => {
        expect(new SVGPathData('m12.5 140c0 0 7.63017 -32.95472 17.21798 -45.085701c0 0 8.60793 -7.043235 12.91188 -7.630171c4.30396 -0.586937 31.109058 -1.173872 31.109058 -1.173872l8.021699 -9.821022h3.717026l1.173872 -15.810194l-3.521618 -3.717024l-1.564688 -9.782503l0.586937 -4.50008h1.760808c0 0 1.138927 -12.71791 0.977752 -14.0879c-0.160463 -1.36928 4.911579 -16.18532 17.628774 -18.17648c12.71719 -1.99188 35.0336 10.50851 35.0336 10.50851l-1.20525 21.55903l-2.34775 6.65242l1.36928 0.39153c0 0 -0.1954 3.71702 -1.76081 6.260173c0 0 -2.15233 10.760974 -7.63017 10.956382l-4.30467 12.521783l-3.71703 4.109267l-2.93468 8.607922l14.67341 17.80493l1.17387 10.36944c0 0 8.52734 7.60521 6.31794 20.04214h-124.68722z')
            .toAbs()
            .ySymmetry(150)
            .ySymmetry(150)
            .encode()).toEqual('M12.5 140C12.5 140 20.13017 107.04527999999999 29.71798 94.914299C29.71798 94.914299 38.32591 87.871064 42.62986 87.284128C46.93382 86.69719099999999 73.738918 86.11025599999999 73.738918 86.11025599999999L81.760617 76.289234H85.477643L86.651515 60.47904L83.129897 56.76201599999999L81.565209 46.979513L82.152146 42.479433H83.912954C83.912954 42.479433 85.051881 29.761522999999997 84.890706 28.39153300000001C84.730243 27.022253000000006 89.802285 12.206212999999991 102.51947999999999 10.215053000000012C115.23666999999999 8.223173000000003 137.55308 20.723563000000013 137.55308 20.723563000000013L136.34783 42.28259299999999L134.00008 48.935013L135.36936 49.326543C135.36936 49.326543 135.17396 53.043563000000006 133.60855 55.586715999999996C133.60855 55.586715999999996 131.45622 66.34769 125.97838000000002 66.543098L121.67371000000001 79.064881L117.95668000000002 83.174148L115.02200000000002 91.78207L129.69541 109.587L130.86928 119.95644C130.86928 119.95644 139.39662 127.56165 137.18722 139.99858H12.5z');
    });
});
//# sourceMappingURL=symmetry.test.js.map