const express = require('express');
const bodyParser = require('body-parser');
const { JSDOM } = require('jsdom');
const TextToSVG = require('text-to-svg');
const cors = require('cors');
const { decode } = require('html-entities');
const { DOMParser, XMLSerializer } = require('xmldom');
const xmlserializer = require('xmlserializer');
const https = require('https'); 
const { Console } = require('console');
const svgIntersections = require('svg-intersections');
const { shape, intersect } = svgIntersections;
const Flatten = require('@flatten-js/core');
const { Point, Polygon, Polyline } = Flatten;
const SvgPath = require('svgpath');
const ClipperLib = require('clipper-lib');
const SvgPathParser = require('svg-path-parser');
const dom = new JSDOM('<!DOCTYPE html><svg></svg>');
const Trademark = require('./Trademark');
const SvgDatabase = require('./SvgDatabase');
const LoginSystem = require('./LoginSystem');
const EffortDB = require('./EffortDB');
const MaintananceScreen = require('./MaintananceScreen');
const UserReports = require('./UserReports');
const ProductControl = require('./ProductControl');
const SquMeintenance = require('./SquMeintenance');
const app = express();

const port = 3003;
app.use(cors({
  origin: ['http://localhost:3003', 'http://localhost:3001', 'http://localhost:3000'], // bunu ekleyin
  credentials: true,
  methods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
  allowedHeaders: ['Content-Type', 'Authorization']
}));
app.use(express.json({ limit: '100mb' }));                // <= required for base64 JSON
app.use(express.urlencoded({ extended: true, limit: '100mb' }));
/*app.use(cors({
    origin: 'https://outlettee.com', // Doğru origin
    methods: 'GET, POST, PUT, DELETE, OPTIONS',
    allowedHeaders: 'Content-Type, Authorization'
}));

app.use(bodyParser.json({limit: '50mb'}));
app.use(bodyParser.urlencoded({limit: '50mb', extended: true}));

const privateKey = `-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEAvh2+YaxSxFl4wKgQYU+a6kw2d2GO4CMPjXgHpjhM7F9r8utQ
5ifOFMz/FDndCpO4dhnD/pv5ycITZsWb6pU+YCM4lhDGarJ0/q/FqF82opeZbmmv
vnP0Zw3V7wYIHM0WrTDh/8FdPLgk04IHvAvQ8a+Ghf21Eshtr2Thxc+abxXdcYAf
A86c/QmbVnDchR17yIdX50/Qdo59KTMKOWrKc1kWJiwcIhRmb1uK3Y/DK7NH+1/B
Laf/7H1lfYWU+OrKKWIWZFNr00qFF/3x1slfvigdrCn8k7MPnpqtBdFphmlAOIbq
urpbdBvBK1Q04+vw9ly8YzXuHLXZICh186PfJQIDAQABAoIBAAMVkykvfkpAwZ/3
FXao+OIPxORwfYXTgFvgi0WCtnVVz9NOIiXIlj+FJCca68iagHpiljIOmZh1RVwF
ZkGmOS/DFxa1Ta0LBx8EESPpo4agv7SxgGJ3Yvi7mhYeHyW2wTLszwXOY8Uyw97A
j4BG2IMmrjHyuPVhHy3ZVerpIIR6q1cw/VVnhqeZg/N3qTRlD80fAQv3ysUZHqDb
/YKaVimWUIi7Nf4T1AU2p1pqYyCfmXxJ9lS0+GbSvYIUv0I94gsEj4La1Uk4Yizx
6DRStCqJKkGvvJW4qlkQzOhjeVHuwfzQeDysefvgmOKth41PzH/a0IHMULXbQstK
e7nqQgECgYEA9v9ZtaB3r43/kOVudDjJbttaHslf9n/KXIvU2Zm0AGgGm8NOQCtx
n9SY0G645JHDCZN1OJ8CJIcCSUSBm2rpVCRnGCBHzweEBxziYusHXPeXvQR510Nb
G9sHTW+4b/yapGynp/g27hEItW+QJlvrWctW9HWIjb2S6sbZfIMt8CUCgYEAxQun
QcnF+zbCU/O5wPo+ku1/qrPlLsMK2EP+OB4BWYhcaCUMOWKZiKmhPm6gbQUMO+Ms
X/rFcRcot+UpsgL0t5Y/pItWGYqNWWx6RNw7hWAIWlPLmRq6I5sxNeuesdNl44f/
9cML9norcFjt4Tvzs+MTCjgEhPIoBRtyiWpXgwECgYBwb3Ld3As/jgs9YUNzgnon
jZCrnQ2i/y8WC807tN0cpj4D39caHOyfTj61+wENg1DeZhKhULi/+flPcvDw160Z
UWzgrakilBBE0KA5WTXD2y1mrMft9spdlsnvNSEnUTzwBkoXi0Ut//EP7pYW8Bbl
jEusAmjD5P0hBJ3yMSDTRQKBgGtuDhO1QabUVSDWafkHtqP+rrNP/2z+U+RTNcA8
w7mfudniEQccdd7ntQzH3dlyfhgMpH3zyD//Q2j3nUL7j5akaTB580hbnPMbTJJM
jHsMP6GXvBJOWxvcmfju7IfBXPSvimLgo54PP62yHofFWvpBnHjez7/4Es+uBkVb
YDkBAoGBAN2Jk7k5s7F7wBROv0Qzida/kfOQrLoc1PFdnCmunJIlTwDo7Ug1sfac
yxq8hRmhTDK6pERoSL6ANXRW45nYO9FkaZLVKUx4Md8PDYnGkSNIqRJtyMnAG+bP
2krUQ9em6RWbNJM3SgMgf8A1Ra2Q7ZYpHAj2fe4Q7n227lJv/v3b
-----END RSA PRIVATE KEY-----`;

const certificate = `-----BEGIN CERTIFICATE-----
MIIFDDCCA/SgAwIBAgISBhXd3dBz2/B96PfX/tGxNpLKMA0GCSqGSIb3DQEBCwUA
MDMxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1MZXQncyBFbmNyeXB0MQwwCgYDVQQD
EwNSMTMwHhcNMjUwOTAxMjAzODM1WhcNMjUxMTMwMjAzODM0WjAcMRowGAYDVQQD
ExF3d3cub3V0bGV0dGVlLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBAL4dvmGsUsRZeMCoEGFPmupMNndhjuAjD414B6Y4TOxfa/LrUOYnzhTM/xQ5
3QqTuHYZw/6b+cnCE2bFm+qVPmAjOJYQxmqydP6vxahfNqKXmW5pr75z9GcN1e8G
CBzNFq0w4f/BXTy4JNOCB7wL0PGvhoX9tRLIba9k4cXPmm8V3XGAHwPOnP0Jm1Zw
3IUde8iHV+dP0HaOfSkzCjlqynNZFiYsHCIUZm9bit2PwyuzR/tfwS2n/+x9ZX2F
lPjqyiliFmRTa9NKhRf98dbJX74oHawp/JOzD56arQXRaYZpQDiG6rq6W3QbwStU
NOPr8PZcvGM17hy12SAodfOj3yUCAwEAAaOCAi8wggIrMA4GA1UdDwEB/wQEAwIF
oDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDAYDVR0TAQH/BAIwADAd
BgNVHQ4EFgQUv6ztmQM1w0fiGQLPoh1eNZCoUP4wHwYDVR0jBBgwFoAU56ufDywz
oFPTXk94yLKEDjvWkjMwMwYIKwYBBQUHAQEEJzAlMCMGCCsGAQUFBzAChhdodHRw
Oi8vcjEzLmkubGVuY3Iub3JnLzArBgNVHREEJDAigg1vdXRsZXR0ZWUuY29tghF3
d3cub3V0bGV0dGVlLmNvbTATBgNVHSAEDDAKMAgGBmeBDAECATAuBgNVHR8EJzAl
MCOgIaAfhh1odHRwOi8vcjEzLmMubGVuY3Iub3JnLzc1LmNybDCCAQMGCisGAQQB
1nkCBAIEgfQEgfEA7wB1AMz7D2qFcQll/pWbU87psnwi6YVcDZeNtql+VMD+TA2w
AAABmQc2VlsAAAQDAEYwRAIgeqTmZ6aUq/EdxtJLC0AwH+Izs2KVqnHdwf+x4iIH
K70CIDuksE4naN/z7mE4GdCENQUf2EZnOH5fu1aJgptuuLTMAHYAGgT/SdBUHUCv
9qDDv/HYxGcvTuzuI0BomGsXQC7ciX0AAAGZBzZWYgAABAMARzBFAiBEJK18aEma
X4PmRzHBXxsFRG8NVHKTUa11p6APYRUVGQIhAIMSqqA54lMv0YpUvml3/xA9OIar
BVWrtt/1INctf4X9MA0GCSqGSIb3DQEBCwUAA4IBAQBib8JALPZaMyE5gCCuhZt1
TbtoYALE1TRIAzUvaaShCdMmcUjbxr75N4vYMjlCp/KQFbyJm/PqAOI8QNV7KGJp
Tubrgxklnx42Wfr0f8upCuPx5SDcdetnHnjBumIQqbZasukgvOciXOMK4BYRUUv+
BYypGehp/uEaU0Vaclfb28ZLtmDSCr7lMMulYwNrX/wL92laFeWt9dVaSZf5WByd
A86ALBheXwTY+Ep+2h3nDnFwaQVwVNeC1IRv+I2SQmDMUjudecc9BvdxyiSjTpfm
lD+g+woxRc7lZhViYQEpbBPiMEPZLDCV7Y1BcwD/tzpmIcrqnAdniWwr9ZLMBl7I
-----END CERTIFICATE-----`;

const options = {
  key: privateKey,
  cert: certificate
};*/

app.use(express.json());

app.use('/api', Trademark);
app.use('/api', SvgDatabase);
app.use('/api', LoginSystem);
app.use('/api', EffortDB);
app.use('/api', MaintananceScreen);
app.use('/api', UserReports);
app.use('/api', SquMeintenance);

app.use( ProductControl);

app.post('/process-svg', (req, res) => {
    const svg = req.body.svg;
    const rects = req.body.rects;
    const rectLogs = rects.map((rect, index) => `Rect ${index + 1}: x = ${rect.x || 'N/A'}, y = ${rect.y || 'N/A'}`).join(', ');
    const fontStatus = req.body.fontStatus;
    console.log(rectLogs);
    const fontName = req.body.rects[0].fontFamily;
    let fontNameWithoutExtension = '';
    if (fontName && typeof fontName === 'string') {
        fontNameWithoutExtension = fontName.split('.').slice(0, -1).join('.');
    }
    const lineHei = req.body.lineHeight;
    const alignment = req.body.alignment;
    const designType = req.body.designType;
    const adminPanel = req.body.adminPanel;
    let status = '1';
    let path  = status === '0' ?  'C:/Users/bagde/Project' : '/home/outlettee/public_html';

    const textToSVG = TextToSVG.loadSync(path + '/leather-image-server/Fonts/'+fontName);
    const dom = new JSDOM(svg, { contentType: "image/svg+xml" });
    const testSVG = req.body.test;
    
    const styleElement = dom.window.document.createElement('style');
    const productDimensions = req.body.dimensions;
    
    ///home/outlettee/public_html C:/Users/bagde/Project/

    function loadFontForRect(fontName) {
        const fontNameWithoutExtension = fontName.split('.').slice(0, -1).join('.');
        const fontPath = path + `/leather-image-server/Fonts/${fontName}`;
        
        return {
            textToSVG: TextToSVG.loadSync(fontPath),
            fontNameWithoutExtension: fontNameWithoutExtension
        };
    }

     function getTextDimensions(text, fontSize, textToSVG) {
        const options = {
            x: 0,
            y: 0,
            fontSize,
            anchor: 'left top',
            attributes: { fill: 'red', stroke: 'none' }
        };
        const metrics = textToSVG.getMetrics(text.replace(/\n/g, ' '), options);
        return { width: metrics.width, height: metrics.height };
    }

    function adjustFontSizeToFit(text, rectWidth, textHei, textToSVG) {
        let fontSize = 1000; 
        let dimensions = getTextDimensions(text, fontSize, textToSVG);
    
        while (dimensions.width > rectWidth || dimensions.height > textHei) {
            fontSize -= 1; 
            dimensions = getTextDimensions(text, fontSize, textToSVG);
            if (fontSize <= 1) break;
        }
        return fontSize; 
    }

    function getTextDimensions(text, fontSize, textToSVG) {
        const options = {
            x: 0,
            y: 0,
            fontSize,
            anchor: 'left top',
            attributes: { fill: 'red', stroke: 'none' }
        };
        const metrics = textToSVG.getMetrics(text.replace(/\n/g, ' '), options);
        return { width: metrics.width, height: metrics.height };
    }

    function adjustFontSizeToFit(text, rectWidth, textHei, textToSVG) {
        let fontSize = 1000; 
        let dimensions = getTextDimensions(text, fontSize, textToSVG);
    
        while (dimensions.width > rectWidth || dimensions.height > textHei) {
            fontSize -= 1; 
            dimensions = getTextDimensions(text, fontSize, textToSVG);
            if (fontSize <= 1) break;
        }
        return fontSize; 
    }

    function renderText(text, rect, alignment, textToSVG, fontNameWithoutExtension) {
       
        const lines = text.split('\n');
        let fontSize = 65;
        let lineHeight = lineHei; 
        let clipperPaths = [];
        const scale = 1000;
        
        lines.forEach((line, index) => {
            const yOffset = lineHeight * index;
            let x;
            
            const lineDimensions = getTextDimensions(line, fontSize, textToSVG);
            
            if (alignment === 'left') {
                x = rect.x;
            } else if (alignment === 'center') {
                x = rect.x + (rect.width - lineDimensions.width) / 2;
            } else if (alignment === 'right') {
                x = rect.x + rect.width - lineDimensions.width;
            }
            
            const options = {
                x: x,
                y: rect.y + yOffset + (lineHeight / 1.2),
                fontSize: fontSize, 
                anchor: 'left top',
                attributes: { fill: 'red', stroke: 'none', 'font-family': fontNameWithoutExtension }
            };
           
            try {
                let pathData = textToSVG.getD(line, options);
                let clipperPath = svgPathToClipper(pathData, scale);
                clipperPaths = clipperPaths.concat(clipperPath);
            } catch (error) {
               //console.error(`Error processing text: ${line}`, error);
            }
        });
        
        const solutionPaths = new ClipperLib.Paths();
        const cpr = new ClipperLib.Clipper();
        
        cpr.AddPaths(clipperPaths, ClipperLib.PolyType.ptSubject, true);
        
        cpr.Execute(
            ClipperLib.ClipType.ctUnion,
            solutionPaths,
            ClipperLib.PolyFillType.pftNonZero,
            ClipperLib.PolyFillType.pftNonZero
        );
        
        const combinedTextPathData = clipperPathsToSvgPath(solutionPaths, scale);
        try{
            if (combinedTextPathData !== '') {
                const combinedPathElement = dom.window.document.createElementNS('http://www.w3.org/2000/svg', 'path');
                combinedPathElement.setAttribute('d', combinedTextPathData.trim());
                
                const centerX = rect.x + rect.width / 2;
                const centerY = rect.y + rect.height / 2;
                combinedPathElement.setAttribute('transform', `rotate(${rect.rotationAngle1}, ${centerX}, ${centerY})`);        
                dom.window.document.querySelector('svg').appendChild(combinedPathElement);
            }
        }catch(error)
        {console.log(error);}
       
    }
    function splitTextToFitRectangles(rects) {
        let parts = [];
        let fontSizes = [];
    
        function calculateFontSizes(rects) {
            let sizes = [];
            let index = 1;
            for (let fontRect of rects) {
                const textKey = `text${index}`;
                const heightKey = `textHeight${index}`;
                let text = fontRect[textKey];
                let heightLabel = fontRect.textHeight;
    
                if (text) {
                    const { textToSVG } = loadFontForRect(fontRect.fontFamily);
                    let fontSize = adjustFontSizeToFit(text, fontRect.width, heightLabel, textToSVG);
                    sizes.push(fontSize);
                } else {
                    // console.error(`Text for rect ${JSON.stringify(fontRect)} is undefined or empty`);
                    sizes.push(null); // Ensure the array indices align
                }
    
                index++;
            }
            return sizes;
        }
    
        // Adjust font sizes based on the specified index groups
        function adjustFontSizes(fontSizes, fontSizeGroups) {
            for (let group of fontSizeGroups) {
                let indices = group.map(i => i - 1); // Adjust for 0-based index
                let relevantSizes = indices.map(i => fontSizes[i]).filter(size => size !== null);
                let minSize = Math.min(...relevantSizes);
                indices.forEach(i => {
                    if (fontSizes[i] !== null) {
                        fontSizes[i] = minSize;
                    }
                });
            }
        }
    
        // Calculate initial font sizes for all rectangles
        fontSizes = calculateFontSizes(rects);
    
        let fontSizeGroups = [];

        if (designType) {
         
            let indices = designType.split(',').map(Number);
           
            fontSizeGroups.push(indices);
        }else{
            fontSizeGroups = [[1]];
        }

        adjustFontSizes(fontSizes, fontSizeGroups);
    
        let index = 1;
        for (let rect of rects) {
            const textKey = `text${index}`;
            const heightKey = `textHeight${index}`;
            let text = rect[textKey];
            let heightLabel = rect.textHeight;
    
            if (!text) {
                // console.error(`Text for rect ${JSON.stringify(rect)} is undefined or empty`);
                index++;
                continue;
            }
    
            const { textToSVG, fontNameWithoutExtension } = loadFontForRect(rect.fontFamily);
            // Use the adjusted font size
            let fontSize = fontSizes[index - 1];
    
            console.log(`Font size for index ${index}: ${fontSize}`);
            let dimensions = getTextDimensions(text, fontSize, textToSVG);
    
            while (dimensions.height > rect.height) {
                let fittingPart = '';
                for (let j = 1; j <= text.length; j++) {
                    let part = text.slice(0, j);
                    dimensions = getTextDimensions(part, fontSize, textToSVG);
                    if (dimensions.height > rect.height) {
                        fittingPart = text.slice(0, j - 1);
                        text = text.slice(j - 1);
                        break;
                    }
                }
                parts.push({ text: fittingPart, fontSize, rect, textToSVG, fontNameWithoutExtension });
                if (fittingPart === '') break;
            }
            parts.push({ text, fontSize, rect, textToSVG, fontNameWithoutExtension });
            index++;
        }
    
        return parts;
    }

    const textParts = splitTextToFitRectangles(rects);

    if(fontStatus === 'true'){
      
        for (let part of textParts) {
            const { text, rect, textToSVG, fontNameWithoutExtension } = part;
            renderText(text, rect, alignment, textToSVG, fontNameWithoutExtension);
        }
    }
    else
    {
        let centerX;
        let centerY;

        for (let part of textParts) {
         
            const { text, fontSize, rect, textToSVG, fontNameWithoutExtension } = part;
            const dimensions = getTextDimensions(text, fontSize, textToSVG);
            const textX = rect.x + (rect.width - dimensions.width) / 2;
            const textY = rect.y + (rect.height - dimensions.height) / 2;
           let curve = rect.textCurve;
           if(curve === undefined){
            curve = 0;
           }
            const options = {
                x: textX,
                y: textY,
                fontSize,
                anchor: 'left top',
                attributes: {
                    fill: 'none',
                    stroke: 'red',
                    'font-family': fontNameWithoutExtension
                }
            };

            try {
                // Generate path data for this textPart
                let pathData = textToSVG.getD(text, options);
                let clipperPath = svgPathToClipper(pathData);

                const solutionPaths = new ClipperLib.Paths();
                const cpr = new ClipperLib.Clipper();

                cpr.AddPaths(clipperPath, ClipperLib.PolyType.ptSubject, true);

                cpr.Execute(
                    ClipperLib.ClipType.ctUnion,
                    solutionPaths,
                    ClipperLib.PolyFillType.pftNonZero,
                    ClipperLib.PolyFillType.pftNonZero
                );

                let combinedTextPathData = clipperPathsToSvgPath(solutionPaths);
                const svgElement = dom.window.document.querySelector('svg');
                if (!svgElement) {
                  console.error('SVG element not found in the DOM!');
                  return;
                }
                if (combinedTextPathData !== '') {
                    // Apply the curve for this rectangle
                    combinedTextPathData = applyCurve(combinedTextPathData,curve);
                 
                    const combinedTextPathElement = dom.window.document.createElementNS('http://www.w3.org/2000/svg', 'path');
                    combinedTextPathElement.setAttribute('d', combinedTextPathData);

                    combinedTextPathElement.setAttribute('fill', '');

                    // Calculate centerX and centerY for this rectangle
                    centerX = rect.x + rect.width / 2;
                    centerY = rect.y + rect.height / 2;

                    combinedTextPathElement.setAttribute('transform', `rotate(${rect.rotationAngle}, ${centerX}, ${centerY})`);

                    dom.window.document.querySelector('svg').appendChild(combinedTextPathElement);
                }
            } catch (error) {
                console.log('A' + error);
            }
        }
    }

    
   // SVG path verisini Clipper path'lerine dönüştüren fonksiyon
   function svgPathToClipper(svgPathData, scale = 1000) {
    const segments = SvgPathParser.parseSVG(svgPathData);
    let paths = [];
    let currentPath = [];
    let startX = 0, startY = 0;
    let currentX = 0, currentY = 0;
    for (let segment of segments) {
        switch (segment.code) {
            case 'M':
                if (currentPath.length > 0) {
                    paths.push(currentPath);
                    currentPath = [];
                }
                startX = currentX = segment.x * scale;
                startY = currentY = segment.y * scale;
                currentPath.push({ X: currentX, Y: currentY });
                break;
            case 'L':
                currentX = segment.x * scale;
                currentY = segment.y * scale;
                currentPath.push({ X: currentX, Y: currentY });
                break;
            case 'C':
                // Bezier eğrilerini line segmentlere yaklaştırma
                let bezierPoints = approximateCubicBezier(
                    { x: currentX, y: currentY },
                    { x: segment.x1 * scale, y: segment.y1 * scale },
                    { x: segment.x2 * scale, y: segment.y2 * scale },
                    { x: segment.x * scale, y: segment.y * scale }
                );
                bezierPoints.shift(); // İlk noktayı kaldır (zaten mevcut)
                currentPath = currentPath.concat(bezierPoints.map(p => ({ X: p.x, Y: p.y })));
                currentX = segment.x * scale;
                currentY = segment.y * scale;
                break;
            case 'Q':
                // Quadratic Bezier eğrilerini line segmentlere yaklaştırma
                let quadraticBezierPoints = approximateQuadraticBezier(
                    { x: currentX, y: currentY },
                    { x: segment.x1 * scale, y: segment.y1 * scale },
                    { x: segment.x * scale, y: segment.y * scale }
                );
                quadraticBezierPoints.shift(); // İlk noktayı kaldır (zaten mevcut)
                currentPath = currentPath.concat(quadraticBezierPoints.map(p => ({ X: p.x, Y: p.y })));
                currentX = segment.x * scale;
                currentY = segment.y * scale;
                break;
            case 'Z':
                currentPath.push({ X: startX, Y: startY });
                break;
            default:
                console.warn(`Unhandled SVG command: ${segment.code}`);
        }
    }
    if (currentPath.length > 0) {
        paths.push(currentPath);
    }
    return paths;
}
function approximateQuadraticBezier(p0, p1, p2, segments = 10) {
    let points = [];
    for (let i = 1; i <= segments; i++) {
        const t = i / segments;
        const x = quadraticBezier(p0.x, p1.x, p2.x, t);
        const y = quadraticBezier(p0.y, p1.y, p2.y, t);
        points.push({ x, y });
    }
    return points;
}

function quadraticBezier(p0, p1, p2, t) {
    return (
        Math.pow(1 - t, 2) * p0 +
        2 * (1 - t) * t * p1 +
        Math.pow(t, 2) * p2
    );
}
// Bezier eğrilerini line segmentlere yaklaştıran fonksiyon
function approximateCubicBezier(p0, p1, p2, p3, segments = 10) {
    let points = [];
    for (let i = 1; i <= segments; i++) {
        const t = i / segments;
        const x = cubicBezier(p0.x, p1.x, p2.x, p3.x, t);
        const y = cubicBezier(p0.y, p1.y, p2.y, p3.y, t);
        points.push({ x, y });
    }
    return points;
}

// Cubic Bezier hesaplama fonksiyonu
function cubicBezier(p0, p1, p2, p3, t) {
    return (
        Math.pow(1 - t, 3) * p0 +
        3 * Math.pow(1 - t, 2) * t * p1 +
        3 * (1 - t) * Math.pow(t, 2) * p2 +
        Math.pow(t, 3) * p3
    );
}

// Clipper path'lerini SVG path verisine dönüştüren fonksiyon
function clipperPathsToSvgPath(clipperPaths, scale = 1000) {
    let svgPath = '';
    for (let path of clipperPaths) {
        if (path.length === 0) continue;
        svgPath += `M${path[0].X / scale},${path[0].Y / scale} `;
        for (let i = 1; i < path.length; i++) {
            svgPath += `L${path[i].X / scale},${path[i].Y / scale} `;
        }
        svgPath += 'Z ';
    }
    return svgPath.trim();
}
function applyCurve(pathData, curveIntensity = 5, direction = 1) {
    const scale = 1000; // Mevcut ölçekleme ile uyumlu olması için
    const paths = SvgPathParser.parseSVG(pathData);
    let newPathData = '';
    let minY = Infinity, maxY = -Infinity;
    let minX = Infinity, maxX = -Infinity;
    
    // Önce boundary'leri bulalım
    for (let segment of paths) {
        if (segment.x !== undefined) {
            minX = Math.min(minX, segment.x);
            maxX = Math.max(maxX, segment.x);
        }
        if (segment.y !== undefined) {
            minY = Math.min(minY, segment.y);
            maxY = Math.max(maxY, segment.y);
        }
    }
    
    const centerY = (minY + maxY) / 2;
    const width = maxX - minX;
    
    // Her nokta için curve uygula
    for (let segment of paths) {
        switch (segment.code) {
            case 'M':
            case 'L':
                const curveOffset = calculateCurveOffset(
                    segment.x - minX,
                    width,
                    curveIntensity,
                    direction
                );
                const newY = segment.y + curveOffset;
                newPathData += `${segment.code}${segment.x},${newY} `;
                break;
            case 'C':
                const offset1 = calculateCurveOffset(
                    segment.x1 - minX,
                    width,
                    curveIntensity,
                    direction
                );
                const offset2 = calculateCurveOffset(
                    segment.x2 - minX,
                    width,
                    curveIntensity,
                    direction
                );
                const offset3 = calculateCurveOffset(
                    segment.x - minX,
                    width,
                    curveIntensity,
                    direction
                );
                newPathData += `C${segment.x1},${segment.y1 + offset1} ${segment.x2},${segment.y2 + offset2} ${segment.x},${segment.y + offset3} `;
                break;
            case 'Q':
                const offsetQ1 = calculateCurveOffset(
                    segment.x1 - minX,
                    width,
                    curveIntensity,
                    direction
                );
                const offsetQ2 = calculateCurveOffset(
                    segment.x - minX,
                    width,
                    curveIntensity,
                    direction
                );
                newPathData += `Q${segment.x1},${segment.y1 + offsetQ1} ${segment.x},${segment.y + offsetQ2} `;
                break;
            case 'Z':
                newPathData += 'Z ';
                break;
        }
    }
    
    return newPathData.trim();
}

// Curve offset'ini hesaplayan yardımcı fonksiyon
function calculateCurveOffset(x, width, intensity, direction) {
    // Parabol formülü: y = a * (x - h)^2 + k
    // Burada a değeri curve intensity'ye göre ayarlanır
    const normalizedX = (x / width) * 2 - 1; // -1 ile 1 arasına normalize et
    return direction * intensity * 20 * (normalizedX * normalizedX - 0.25);
}   
    if(adminPanel === true){
       
        //diktorgen cizgileri icin
        for (let rect of rects) { 
            console.log(rect);
            const rectElement = dom.window.document.createElementNS('http://www.w3.org/2000/svg', 'rect'); 
            rectElement.setAttribute('x', rect.x);  
            rectElement.setAttribute('y', rect.y);
            rectElement.setAttribute('width', rect.width);
            rectElement.setAttribute('height', rect.height);
            rectElement.setAttribute('stroke', 'red');
            rectElement.setAttribute('fill', 'none');
            rectElement.setAttribute('stroke-width', '1');
        
            // Dikdörtgenin merkezini hesaplama
            const centerX = rect.x + rect.width / 2;
            const centerY = rect.y + rect.height / 2;
        
            // Dikdörtgeni rotasyonla
            rectElement.setAttribute('transform', `rotate(${rect.rotationAngle}, ${centerX}, ${centerY})`);
        
            // SVG'ye dikdörtgeni ekleme
            dom.window.document.querySelector('svg').appendChild(rectElement);
        }
    }

    const textElements = dom.window.document.querySelectorAll('text');
    textElements.forEach(textElement => textElement.remove());
    
    if(testSVG === false){
        let svgElement = dom.window.document.querySelector('svg');
        
        let dimwnsionWidth = productDimensions.width !== '' ?  productDimensions.width * 96 : 500;
        let dimwnsionHeight = productDimensions.height !== '' ?  productDimensions.height * 96 : 500;
    
        if (svgElement) {
            svgElement.setAttribute('width', dimwnsionWidth);
            svgElement.setAttribute('height', dimwnsionHeight);
            
        }
    }
    
    let processedSVG = dom.window.document.documentElement.outerHTML;
    processedSVG = processedSVG.replace(new RegExp(`&lt;path fill=&quot;red&quot; stroke=&quot;none&quot; font-family=&quot;.*?&quot; d=&quot;`, 'g'), '');
    processedSVG = processedSVG.replace(/&quot;\/&gt;/g, '');
    
    res.type('image/svg+xml');
    res.send(processedSVG);
});


// canlida aç
  /*https.createServer(options, app).listen(3003, () => {
    console.log('HTTPS server listening on port 3003');
  });*/

 
app.listen(port, () => {
    console.log(`HTTP server listening on http://localhost:${port}`);
});